/*
 * Decompiled with CFR 0.152.
 */
package util.json;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import util.json.CustomEncoder;
import util.json.DynamicEncoder;
import util.json.Encoder;
import util.json.JSONException;
import util.json.Lexer;

public class JSON {
    LexerCB cb;
    Object obj;

    public JSON() {
        this(NumberType.BigDecimal);
    }

    public JSON(NumberType type) {
        this.cb = new LexerCB(type);
    }

    public static Object parse(String json) {
        return JSON.parse(json, NumberType.BigDecimal);
    }

    public static Object parse(String json, NumberType type) {
        LexerCB cb = new LexerCB(type);
        Lexer.lexer.lex(json.getBytes(), cb);
        return cb.stack.pop();
    }

    public static String jsonify(Object o) {
        Encoder e = new Encoder();
        e.encode(o);
        return e.buf.toString();
    }

    public static String jsonifyDynamic(Object o) {
        DynamicEncoder e = new DynamicEncoder();
        e.encode(o);
        return e.buf.toString();
    }

    public static String jsonifyCustom(Object o, CustomEncoder enc) {
        enc.encode(o);
        return enc.buf.toString();
    }

    public void parse(byte[] arr) {
        this.parse(arr, 0, arr.length);
    }

    public void parse(byte[] arr, int off, int len) {
        Lexer.lexer.lex(arr, off, len, this.cb);
    }

    public boolean done() {
        return this.cb.done;
    }

    public void reset() {
        this.cb.reset();
    }

    public Object obj() {
        if (!this.done()) {
            throw new JSONException("not done!");
        }
        if (null == this.obj) {
            this.obj = this.cb.stack.pop();
        }
        return this.obj;
    }

    static class Key {
        String string;

        Key(String string) {
            this.string = string;
        }
    }

    public static class LexerCB
    extends Lexer.CB {
        Stack<Object> stack = new Stack();
        boolean done;
        boolean expectNextCommaOrRCurly;
        NumberType type;

        public LexerCB(NumberType type) {
            this.type = type;
        }

        public LexerCB() {
            this(NumberType.BigDecimal);
        }

        @Override
        public void reset() {
            super.reset();
            this.stack = new Stack();
            this.done = false;
            this.expectNextCommaOrRCurly = false;
        }

        @Override
        void tok(Lexer.Token t) {
            if (this.done) {
                this.error();
            }
            if (this.expectNextCommaOrRCurly) {
                switch (t) {
                    case RCURLY: 
                    case COMMA: {
                        this.expectNextCommaOrRCurly = false;
                        break;
                    }
                    default: {
                        this.error("unbalanced key value pairs");
                    }
                }
            }
            switch (t) {
                case LCURLY: {
                    this.stack.push(this.map());
                    break;
                }
                case LSQUARE: {
                    this.stack.push(this.list());
                    break;
                }
                case RCURLY: {
                    if (!(this.stack.peek() instanceof Map)) {
                        this.error("misplaced }");
                    }
                    Map m = (Map)this.stack.pop();
                    this.stash(m);
                    break;
                }
                case RSQUARE: {
                    if (!(this.stack.peek() instanceof List)) {
                        this.error("misplaced ]");
                    }
                    List l = (List)this.stack.pop();
                    this.stash(l);
                    break;
                }
                case TRUE: {
                    this.stash(true);
                    break;
                }
                case FALSE: {
                    this.stash(false);
                    break;
                }
                case NULL: {
                    this.stash(null);
                    break;
                }
                case COMMA: {
                    break;
                }
                case COLON: {
                    if (this.stack.peek() instanceof Key) break;
                    this.error("misplaced :");
                    break;
                }
                default: {
                    this.error();
                }
            }
        }

        @Override
        void tok(String s) {
            if (this.done) {
                this.error();
            }
            if (this.stack.peek() instanceof Map) {
                this.stack.push(new Key(s));
            } else {
                this.stash(s);
            }
        }

        @Override
        void numberToken(CharSequence cs) {
            Number o;
            switch (this.type) {
                case BigDecimal: {
                    o = new BigDecimal(cs.toString());
                    break;
                }
                case Double: {
                    o = Double.parseDouble(cs.toString());
                    break;
                }
                case Float: {
                    o = Float.valueOf(Float.parseFloat(cs.toString()));
                    break;
                }
                case Integer: {
                    o = Integer.parseInt(cs.toString(), 10);
                    break;
                }
                case Long: {
                    o = Long.parseLong(cs.toString(), 10);
                    break;
                }
                default: {
                    throw new JSONException("cannot happen: unknown number type");
                }
            }
            this.stash(o);
        }

        void stash(Object o) {
            if (0 == this.stack.size()) {
                this.done = true;
                this.stack.push(o);
                return;
            }
            Object top = this.stack.peek();
            if (top instanceof List) {
                ((List)top).add(o);
            } else if (top instanceof Key) {
                String key = ((Key)this.stack.pop()).string;
                assert (this.stack.size() > 0);
                assert (this.stack.peek() instanceof Map);
                ((Map)this.stack.peek()).put(key, o);
                this.expectNextCommaOrRCurly = true;
            } else {
                this.error("unexpected: " + o.getClass().getName() + " after: " + this.stack.peek().getClass().getName());
            }
        }

        Map map() {
            return new HashMap();
        }

        List list() {
            return new LinkedList();
        }

        void error() {
            this.error("calling parser in done state. did you forget to call reset()?");
        }

        void error(String m) {
            throw new JSONException(m);
        }
    }

    public static enum NumberType {
        BigDecimal,
        Integer,
        Long,
        Float,
        Double;

    }
}

