/*
 * Decompiled with CFR 0.152.
 */
package util.json;

import util.json.JSONException;

public class Lexer {
    public static Lexer lexer = new Lexer();

    public void lex(byte[] arr, CB cb) {
        this.lex(arr, 0, arr.length, cb);
    }

    public void lex(byte[] arr, int off, int len, CB cb) {
        int i = off;
        int end = off + len;
        while (i != end) {
            byte c = arr[i];
            block0 : switch (cb.state) {
                case VALUE: {
                    if (this.isWS(c)) break;
                    switch (c) {
                        case 34: {
                            cb.state = State.STRING_START;
                            cb.cache = new StringBuilder();
                            break block0;
                        }
                        case 45: 
                        case 48: 
                        case 49: 
                        case 50: 
                        case 51: 
                        case 52: 
                        case 53: 
                        case 54: 
                        case 55: 
                        case 56: 
                        case 57: {
                            cb.state = State.NUMBER_START;
                            cb.cache = new StringBuilder();
                            cb.cache.append((char)c);
                            break block0;
                        }
                        case 123: {
                            cb.state = State.VALUE;
                            cb.tok(Token.LCURLY);
                            break block0;
                        }
                        case 125: {
                            cb.state = State.AFTER_VALUE;
                            cb.tok(Token.RCURLY);
                            break block0;
                        }
                        case 91: {
                            cb.state = State.VALUE;
                            cb.tok(Token.LSQUARE);
                            break block0;
                        }
                        case 93: {
                            cb.state = State.AFTER_VALUE;
                            cb.tok(Token.RSQUARE);
                            break block0;
                        }
                        case 116: {
                            cb.state = State.T;
                            break block0;
                        }
                        case 102: {
                            cb.state = State.F;
                            break block0;
                        }
                        case 110: {
                            cb.state = State.N;
                            break block0;
                        }
                    }
                    this.error(cb, c);
                }
                case T: {
                    if (114 == c) {
                        cb.state = State.TR;
                        break;
                    }
                    this.error(cb, c);
                }
                case TR: {
                    if (117 == c) {
                        cb.state = State.TRU;
                        break;
                    }
                    this.error(cb, c);
                }
                case TRU: {
                    if (101 == c) {
                        cb.tok(Token.TRUE);
                        cb.state = State.AFTER_VALUE;
                        break;
                    }
                    this.error(cb, c);
                }
                case F: {
                    if (97 == c) {
                        cb.state = State.FA;
                        break;
                    }
                    this.error(cb, c);
                }
                case FA: {
                    if (108 == c) {
                        cb.state = State.FAL;
                        break;
                    }
                    this.error(cb, c);
                }
                case FAL: {
                    if (115 == c) {
                        cb.state = State.FALS;
                        break;
                    }
                    this.error(cb, c);
                }
                case FALS: {
                    if (101 == c) {
                        cb.tok(Token.FALSE);
                        cb.state = State.AFTER_VALUE;
                        break;
                    }
                    this.error(cb, c);
                }
                case N: {
                    if (117 == c) {
                        cb.state = State.NU;
                        break;
                    }
                    this.error(cb, c);
                }
                case NU: {
                    if (108 == c) {
                        cb.state = State.NUL;
                        break;
                    }
                    this.error(cb, c);
                }
                case NUL: {
                    if (108 == c) {
                        cb.tok(Token.NULL);
                        cb.state = State.AFTER_VALUE;
                        break;
                    }
                    this.error(cb, c);
                }
                case AFTER_VALUE: {
                    if (this.isWS(c)) break;
                    switch (c) {
                        case 125: {
                            cb.tok(Token.RCURLY);
                            break block0;
                        }
                        case 93: {
                            cb.tok(Token.RSQUARE);
                            break block0;
                        }
                        case 44: {
                            cb.tok(Token.COMMA);
                            break block0;
                        }
                        case 58: {
                            cb.tok(Token.COLON);
                            break block0;
                        }
                    }
                    --i;
                    --cb.pos;
                    cb.state = State.VALUE;
                    break;
                }
                case NUMBER_START: {
                    switch (c) {
                        case 43: 
                        case 45: 
                        case 46: 
                        case 48: 
                        case 49: 
                        case 50: 
                        case 51: 
                        case 52: 
                        case 53: 
                        case 54: 
                        case 55: 
                        case 56: 
                        case 57: 
                        case 69: 
                        case 101: {
                            cb.cache.append((char)c);
                            break block0;
                        }
                    }
                    cb.numberToken(cb.cache);
                    --i;
                    --cb.pos;
                    cb.state = State.AFTER_VALUE;
                    break;
                }
                case STRING_START: {
                    switch (c) {
                        case 34: {
                            cb.tok(cb.cache.toString());
                            cb.state = State.AFTER_VALUE;
                            break block0;
                        }
                        case 92: {
                            cb.state = State.STR_ESC;
                            break block0;
                        }
                    }
                    if (Character.isISOControl(c)) {
                        this.error(cb, c);
                    }
                    cb.cache.append((char)c);
                    break;
                }
                case STR_ESC: {
                    switch (c) {
                        case 34: 
                        case 47: 
                        case 92: {
                            cb.cache.append((char)c);
                            break;
                        }
                        case 98: {
                            cb.cache.append('\b');
                            break;
                        }
                        case 102: {
                            cb.cache.append('\f');
                            break;
                        }
                        case 110: {
                            cb.cache.append('\r');
                            break;
                        }
                        case 114: {
                            cb.cache.append('\r');
                            break;
                        }
                        case 116: {
                            cb.cache.append('\t');
                            break;
                        }
                        case 117: {
                            cb.state = State.HEX1;
                            break block0;
                        }
                        default: {
                            this.error(cb, c);
                        }
                    }
                    cb.state = State.STRING_START;
                    break;
                }
                case HEX1: {
                    if (!this.isHex(c)) {
                        this.error(cb, c);
                    }
                    cb.hexCache = new StringBuilder();
                    cb.hexCache.append((char)c);
                    cb.state = State.HEX2;
                    break;
                }
                case HEX2: {
                    if (!this.isHex(c)) {
                        this.error(cb, c);
                    }
                    cb.hexCache.append((char)c);
                    cb.state = State.HEX3;
                    break;
                }
                case HEX3: {
                    if (!this.isHex(c)) {
                        this.error(cb, c);
                    }
                    cb.hexCache.append((char)c);
                    cb.state = State.HEX4;
                    break;
                }
                case HEX4: {
                    if (!this.isHex(c)) {
                        this.error(cb, c);
                    }
                    cb.hexCache.append((char)c);
                    char u = this.toChar(cb.hexCache);
                    cb.cache.append(u);
                    cb.state = State.STRING_START;
                    break;
                }
                default: {
                    this.error(cb, c);
                }
            }
            ++i;
            ++cb.pos;
        }
    }

    boolean isWS(byte c) {
        return Character.isWhitespace(c);
    }

    char toChar(CharSequence buf) {
        assert (buf.length() == 4);
        return (char)Integer.parseInt(buf.toString(), 16);
    }

    boolean isHex(byte c) {
        switch (c) {
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 97: 
            case 98: 
            case 99: 
            case 100: 
            case 101: 
            case 102: {
                return true;
            }
        }
        return false;
    }

    void error(CB cb) {
        this.error("??? " + (Object)((Object)cb.state) + " at pos: " + cb.pos);
    }

    void error(CB cb, byte c) {
        this.error("unexpected char: " + (char)c + "(" + c + ") in state: " + (Object)((Object)cb.state) + " at pos:" + cb.pos);
    }

    void error(String mes) {
        throw new JSONException(mes);
    }

    static abstract class CB {
        int pos;
        State state = State.VALUE;
        StringBuilder cache;
        StringBuilder hexCache;

        CB() {
        }

        abstract void tok(Token var1);

        abstract void tok(String var1);

        abstract void numberToken(CharSequence var1);

        public void reset() {
            this.pos = 0;
            this.state = State.VALUE;
            this.cache = null;
            this.hexCache = null;
        }
    }

    static enum Token {
        LCURLY,
        LSQUARE,
        RCURLY,
        RSQUARE,
        TRUE,
        FALSE,
        NULL,
        COMMA,
        COLON;

    }

    static enum State {
        VALUE,
        STRING_START,
        STR_ESC,
        NUMBER_START,
        T,
        TR,
        TRU,
        F,
        FA,
        FAL,
        FALS,
        N,
        NU,
        NUL,
        AFTER_VALUE,
        HEX1,
        HEX2,
        HEX3,
        HEX4;

    }
}

