/*
 * Decompiled with CFR 0.152.
 */
package util.json;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Stack;
import java.util.Vector;
import java.util.concurrent.CopyOnWriteArrayList;
import util.benchmark.Benchmark;
import util.json.JSON;
import util.json.RandomObject;

public class ListBenchmark {
    static byte[] JSONbytes = "[{\"a\":19560954609845.4456456,\"b\":[1,2,3],\"dindong\":{\"b\":12}},{\"a\":19560954609845.4456456,\"b\":[1,2,3],\"dindong\":{\"b\":12}},{\"a\":19560954609845.4456456,\"b\":[1,2,3],\"dindong\":{\"b\":12}},{\"a\":19560954609845.4456456,\"b\":[1,2,3],\"dindong\":{\"b\":12}},{\"a\":19560954609845.4456456,\"b\":[1,2,3],\"dindong\":{\"b\":12}},{\"a\":19560954609845.4456456,\"b\":[1,2,3],\"dindong\":{\"b\":12}},{\"a\":19560954609845.4456456,\"b\":[1,2,3],\"dindong\":{\"b\":12}},{\"a\":19560954609845.4456456,\"b\":[1,2,3],\"dindong\":{\"b\":12}},{\"a\":19560954609845.4456456,\"b\":[1,2,3],\"dindong\":{\"b\":12}},{\"a\":19560954609845.4456456,\"b\":[1,2,3],\"dindong\":{\"b\":12}},{\"a\":19560954609845.4456456,\"b\":[1,2,3],\"dindong\":{\"b\":12}},{\"a\":19560954609845.4456456,\"b\":[1,2,3],\"dindong\":{\"b\":12}},{\"a\":19560954609845.4456456,\"b\":[1,2,3],\"dindong\":{\"b\":12}},{\"a\":19560954609845.4456456,\"b\":[1,2,3],\"dindong\":{\"b\":12}},{\"a\":19560954609845.4456456,\"b\":[1,2,3],\"dindong\":{\"b\":12}},{\"a\":19560954609845.4456456,\"b\":[1,2,3],\"dindong\":{\"b\":12}},{\"a\":19560954609845.4456456,\"b\":[1,2,3],\"dindong\":{\"b\":12}},{\"a\":19560954609845.4456456,\"b\":[1,2,3],\"dindong\":{\"b\":12}},{\"a\":19560954609845.4456456,\"b\":[1,2,3],\"dindong\":{\"b\":12}},{\"a\":19560954609845.4456456,\"b\":[1,2,3],\"dindong\":{\"b\":12}},{\"a\":19560954609845.4456456,\"b\":[1,2,3],\"dindong\":{\"b\":12}},{\"a\":19560954609845.4456456,\"b\":[1,2,3],\"dindong\":{\"b\":12}},{\"a\":19560954609845.4456456,\"b\":[1,2,3],\"dindong\":{\"b\":12}},{\"a\":19560954609845.4456456,\"b\":[1,2,3],\"dindong\":{\"b\":12}},{\"a\":19560954609845.4456456,\"b\":[1,2,3],\"dindong\":{\"b\":12}}]".getBytes();

    static JSON.LexerCB WithLinkedList() {
        return new JSON.LexerCB(JSON.NumberType.BigDecimal){

            @Override
            List list() {
                return new LinkedList();
            }
        };
    }

    public static void linkedList(Benchmark b) {
        JSON json = new JSON();
        json.cb = ListBenchmark.WithLinkedList();
        b.setBytes(JSONbytes.length);
        for (int n = 0; n != b.N; ++n) {
            json.reset();
            json.parse(JSONbytes);
        }
    }

    static JSON.LexerCB WithArrayList() {
        return new JSON.LexerCB(JSON.NumberType.BigDecimal){

            @Override
            List list() {
                return new ArrayList();
            }
        };
    }

    public static void arrayList(Benchmark b) {
        JSON json = new JSON();
        json.cb = ListBenchmark.WithArrayList();
        b.setBytes(JSONbytes.length);
        for (int n = 0; n != b.N; ++n) {
            json.reset();
            json.parse(JSONbytes);
        }
    }

    static JSON.LexerCB WithArrayList10() {
        return new JSON.LexerCB(JSON.NumberType.BigDecimal){

            @Override
            List list() {
                return new ArrayList(10);
            }
        };
    }

    public static void arrayList10(Benchmark b) {
        JSON json = new JSON();
        json.cb = ListBenchmark.WithArrayList10();
        b.setBytes(JSONbytes.length);
        for (int n = 0; n != b.N; ++n) {
            json.reset();
            json.parse(JSONbytes);
        }
    }

    static JSON.LexerCB WithStack() {
        return new JSON.LexerCB(JSON.NumberType.BigDecimal){

            @Override
            List list() {
                return new Stack();
            }
        };
    }

    public static void stack(Benchmark b) {
        JSON json = new JSON();
        json.cb = ListBenchmark.WithStack();
        b.setBytes(JSONbytes.length);
        for (int n = 0; n != b.N; ++n) {
            json.reset();
            json.parse(JSONbytes);
        }
    }

    static JSON.LexerCB WithVector() {
        return new JSON.LexerCB(JSON.NumberType.BigDecimal){

            @Override
            List list() {
                return new Vector();
            }
        };
    }

    public static void vector(Benchmark b) {
        JSON json = new JSON();
        json.cb = ListBenchmark.WithStack();
        b.setBytes(JSONbytes.length);
        for (int n = 0; n != b.N; ++n) {
            json.reset();
            json.parse(JSONbytes);
        }
    }

    static JSON.LexerCB WithCow() {
        return new JSON.LexerCB(JSON.NumberType.BigDecimal){

            @Override
            List list() {
                return new CopyOnWriteArrayList();
            }
        };
    }

    public static void cow(Benchmark b) {
        JSON json = new JSON();
        json.cb = ListBenchmark.WithCow();
        b.setBytes(JSONbytes.length);
        for (int n = 0; n != b.N; ++n) {
            json.reset();
            json.parse(JSONbytes);
        }
    }

    public static void asIs(Benchmark b) {
        JSON json = new JSON();
        b.setBytes(JSONbytes.length);
        for (int n = 0; n != b.N; ++n) {
            json.reset();
            json.parse(JSONbytes);
        }
    }

    public static void main(String[] args) throws Throwable {
        RandomObject ro = new RandomObject(1L);
        for (int i = 0; i != 5; ++i) {
            JSONbytes = JSON.jsonify(ro.randomMap(10 * (i + 1), i)).getBytes();
            ListBenchmark.p("running with " + JSONbytes.length + " bytes of json per invocation");
            Benchmark.runBenchmark(ListBenchmark.class);
        }
    }

    static void p(Object o) {
        System.out.println(o);
    }
}

