/*
 * Decompiled with CFR 0.152.
 */
package util.json;

import java.util.HashMap;
import java.util.Hashtable;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.TreeMap;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentSkipListMap;
import util.benchmark.Benchmark;
import util.json.JSON;
import util.json.RandomObject;

public class MapBenchmark {
    static byte[] JSONbytes = "[{\"a\":19560954609845.4456456,\"b\":[1,2,3],\"dindong\":{\"b\":12}},{\"a\":19560954609845.4456456,\"b\":[1,2,3],\"dindong\":{\"b\":12}},{\"a\":19560954609845.4456456,\"b\":[1,2,3],\"dindong\":{\"b\":12}},{\"a\":19560954609845.4456456,\"b\":[1,2,3],\"dindong\":{\"b\":12}},{\"a\":19560954609845.4456456,\"b\":[1,2,3],\"dindong\":{\"b\":12}},{\"a\":19560954609845.4456456,\"b\":[1,2,3],\"dindong\":{\"b\":12}},{\"a\":19560954609845.4456456,\"b\":[1,2,3],\"dindong\":{\"b\":12}},{\"a\":19560954609845.4456456,\"b\":[1,2,3],\"dindong\":{\"b\":12}},{\"a\":19560954609845.4456456,\"b\":[1,2,3],\"dindong\":{\"b\":12}},{\"a\":19560954609845.4456456,\"b\":[1,2,3],\"dindong\":{\"b\":12}},{\"a\":19560954609845.4456456,\"b\":[1,2,3],\"dindong\":{\"b\":12}},{\"a\":19560954609845.4456456,\"b\":[1,2,3],\"dindong\":{\"b\":12}},{\"a\":19560954609845.4456456,\"b\":[1,2,3],\"dindong\":{\"b\":12}},{\"a\":19560954609845.4456456,\"b\":[1,2,3],\"dindong\":{\"b\":12}},{\"a\":19560954609845.4456456,\"b\":[1,2,3],\"dindong\":{\"b\":12}},{\"a\":19560954609845.4456456,\"b\":[1,2,3],\"dindong\":{\"b\":12}},{\"a\":19560954609845.4456456,\"b\":[1,2,3],\"dindong\":{\"b\":12}},{\"a\":19560954609845.4456456,\"b\":[1,2,3],\"dindong\":{\"b\":12}},{\"a\":19560954609845.4456456,\"b\":[1,2,3],\"dindong\":{\"b\":12}},{\"a\":19560954609845.4456456,\"b\":[1,2,3],\"dindong\":{\"b\":12}},{\"a\":19560954609845.4456456,\"b\":[1,2,3],\"dindong\":{\"b\":12}},{\"a\":19560954609845.4456456,\"b\":[1,2,3],\"dindong\":{\"b\":12}},{\"a\":19560954609845.4456456,\"b\":[1,2,3],\"dindong\":{\"b\":12}},{\"a\":19560954609845.4456456,\"b\":[1,2,3],\"dindong\":{\"b\":12}},{\"a\":19560954609845.4456456,\"b\":[1,2,3],\"dindong\":{\"b\":12}}]".getBytes();

    static JSON.LexerCB WithHashMap() {
        return new JSON.LexerCB(JSON.NumberType.BigDecimal){

            @Override
            Map map() {
                return new HashMap();
            }
        };
    }

    public static void hashMap(Benchmark b) {
        JSON json = new JSON();
        json.cb = MapBenchmark.WithHashMap();
        b.setBytes(JSONbytes.length);
        for (int n = 0; n != b.N; ++n) {
            json.reset();
            json.parse(JSONbytes);
        }
    }

    static JSON.LexerCB WithHashtable() {
        return new JSON.LexerCB(JSON.NumberType.BigDecimal){

            @Override
            Map map() {
                return new Hashtable();
            }
        };
    }

    public static void hashttable(Benchmark b) {
        JSON json = new JSON();
        json.cb = MapBenchmark.WithHashtable();
        b.setBytes(JSONbytes.length);
        for (int n = 0; n != b.N; ++n) {
            json.reset();
            json.parse(JSONbytes);
        }
    }

    static JSON.LexerCB WithLinkedHashMap() {
        return new JSON.LexerCB(JSON.NumberType.BigDecimal){

            @Override
            Map map() {
                return new LinkedHashMap();
            }
        };
    }

    public static void linkedHashMap(Benchmark b) {
        JSON json = new JSON();
        json.cb = MapBenchmark.WithLinkedHashMap();
        b.setBytes(JSONbytes.length);
        for (int n = 0; n != b.N; ++n) {
            json.reset();
            json.parse(JSONbytes);
        }
    }

    static JSON.LexerCB WithTreeMap() {
        return new JSON.LexerCB(JSON.NumberType.BigDecimal){

            @Override
            Map map() {
                return new TreeMap();
            }
        };
    }

    public static void treeMap(Benchmark b) {
        JSON json = new JSON();
        json.cb = MapBenchmark.WithTreeMap();
        b.setBytes(JSONbytes.length);
        for (int n = 0; n != b.N; ++n) {
            json.reset();
            json.parse(JSONbytes);
        }
    }

    static JSON.LexerCB WithWeakHashMap() {
        return new JSON.LexerCB(JSON.NumberType.BigDecimal){

            @Override
            Map map() {
                return new WeakHashMap();
            }
        };
    }

    public static void weakHashMap(Benchmark b) {
        JSON json = new JSON();
        json.cb = MapBenchmark.WithWeakHashMap();
        b.setBytes(JSONbytes.length);
        for (int n = 0; n != b.N; ++n) {
            json.reset();
            json.parse(JSONbytes);
        }
    }

    static JSON.LexerCB WithConcurrentHashMap() {
        return new JSON.LexerCB(JSON.NumberType.BigDecimal){

            @Override
            Map map() {
                return new ConcurrentHashMap();
            }
        };
    }

    public static void concurrentHashMap(Benchmark b) {
        JSON json = new JSON();
        json.cb = MapBenchmark.WithConcurrentHashMap();
        b.setBytes(JSONbytes.length);
        for (int n = 0; n != b.N; ++n) {
            json.reset();
            json.parse(JSONbytes);
        }
    }

    static JSON.LexerCB WithConcurrentSkipListMap() {
        return new JSON.LexerCB(JSON.NumberType.BigDecimal){

            @Override
            Map map() {
                return new ConcurrentSkipListMap();
            }
        };
    }

    public static void concurrentSkipListMap(Benchmark b) {
        JSON json = new JSON();
        json.cb = MapBenchmark.WithConcurrentSkipListMap();
        b.setBytes(JSONbytes.length);
        for (int n = 0; n != b.N; ++n) {
            json.reset();
            json.parse(JSONbytes);
        }
    }

    public static void asIs(Benchmark b) {
        JSON json = new JSON();
        b.setBytes(JSONbytes.length);
        for (int n = 0; n != b.N; ++n) {
            json.reset();
            json.parse(JSONbytes);
        }
    }

    public static void main(String[] args) throws Throwable {
        RandomObject ro = new RandomObject();
        for (int i = 0; i != 5; ++i) {
            JSONbytes = JSON.jsonify(ro.randomMap(10 * (i + 1), i)).getBytes();
            MapBenchmark.p("running with " + JSONbytes.length + " bytes of json per invocation");
            Benchmark.runBenchmark(MapBenchmark.class);
        }
    }

    static void p(Object o) {
        System.out.println(o);
    }
}

