/*
 * Decompiled with CFR 0.152.
 */
package util.json;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import util.json.JSON;

public class RandomObject {
    final Random rnd;
    char[] chars = new char[]{'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'x', 'y', 'z', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'X', 'Y', 'Z', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', ' '};

    public RandomObject() {
        this(0L);
    }

    public RandomObject(long seed) {
        this.rnd = new Random(seed);
    }

    int between(int min, int max) {
        int n = max - min;
        return this.rnd.nextInt(n) + min;
    }

    Object randomObject(int depth) {
        int objType = this.rnd.nextInt(depth <= 0 ? 3 : 5);
        switch (objType) {
            case 0: {
                return this.randomString(this.between(10, 200));
            }
            case 1: {
                return Integer.toString(this.rnd.nextInt(), 10);
            }
            case 2: {
                return Double.toString(this.rnd.nextDouble());
            }
            case 3: {
                return this.randomMap(this.between(4, 10), depth);
            }
            case 4: {
                return this.randomList(this.between(5, 12), depth);
            }
        }
        throw new RuntimeException("cannot happen.");
    }

    Map randomMap(int numKeys, int depth) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (int i = 0; i != numKeys; ++i) {
            String key = this.randomString(8);
            Object val = this.randomObject(depth - 1);
            map.put(key, val);
        }
        return map;
    }

    List randomList(int n, int depth) {
        LinkedList<Object> list = new LinkedList<Object>();
        for (int i = 0; i != n; ++i) {
            list.add(this.randomObject(depth - 1));
        }
        return list;
    }

    char randomChar() {
        int i = this.rnd.nextInt(this.chars.length);
        return this.chars[i];
    }

    String randomString(int n) {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i != n; ++i) {
            builder.append(this.randomChar());
        }
        return builder.toString();
    }

    public static void main(String[] args) {
        RandomObject obj = new RandomObject();
        Map map = obj.randomMap(10, 5);
        RandomObject.p(map);
        RandomObject.p(JSON.jsonify(map).length());
    }

    static void p(Object o) {
        System.out.println(o);
    }
}

