/*
 * Decompiled with CFR 0.152.
 */
package util.json;

import util.benchmark.Benchmark;
import util.json.JSON;
import util.json.Lexer;
import util.json.RandomObject;
import util.json.StaticLexer;

public class StaticBenchmark {
    static byte[] JSONbytes = "[{\"a\":19560954609845.4456456,\"b\":[1,2,3],\"dindong\":{\"b\":12}},{\"a\":19560954609845.4456456,\"b\":[1,2,3],\"dindong\":{\"b\":12}},{\"a\":19560954609845.4456456,\"b\":[1,2,3],\"dindong\":{\"b\":12}},{\"a\":19560954609845.4456456,\"b\":[1,2,3],\"dindong\":{\"b\":12}},{\"a\":19560954609845.4456456,\"b\":[1,2,3],\"dindong\":{\"b\":12}},{\"a\":19560954609845.4456456,\"b\":[1,2,3],\"dindong\":{\"b\":12}},{\"a\":19560954609845.4456456,\"b\":[1,2,3],\"dindong\":{\"b\":12}},{\"a\":19560954609845.4456456,\"b\":[1,2,3],\"dindong\":{\"b\":12}},{\"a\":19560954609845.4456456,\"b\":[1,2,3],\"dindong\":{\"b\":12}},{\"a\":19560954609845.4456456,\"b\":[1,2,3],\"dindong\":{\"b\":12}},{\"a\":19560954609845.4456456,\"b\":[1,2,3],\"dindong\":{\"b\":12}},{\"a\":19560954609845.4456456,\"b\":[1,2,3],\"dindong\":{\"b\":12}},{\"a\":19560954609845.4456456,\"b\":[1,2,3],\"dindong\":{\"b\":12}},{\"a\":19560954609845.4456456,\"b\":[1,2,3],\"dindong\":{\"b\":12}},{\"a\":19560954609845.4456456,\"b\":[1,2,3],\"dindong\":{\"b\":12}},{\"a\":19560954609845.4456456,\"b\":[1,2,3],\"dindong\":{\"b\":12}},{\"a\":19560954609845.4456456,\"b\":[1,2,3],\"dindong\":{\"b\":12}},{\"a\":19560954609845.4456456,\"b\":[1,2,3],\"dindong\":{\"b\":12}},{\"a\":19560954609845.4456456,\"b\":[1,2,3],\"dindong\":{\"b\":12}},{\"a\":19560954609845.4456456,\"b\":[1,2,3],\"dindong\":{\"b\":12}},{\"a\":19560954609845.4456456,\"b\":[1,2,3],\"dindong\":{\"b\":12}},{\"a\":19560954609845.4456456,\"b\":[1,2,3],\"dindong\":{\"b\":12}},{\"a\":19560954609845.4456456,\"b\":[1,2,3],\"dindong\":{\"b\":12}},{\"a\":19560954609845.4456456,\"b\":[1,2,3],\"dindong\":{\"b\":12}},{\"a\":19560954609845.4456456,\"b\":[1,2,3],\"dindong\":{\"b\":12}}]".getBytes();

    public static void asIs(Benchmark b) {
        JSON.LexerCB cb = new JSON.LexerCB();
        b.setBytes(JSONbytes.length);
        for (int n = 0; n != b.N; ++n) {
            cb.reset();
            Lexer.lexer.lex(JSONbytes, cb);
        }
    }

    public static void onlyStatic(Benchmark b) {
        JSON.LexerCB cb = new JSON.LexerCB();
        b.setBytes(JSONbytes.length);
        for (int n = 0; n != b.N; ++n) {
            cb.reset();
            StaticLexer.lex(JSONbytes, cb);
        }
    }

    public static void asIsDummyCB(Benchmark b) {
        Lexer.CB cb = new Lexer.CB(){

            @Override
            void tok(Lexer.Token tok) {
            }

            @Override
            void tok(String s) {
            }

            @Override
            void numberToken(CharSequence cs) {
            }
        };
        b.setBytes(JSONbytes.length);
        for (int n = 0; n != b.N; ++n) {
            cb.reset();
            Lexer.lexer.lex(JSONbytes, cb);
        }
    }

    public static void staticDummyCB(Benchmark b) {
        Lexer.CB cb = new Lexer.CB(){

            @Override
            void tok(Lexer.Token tok) {
            }

            @Override
            void tok(String s) {
            }

            @Override
            void numberToken(CharSequence cs) {
            }
        };
        b.setBytes(JSONbytes.length);
        for (int n = 0; n != b.N; ++n) {
            cb.reset();
            StaticLexer.lex(JSONbytes, cb);
        }
    }

    public static void main(String[] args) throws Throwable {
        RandomObject ro = new RandomObject(1L);
        for (int i = 0; i != 5; ++i) {
            JSONbytes = JSON.jsonify(ro.randomMap(10 * (i + 1), i)).getBytes();
            StaticBenchmark.p("running with " + JSONbytes.length + " bytes of json per invocation");
            Benchmark.runBenchmark(StaticBenchmark.class);
        }
    }

    static void p(Object o) {
        System.out.println(o);
    }
}

