/*
 * Decompiled with CFR 0.152.
 */
package util.json;

import util.json.JSONException;
import util.json.Lexer;

public class StaticLexer {
    public static void lex(byte[] arr, Lexer.CB cb) {
        StaticLexer.lex(arr, 0, arr.length, cb);
    }

    public static void lex(byte[] arr, int off, int len, Lexer.CB cb) {
        int i = off;
        int end = off + len;
        while (i != end) {
            byte c = arr[i];
            block0 : switch (cb.state) {
                case VALUE: {
                    if (StaticLexer.isWS(c)) break;
                    switch (c) {
                        case 34: {
                            cb.state = Lexer.State.STRING_START;
                            cb.cache = new StringBuilder();
                            break block0;
                        }
                        case 45: 
                        case 48: 
                        case 49: 
                        case 50: 
                        case 51: 
                        case 52: 
                        case 53: 
                        case 54: 
                        case 55: 
                        case 56: 
                        case 57: {
                            cb.state = Lexer.State.NUMBER_START;
                            cb.cache = new StringBuilder();
                            cb.cache.append((char)c);
                            break block0;
                        }
                        case 123: {
                            cb.state = Lexer.State.VALUE;
                            cb.tok(Lexer.Token.LCURLY);
                            break block0;
                        }
                        case 125: {
                            cb.state = Lexer.State.AFTER_VALUE;
                            cb.tok(Lexer.Token.RCURLY);
                            break block0;
                        }
                        case 91: {
                            cb.state = Lexer.State.VALUE;
                            cb.tok(Lexer.Token.LSQUARE);
                            break block0;
                        }
                        case 93: {
                            cb.state = Lexer.State.AFTER_VALUE;
                            cb.tok(Lexer.Token.RSQUARE);
                            break block0;
                        }
                        case 116: {
                            cb.state = Lexer.State.T;
                            break block0;
                        }
                        case 102: {
                            cb.state = Lexer.State.F;
                            break block0;
                        }
                        case 110: {
                            cb.state = Lexer.State.N;
                            break block0;
                        }
                    }
                    StaticLexer.error(cb, c);
                }
                case T: {
                    if (114 == c) {
                        cb.state = Lexer.State.TR;
                        break;
                    }
                    StaticLexer.error(cb, c);
                }
                case TR: {
                    if (117 == c) {
                        cb.state = Lexer.State.TRU;
                        break;
                    }
                    StaticLexer.error(cb, c);
                }
                case TRU: {
                    if (101 == c) {
                        cb.tok(Lexer.Token.TRUE);
                        cb.state = Lexer.State.AFTER_VALUE;
                        break;
                    }
                    StaticLexer.error(cb, c);
                }
                case F: {
                    if (97 == c) {
                        cb.state = Lexer.State.FA;
                        break;
                    }
                    StaticLexer.error(cb, c);
                }
                case FA: {
                    if (108 == c) {
                        cb.state = Lexer.State.FAL;
                        break;
                    }
                    StaticLexer.error(cb, c);
                }
                case FAL: {
                    if (115 == c) {
                        cb.state = Lexer.State.FALS;
                        break;
                    }
                    StaticLexer.error(cb, c);
                }
                case FALS: {
                    if (101 == c) {
                        cb.tok(Lexer.Token.FALSE);
                        cb.state = Lexer.State.AFTER_VALUE;
                        break;
                    }
                    StaticLexer.error(cb, c);
                }
                case N: {
                    if (117 == c) {
                        cb.state = Lexer.State.NU;
                        break;
                    }
                    StaticLexer.error(cb, c);
                }
                case NU: {
                    if (108 == c) {
                        cb.state = Lexer.State.NUL;
                        break;
                    }
                    StaticLexer.error(cb, c);
                }
                case NUL: {
                    if (108 == c) {
                        cb.tok(Lexer.Token.NULL);
                        cb.state = Lexer.State.AFTER_VALUE;
                        break;
                    }
                    StaticLexer.error(cb, c);
                }
                case AFTER_VALUE: {
                    if (StaticLexer.isWS(c)) break;
                    switch (c) {
                        case 125: {
                            cb.tok(Lexer.Token.RCURLY);
                            break block0;
                        }
                        case 93: {
                            cb.tok(Lexer.Token.RSQUARE);
                            break block0;
                        }
                        case 44: {
                            cb.tok(Lexer.Token.COMMA);
                            break block0;
                        }
                        case 58: {
                            cb.tok(Lexer.Token.COLON);
                            break block0;
                        }
                    }
                    --i;
                    --cb.pos;
                    cb.state = Lexer.State.VALUE;
                    break;
                }
                case NUMBER_START: {
                    switch (c) {
                        case 43: 
                        case 45: 
                        case 46: 
                        case 48: 
                        case 49: 
                        case 50: 
                        case 51: 
                        case 52: 
                        case 53: 
                        case 54: 
                        case 55: 
                        case 56: 
                        case 57: 
                        case 69: 
                        case 101: {
                            cb.cache.append((char)c);
                            break block0;
                        }
                    }
                    cb.numberToken(cb.cache);
                    --i;
                    --cb.pos;
                    cb.state = Lexer.State.AFTER_VALUE;
                    break;
                }
                case STRING_START: {
                    switch (c) {
                        case 34: {
                            cb.tok(cb.cache.toString());
                            cb.state = Lexer.State.AFTER_VALUE;
                            break block0;
                        }
                        case 92: {
                            cb.state = Lexer.State.STR_ESC;
                            break block0;
                        }
                    }
                    if (Character.isISOControl(c)) {
                        StaticLexer.error(cb, c);
                    }
                    cb.cache.append((char)c);
                    break;
                }
                case STR_ESC: {
                    switch (c) {
                        case 34: 
                        case 47: 
                        case 92: {
                            cb.cache.append((char)c);
                            break;
                        }
                        case 98: {
                            cb.cache.append('\b');
                            break;
                        }
                        case 102: {
                            cb.cache.append('\f');
                            break;
                        }
                        case 110: {
                            cb.cache.append('\r');
                            break;
                        }
                        case 114: {
                            cb.cache.append('\r');
                            break;
                        }
                        case 116: {
                            cb.cache.append('\t');
                            break;
                        }
                        case 117: {
                            cb.state = Lexer.State.HEX1;
                            break block0;
                        }
                        default: {
                            StaticLexer.error(cb, c);
                        }
                    }
                    cb.state = Lexer.State.STRING_START;
                    break;
                }
                case HEX1: {
                    if (!StaticLexer.isHex(c)) {
                        StaticLexer.error(cb, c);
                    }
                    cb.hexCache = new StringBuilder();
                    cb.hexCache.append((char)c);
                    cb.state = Lexer.State.HEX2;
                    break;
                }
                case HEX2: {
                    if (!StaticLexer.isHex(c)) {
                        StaticLexer.error(cb, c);
                    }
                    cb.hexCache.append((char)c);
                    cb.state = Lexer.State.HEX3;
                    break;
                }
                case HEX3: {
                    if (!StaticLexer.isHex(c)) {
                        StaticLexer.error(cb, c);
                    }
                    cb.hexCache.append((char)c);
                    cb.state = Lexer.State.HEX4;
                    break;
                }
                case HEX4: {
                    if (!StaticLexer.isHex(c)) {
                        StaticLexer.error(cb, c);
                    }
                    cb.hexCache.append((char)c);
                    char u = StaticLexer.toChar(cb.hexCache);
                    cb.cache.append(u);
                    cb.state = Lexer.State.STRING_START;
                    break;
                }
                default: {
                    StaticLexer.error(cb, c);
                }
            }
            ++i;
            ++cb.pos;
        }
    }

    static boolean isWS(byte c) {
        return Character.isWhitespace(c);
    }

    static char toChar(CharSequence buf) {
        assert (buf.length() == 4);
        return (char)Integer.parseInt(buf.toString(), 16);
    }

    static boolean isHex(byte c) {
        switch (c) {
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 97: 
            case 98: 
            case 99: 
            case 100: 
            case 101: 
            case 102: {
                return true;
            }
        }
        return false;
    }

    static void error(Lexer.CB cb) {
        StaticLexer.error("??? " + (Object)((Object)cb.state) + " at pos: " + cb.pos);
    }

    static void error(Lexer.CB cb, byte c) {
        StaticLexer.error("unexpected char: " + (char)c + "(" + c + ") in state: " + (Object)((Object)cb.state) + " at pos:" + cb.pos);
    }

    static void error(String mes) {
        throw new JSONException(mes);
    }
}

