/*
 * Decompiled with CFR 0.152.
 */
package de.labathome;

import java.nio.ByteBuffer;

public class BinaryTimeseries {
    public static final byte DTYPE_NONE = 0;
    public static final byte DTYPE_BYTE = 1;
    public static final byte DTYPE_SHORT = 2;
    public static final byte DTYPE_INT = 3;
    public static final byte DTYPE_LONG = 4;
    public static final byte DTYPE_FLOAT = 5;
    public static final byte DTYPE_DOUBLE = 6;

    public static final String dtypeStr(byte dtype) {
        if (dtype == 0) {
            return "N";
        }
        if (dtype == 1) {
            return "B";
        }
        if (dtype == 2) {
            return "S";
        }
        if (dtype == 3) {
            return "I";
        }
        if (dtype == 4) {
            return "L";
        }
        if (dtype == 5) {
            return "F";
        }
        if (dtype == 6) {
            return "D";
        }
        return "?";
    }

    public static final void buildTimebase(long[] target, long t0, long dt) {
        boolean sourceOffset = false;
        boolean targetOffset = false;
        BinaryTimeseries.buildTimebase(0, target, 0, target.length, t0, dt);
    }

    public static final void buildTimebase(int sourceOffset, long[] target, int targetOffset, int numSamples, long t0, long dt) {
        for (int i = 0; i < numSamples; ++i) {
            target[targetOffset + i] = t0 + (long)(sourceOffset + i) * dt;
        }
    }

    public static final void buildTimebase(double[] target, double t0, double dt) {
        boolean sourceOffset = false;
        boolean targetOffset = false;
        BinaryTimeseries.buildTimebase(0, target, 0, target.length, t0, dt);
    }

    public static final void buildTimebase(int sourceOffset, double[] target, int targetOffset, int numSamples, double t0, double dt) {
        for (int i = 0; i < numSamples; ++i) {
            target[targetOffset + i] = t0 + (double)(sourceOffset + i) * dt;
        }
    }

    public static final int firstIndexInside(long t0, long dt, long t_l) {
        return (int)((t_l - t0 + dt - 1L) / dt);
    }

    public static final int lastIndexInside(long t0, long dt, long t_u) {
        return (int)((t_u - t0) / dt);
    }

    public static final int firstIndexInside(double t0, double dt, double t_l) {
        return (int)Math.ceil((t_l - t0) / dt);
    }

    public static final int lastIndexInside(double t0, double dt, double t_u) {
        return (int)Math.floor((t_u - t0) / dt);
    }

    public static final int fileOffset(int dataSize, int index) {
        return 64 + dataSize * index;
    }

    public static final String explainHeader(byte[] header) {
        if (header == null || header.length != 64) {
            return "header should not be null and have a length of 64 bytes";
        }
        int previousPosition = 0;
        Object headerExplanation = "";
        ByteBuffer source = ByteBuffer.wrap(header);
        previousPosition = source.position();
        short firstShort = source.getShort();
        headerExplanation = (String)headerExplanation + String.format(" %2d  %2d reads 0x%02X", previousPosition, source.position() - previousPosition, firstShort);
        if (firstShort != 1) {
            if (firstShort == 256) {
                headerExplanation = (String)headerExplanation + " => incorrect endianess";
                return headerExplanation;
            }
            headerExplanation = (String)headerExplanation + " => invalid endianess check value: " + firstShort;
            return headerExplanation;
        }
        headerExplanation = (String)headerExplanation + " => correct endianess\n";
        previousPosition = source.position();
        byte time_dtype = source.get();
        headerExplanation = (String)headerExplanation + String.format(" %2d  %2d reads 0x%01X", previousPosition, source.position() - previousPosition, time_dtype);
        if (time_dtype != 4) {
            if (time_dtype == 6) {
                headerExplanation = (String)headerExplanation + " => timestamps as double";
                return headerExplanation;
            }
            headerExplanation = (String)headerExplanation + " => invalid timestamps data type: " + time_dtype;
            return headerExplanation;
        }
        headerExplanation = (String)headerExplanation + " => timestamps as long\n";
        if (time_dtype == 4) {
            previousPosition = source.position();
            long t0 = source.getLong();
            headerExplanation = (String)headerExplanation + String.format(" %2d  %2d reads 0x%016X => t0 = %d\n", previousPosition, source.position() - previousPosition, t0, t0);
            previousPosition = source.position();
            long dt = source.getLong();
            headerExplanation = (String)headerExplanation + String.format(" %2d  %2d reads 0x%016X => dt = %d\n", previousPosition, source.position() - previousPosition, dt, dt);
        } else if (time_dtype == 4) {
            previousPosition = source.position();
            double t0 = source.getDouble();
            headerExplanation = (String)headerExplanation + String.format(" %2d  %2d reads 0x%016X => t0 = %g\n", previousPosition, source.position() - previousPosition, t0, t0);
            previousPosition = source.position();
            double dt = source.getDouble();
            headerExplanation = (String)headerExplanation + String.format(" %2d  %2d reads 0x%016X => dt = %g\n", previousPosition, source.position() - previousPosition, dt, dt);
        }
        previousPosition = source.position();
        byte scaling_dtype = source.get();
        headerExplanation = (String)headerExplanation + String.format(" %2d  %2d reads 0x%01X", previousPosition, source.position() - previousPosition, scaling_dtype);
        if (scaling_dtype == 0) {
            headerExplanation = (String)headerExplanation + " => no scaling\n";
        } else if (scaling_dtype == 1) {
            headerExplanation = (String)headerExplanation + " => scaling as byte\n";
        } else if (scaling_dtype == 2) {
            headerExplanation = (String)headerExplanation + " => scaling as short\n";
        } else if (scaling_dtype == 3) {
            headerExplanation = (String)headerExplanation + " => scaling as int\n";
        } else if (scaling_dtype == 4) {
            headerExplanation = (String)headerExplanation + " => scaling as long\n";
        } else if (scaling_dtype == 5) {
            headerExplanation = (String)headerExplanation + " => scaling as float\n";
        } else if (scaling_dtype == 6) {
            headerExplanation = (String)headerExplanation + " => scaling as double\n";
        } else {
            headerExplanation = (String)headerExplanation + " => invalid scaling type: " + scaling_dtype;
            return headerExplanation;
        }
        if (scaling_dtype == 0) {
            int i;
            byte[] dummy = new byte[8];
            previousPosition = source.position();
            source.get(dummy);
            Object contents = "";
            for (i = 0; i < dummy.length - 1; ++i) {
                contents = (String)contents + String.format("0x%02X ", dummy[i]);
            }
            contents = (String)contents + String.format("0x%02X", dummy[dummy.length - 1]);
            headerExplanation = (String)headerExplanation + String.format("[%2d] %2d reads %s\n", previousPosition, source.position() - previousPosition, contents);
            previousPosition = source.position();
            source.get(dummy);
            contents = "";
            for (i = 0; i < dummy.length - 1; ++i) {
                contents = (String)contents + String.format("0x%02X ", dummy[i]);
            }
            contents = (String)contents + String.format("0x%02X", dummy[dummy.length - 1]);
            headerExplanation = (String)headerExplanation + String.format("[%2d] %2d reads %s\n", previousPosition, source.position() - previousPosition, contents);
        } else if (scaling_dtype == 1) {
            byte[] dummy = new byte[7];
            previousPosition = source.position();
            byte scalingOffset = source.get();
            headerExplanation = (String)headerExplanation + String.format(" %2d  %2d reads 0x%01X => scalingOffset = %d\n", previousPosition, source.position() - previousPosition, scalingOffset, scalingOffset);
            previousPosition = source.position();
            source.get(dummy);
            Object contents = "";
            for (int i = 0; i < dummy.length - 1; ++i) {
                contents = (String)contents + String.format("0x%02X ", dummy[i]);
            }
            contents = (String)contents + String.format("0x%02X", dummy[dummy.length - 1]);
            headerExplanation = (String)headerExplanation + String.format(" %2d  %2d reads %s\n", previousPosition, source.position() - previousPosition, contents);
            previousPosition = source.position();
            byte scalingFactor = source.get();
            headerExplanation = (String)headerExplanation + String.format(" %2d  %2d reads 0x%01X => scalingFactor = %d\n", previousPosition, source.position() - previousPosition, scalingFactor, scalingFactor);
            previousPosition = source.position();
            source.get(dummy);
            contents = "";
            for (i = 0; i < dummy.length - 1; ++i) {
                contents = (String)contents + String.format("0x%02X ", dummy[i]);
            }
            contents = (String)contents + String.format("0x%02X", dummy[dummy.length - 1]);
            headerExplanation = (String)headerExplanation + String.format(" %2d  %2d reads %s\n", previousPosition, source.position() - previousPosition, contents);
        } else if (scaling_dtype == 2) {
            byte[] dummy = new byte[6];
            previousPosition = source.position();
            short scalingOffset = source.getShort();
            headerExplanation = (String)headerExplanation + String.format(" %2d  %2d reads 0x%02X => scalingOffset = %d\n", previousPosition, source.position() - previousPosition, scalingOffset, scalingOffset);
            previousPosition = source.position();
            source.get(dummy);
            Object contents = "";
            for (int i = 0; i < dummy.length - 1; ++i) {
                contents = (String)contents + String.format("0x%02X ", dummy[i]);
            }
            contents = (String)contents + String.format("0x%02X", dummy[dummy.length - 1]);
            headerExplanation = (String)headerExplanation + String.format(" %2d  %2d reads %s\n", previousPosition, source.position() - previousPosition, contents);
            previousPosition = source.position();
            short scalingFactor = source.getShort();
            headerExplanation = (String)headerExplanation + String.format(" %2d  %2d reads 0x%02X => scalingFactor = %d\n", previousPosition, source.position() - previousPosition, scalingFactor, scalingFactor);
            previousPosition = source.position();
            source.get(dummy);
            contents = "";
            for (i = 0; i < dummy.length - 1; ++i) {
                contents = (String)contents + String.format("0x%02X ", dummy[i]);
            }
            contents = (String)contents + String.format("0x%02X", dummy[dummy.length - 1]);
            headerExplanation = (String)headerExplanation + String.format(" %2d  %2d reads %s\n", previousPosition, source.position() - previousPosition, contents);
        } else if (scaling_dtype == 3) {
            byte[] dummy = new byte[4];
            previousPosition = source.position();
            int scalingOffset = source.getInt();
            headerExplanation = (String)headerExplanation + String.format(" %2d  %2d reads 0x%04X => scalingOffset = %d\n", previousPosition, source.position() - previousPosition, scalingOffset, scalingOffset);
            previousPosition = source.position();
            source.get(dummy);
            Object contents = "";
            for (int i = 0; i < dummy.length - 1; ++i) {
                contents = (String)contents + String.format("0x%02X ", dummy[i]);
            }
            contents = (String)contents + String.format("0x%02X", dummy[dummy.length - 1]);
            headerExplanation = (String)headerExplanation + String.format(" %2d  %2d reads %s\n", previousPosition, source.position() - previousPosition, contents);
            previousPosition = source.position();
            int scalingFactor = source.getInt();
            headerExplanation = (String)headerExplanation + String.format(" %2d  %2d reads 0x%04X => scalingFactor = %d\n", previousPosition, source.position() - previousPosition, scalingFactor, scalingFactor);
            previousPosition = source.position();
            source.get(dummy);
            contents = "";
            for (i = 0; i < dummy.length - 1; ++i) {
                contents = (String)contents + String.format("0x%02X ", dummy[i]);
            }
            contents = (String)contents + String.format("0x%02X", dummy[dummy.length - 1]);
            headerExplanation = (String)headerExplanation + String.format(" %2d  %2d reads %s\n", previousPosition, source.position() - previousPosition, contents);
        } else if (scaling_dtype == 4) {
            previousPosition = source.position();
            long scalingOffset = source.getLong();
            headerExplanation = (String)headerExplanation + String.format(" %2d  %2d reads 0x%016X => scalingOffset = %d\n", previousPosition, source.position() - previousPosition, scalingOffset, scalingOffset);
            previousPosition = source.position();
            long scalingFactor = source.getLong();
            headerExplanation = (String)headerExplanation + String.format(" %2d  %2d reads 0x%016X => scalingFactor = %d\n", previousPosition, source.position() - previousPosition, scalingFactor, scalingFactor);
        } else if (scaling_dtype == 5) {
            byte[] dummy = new byte[4];
            previousPosition = source.position();
            float scalingOffset = source.getFloat();
            headerExplanation = (String)headerExplanation + String.format(" %2d  %2d reads 0x%04X => scalingOffset = %g\n", previousPosition, source.position() - previousPosition, Float.valueOf(scalingOffset), Float.valueOf(scalingOffset));
            previousPosition = source.position();
            source.get(dummy);
            Object contents = "";
            for (int i = 0; i < dummy.length - 1; ++i) {
                contents = (String)contents + String.format("0x%02X ", dummy[i]);
            }
            contents = (String)contents + String.format("0x%02X", dummy[dummy.length - 1]);
            headerExplanation = (String)headerExplanation + String.format(" %2d  %2d reads %s\n", previousPosition, source.position() - previousPosition, contents);
            previousPosition = source.position();
            float scalingFactor = source.getFloat();
            headerExplanation = (String)headerExplanation + String.format(" %2d  %2d reads 0x%04X => scalingFactor = %g\n", previousPosition, source.position() - previousPosition, Float.valueOf(scalingFactor), Float.valueOf(scalingFactor));
            previousPosition = source.position();
            source.get(dummy);
            contents = "";
            for (i = 0; i < dummy.length - 1; ++i) {
                contents = (String)contents + String.format("0x%02X ", dummy[i]);
            }
            contents = (String)contents + String.format("0x%02X", dummy[dummy.length - 1]);
            headerExplanation = (String)headerExplanation + String.format(" %2d  %2d reads %s\n", previousPosition, source.position() - previousPosition, contents);
        } else if (scaling_dtype == 6) {
            previousPosition = source.position();
            double scalingOffset = source.getDouble();
            headerExplanation = (String)headerExplanation + String.format(" %2d  %2d reads 0x%08X => scalingOffset = %g\n", previousPosition, source.position() - previousPosition, scalingOffset, scalingOffset);
            previousPosition = source.position();
            double scalingFactor = source.getDouble();
            headerExplanation = (String)headerExplanation + String.format(" %2d  %2d reads 0x%08X => scalingFactor = %g\n", previousPosition, source.position() - previousPosition, scalingFactor, scalingFactor);
        }
        previousPosition = source.position();
        byte[] reservedDummy = new byte[23];
        source.get(reservedDummy);
        Object contents = "";
        for (int i = 0; i < reservedDummy.length - 1; ++i) {
            contents = (String)contents + String.format("0x%02X ", reservedDummy[i]);
        }
        contents = (String)contents + String.format("0x%02X", reservedDummy[reservedDummy.length - 1]);
        headerExplanation = (String)headerExplanation + String.format(" %2d  %2d reads %s\n", previousPosition, source.position() - previousPosition, contents);
        previousPosition = source.position();
        byte data_dtype = source.get();
        headerExplanation = (String)headerExplanation + String.format(" %2d  %2d reads 0x%01X", previousPosition, source.position() - previousPosition, data_dtype);
        if (data_dtype == 1) {
            headerExplanation = (String)headerExplanation + " => raw data as byte\n";
        } else if (data_dtype == 2) {
            headerExplanation = (String)headerExplanation + " => raw data as short\n";
        } else if (data_dtype == 3) {
            headerExplanation = (String)headerExplanation + " => raw data as int\n";
        } else if (data_dtype == 4) {
            headerExplanation = (String)headerExplanation + " => raw data as long\n";
        } else if (data_dtype == 5) {
            headerExplanation = (String)headerExplanation + " => raw data as float\n";
        } else if (data_dtype == 6) {
            headerExplanation = (String)headerExplanation + " => raw data as double\n";
        } else {
            headerExplanation = (String)headerExplanation + " => invalid raw data type: " + data_dtype;
            return headerExplanation;
        }
        previousPosition = source.position();
        int numSamples = source.getInt();
        headerExplanation = (String)headerExplanation + String.format(" %2d  %2d reads 0x%04X", previousPosition, source.position() - previousPosition, numSamples);
        headerExplanation = numSamples > 0 ? (String)headerExplanation + String.format(" => number of samples = %d", numSamples) : (String)headerExplanation + String.format(" => invalid number of samples (would be interpreted as %d)", numSamples);
        return headerExplanation;
    }

    public static final void writeEndianessCheckValue(ByteBuffer target) {
        target.putShort((short)1);
    }

    public static final void writeTimebase(ByteBuffer target, long t0, long dt) {
        target.put((byte)4);
        target.putLong(t0);
        target.putLong(dt);
    }

    public static final void writeTimebase(ByteBuffer target, double t0, double dt) {
        target.put((byte)6);
        target.putDouble(t0);
        target.putDouble(dt);
    }

    public static final void writeScalingDisabled(ByteBuffer target) {
        target.put((byte)0);
        target.put(new byte[16]);
    }

    public static final void writeScaling(ByteBuffer target, byte o, byte s) {
        target.put((byte)1);
        target.put(o);
        target.put(new byte[7]);
        target.put(s);
        target.put(new byte[7]);
    }

    public static final void writeScaling(ByteBuffer target, short o, short s) {
        target.put((byte)2);
        target.putShort(o);
        target.put(new byte[6]);
        target.putShort(s);
        target.put(new byte[6]);
    }

    public static final void writeScaling(ByteBuffer target, int o, int s) {
        target.put((byte)3);
        target.putInt(o);
        target.put(new byte[4]);
        target.putInt(s);
        target.put(new byte[4]);
    }

    public static final void writeScaling(ByteBuffer target, long o, long s) {
        target.put((byte)4);
        target.putLong(o);
        target.putLong(s);
    }

    public static final void writeScaling(ByteBuffer target, float o, float s) {
        target.put((byte)5);
        target.putFloat(o);
        target.put(new byte[4]);
        target.putFloat(s);
        target.put(new byte[4]);
    }

    public static final void writeScaling(ByteBuffer target, double o, double s) {
        target.put((byte)6);
        target.putDouble(o);
        target.putDouble(s);
    }

    public static final void writeReservedDummy(ByteBuffer target) {
        target.put(new byte[23]);
    }

    public static final void writeData(ByteBuffer target, byte[] values) {
        target.put((byte)1);
        target.putInt(values.length);
        for (byte b : values) {
            target.put(b);
        }
    }

    public static final void writeData(ByteBuffer target, short[] values) {
        target.put((byte)2);
        target.putInt(values.length);
        for (short s : values) {
            target.putShort(s);
        }
    }

    public static final void writeData(ByteBuffer target, int[] values) {
        target.put((byte)3);
        target.putInt(values.length);
        for (int i : values) {
            target.putInt(i);
        }
    }

    public static final void writeData(ByteBuffer target, long[] values) {
        target.put((byte)4);
        target.putInt(values.length);
        for (long l : values) {
            target.putLong(l);
        }
    }

    public static final void writeData(ByteBuffer target, float[] values) {
        target.put((byte)5);
        target.putInt(values.length);
        for (float f : values) {
            target.putFloat(f);
        }
    }

    public static final void writeData(ByteBuffer target, double[] values) {
        target.put((byte)6);
        target.putInt(values.length);
        for (double d : values) {
            target.putDouble(d);
        }
    }

    public static final void write(ByteBuffer target, Object t0, Object dt, Object rawData) {
        BinaryTimeseries.write(target, t0, dt, rawData, null, null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final void write(ByteBuffer target, Object t0, Object dt, Object rawData, Object scalingOffset, Object scalingFactor) {
        BinaryTimeseries.writeEndianessCheckValue(target);
        if (t0 == null) {
            throw new RuntimeException("t0 cannot be null");
        }
        if (dt == null) {
            throw new RuntimeException("dt cannot be null");
        }
        if (Long.class.equals(t0.getClass()) && Long.class.equals(dt.getClass())) {
            BinaryTimeseries.writeTimebase(target, (Long)t0, (Long)dt);
        } else {
            if (!Double.class.equals(t0.getClass()) || !Double.class.equals(dt.getClass())) throw new RuntimeException("t0 and dt must be of the same class and either long or double");
            BinaryTimeseries.writeTimebase(target, (Double)t0, (Double)dt);
        }
        if (scalingFactor == null && scalingOffset == null) {
            BinaryTimeseries.writeScalingDisabled(target);
        } else {
            if (scalingFactor == null) {
                throw new RuntimeException("if scalingOffset is given, also give scalingFactor");
            }
            if (scalingOffset == null) {
                throw new RuntimeException("if scalingFactor is given, also give scalingOffset");
            }
            if (Byte.class.equals(scalingFactor.getClass()) && Byte.class.equals(scalingFactor.getClass())) {
                BinaryTimeseries.writeScaling(target, (Byte)scalingOffset, (Byte)scalingFactor);
            } else if (Short.class.equals(scalingFactor.getClass()) && Short.class.equals(scalingFactor.getClass())) {
                BinaryTimeseries.writeScaling(target, (Short)scalingOffset, (Short)scalingFactor);
            } else if (Integer.class.equals(scalingFactor.getClass()) && Integer.class.equals(scalingFactor.getClass())) {
                BinaryTimeseries.writeScaling(target, (Integer)scalingOffset, (Integer)scalingFactor);
            } else if (Long.class.equals(scalingFactor.getClass()) && Long.class.equals(scalingFactor.getClass())) {
                BinaryTimeseries.writeScaling(target, (Long)scalingOffset, (Long)scalingFactor);
            } else if (Float.class.equals(scalingFactor.getClass()) && Float.class.equals(scalingFactor.getClass())) {
                BinaryTimeseries.writeScaling(target, ((Float)scalingOffset).floatValue(), ((Float)scalingFactor).floatValue());
            } else {
                if (!Double.class.equals(scalingFactor.getClass()) || !Double.class.equals(scalingFactor.getClass())) throw new RuntimeException("scalingOffset and scalingFactor must be of the same class, which can be one of (byte, short, int, long, float, double)");
                BinaryTimeseries.writeScaling(target, (Double)scalingOffset, (Double)scalingFactor);
            }
        }
        BinaryTimeseries.writeReservedDummy(target);
        if (rawData == null) {
            throw new RuntimeException("rawData must not be null");
        }
        if (!rawData.getClass().isArray()) throw new RuntimeException("rawData must be an array");
        if (Byte.TYPE.equals(rawData.getClass().getComponentType())) {
            BinaryTimeseries.writeData(target, (byte[])rawData);
            return;
        } else if (Short.TYPE.equals(rawData.getClass().getComponentType())) {
            BinaryTimeseries.writeData(target, (short[])rawData);
            return;
        } else if (Integer.TYPE.equals(rawData.getClass().getComponentType())) {
            BinaryTimeseries.writeData(target, (int[])rawData);
            return;
        } else if (Long.TYPE.equals(rawData.getClass().getComponentType())) {
            BinaryTimeseries.writeData(target, (long[])rawData);
            return;
        } else if (Float.TYPE.equals(rawData.getClass().getComponentType())) {
            BinaryTimeseries.writeData(target, (float[])rawData);
            return;
        } else {
            if (!Double.TYPE.equals(rawData.getClass().getComponentType())) throw new RuntimeException("rawData elements must be of one of the following types: byte, short, int, long, float, double");
            BinaryTimeseries.writeData(target, (double[])rawData);
        }
    }

    public static final byte[] readHeader(ByteBuffer source) {
        byte[] header = new byte[64];
        source.get(header);
        return header;
    }

    public static final boolean readEndianessOk(ByteBuffer source) {
        short firstShort = source.getShort();
        if (firstShort == 1) {
            return true;
        }
        if (firstShort == 256) {
            return false;
        }
        throw new RuntimeException("first short read from source was neither 1 nor 256 but " + firstShort);
    }

    public static final byte readTimeType(ByteBuffer source) {
        byte time_dtype = source.get();
        return time_dtype;
    }

    public static final long readTimeT0_long(ByteBuffer source) {
        long t0 = source.getLong();
        return t0;
    }

    public static final long readTimeDt_long(ByteBuffer source) {
        long dt = source.getLong();
        return dt;
    }

    public static final double readTimeT0_double(ByteBuffer source) {
        double t0 = source.getDouble();
        return t0;
    }

    public static final double readTimeDt_double(ByteBuffer source) {
        double dt = source.getDouble();
        return dt;
    }

    public static final boolean hasScaling(byte scaling_dtype) {
        return scaling_dtype != 0;
    }

    public static final byte readScalingType(ByteBuffer source) {
        byte scaling_dtype = source.get();
        return scaling_dtype;
    }

    public static final void readScalingDisabled(ByteBuffer source) {
        source.get(new byte[16]);
    }

    public static final byte readScalingOffset_byte(ByteBuffer source) {
        byte scalingOffset = source.get();
        source.get(new byte[7]);
        return scalingOffset;
    }

    public static final byte readScalingFactor_byte(ByteBuffer source) {
        byte scalingFactor = source.get();
        source.get(new byte[7]);
        return scalingFactor;
    }

    public static final short readScalingOffset_short(ByteBuffer source) {
        short scalingOffset = source.getShort();
        source.get(new byte[6]);
        return scalingOffset;
    }

    public static final short readScalingFactor_short(ByteBuffer source) {
        short scalingFactor = source.getShort();
        source.get(new byte[6]);
        return scalingFactor;
    }

    public static final int readScalingOffset_int(ByteBuffer source) {
        int scalingOffset = source.getInt();
        source.get(new byte[4]);
        return scalingOffset;
    }

    public static final int readScalingFactor_int(ByteBuffer source) {
        int scalingFactor = source.getInt();
        source.get(new byte[4]);
        return scalingFactor;
    }

    public static final long readScalingOffset_long(ByteBuffer source) {
        long scalingOffset = source.getLong();
        return scalingOffset;
    }

    public static final long readScalingFactor_long(ByteBuffer source) {
        long scalingFactor = source.getLong();
        return scalingFactor;
    }

    public static final float readScalingOffset_float(ByteBuffer source) {
        float scalingOffset = source.getFloat();
        source.get(new byte[4]);
        return scalingOffset;
    }

    public static final float readScalingFactor_float(ByteBuffer source) {
        float scalingFactor = source.getFloat();
        source.get(new byte[4]);
        return scalingFactor;
    }

    public static final double readScalingOffset_double(ByteBuffer source) {
        double scalingOffset = source.getDouble();
        return scalingOffset;
    }

    public static final double readScalingFactor_double(ByteBuffer source) {
        double scalingFactor = source.getDouble();
        return scalingFactor;
    }

    public static final void readReservedDummy(ByteBuffer source) {
        source.get(new byte[23]);
    }

    public static final byte readDataType(ByteBuffer source) {
        byte data_dtype = source.get();
        return data_dtype;
    }

    public static final int readNumSamples(ByteBuffer source) {
        int numSamples = source.getInt();
        return numSamples;
    }

    public static final void readRawData(ByteBuffer source, byte[] target, int targetOffset, int numSamples) {
        for (int i = 0; i < numSamples; ++i) {
            target[targetOffset + i] = source.get();
        }
    }

    public static final void readRawData(ByteBuffer source, short[] target, int targetOffset, int numSamples) {
        for (int i = 0; i < numSamples; ++i) {
            target[targetOffset + i] = source.getShort();
        }
    }

    public static final void readRawData(ByteBuffer source, int[] target, int targetOffset, int numSamples) {
        for (int i = 0; i < numSamples; ++i) {
            target[targetOffset + i] = source.getInt();
        }
    }

    public static final void readRawData(ByteBuffer source, long[] target, int targetOffset, int numSamples) {
        for (int i = 0; i < numSamples; ++i) {
            target[targetOffset + i] = source.getLong();
        }
    }

    public static final void readRawData(ByteBuffer source, float[] target, int targetOffset, int numSamples) {
        for (int i = 0; i < numSamples; ++i) {
            target[targetOffset + i] = source.getFloat();
        }
    }

    public static final void readRawData(ByteBuffer source, double[] target, int targetOffset, int numSamples) {
        for (int i = 0; i < numSamples; ++i) {
            target[targetOffset + i] = source.getDouble();
        }
    }

    public static final byte[] readData_byte(ByteBuffer source) {
        boolean firstDataIndex = false;
        int lastDataIndex = -1;
        return BinaryTimeseries.readData_byte(source, 0, -1);
    }

    public static final byte[] readData_byte(ByteBuffer source, int firstDataIndex, int lastDataIndex) {
        byte scaling_dtype = BinaryTimeseries.readScalingType(source);
        if (BinaryTimeseries.hasScaling(scaling_dtype)) {
            if (scaling_dtype == 1) {
                byte scalingOffset = BinaryTimeseries.readScalingOffset_byte(source);
                byte scalingFactor = BinaryTimeseries.readScalingFactor_byte(source);
                BinaryTimeseries.readReservedDummy(source);
                byte data_dtype = BinaryTimeseries.readDataType(source);
                int numSamples = BinaryTimeseries.readNumSamples(source);
                int numToRead = lastDataIndex == -1 ? numSamples - firstDataIndex : lastDataIndex - firstDataIndex + 1;
                int currentPosition = source.position();
                byte[] target = new byte[numToRead];
                if (data_dtype == 1) {
                    if (firstDataIndex != 0) {
                        int bytesToSkip = 1 * firstDataIndex;
                        source.position(currentPosition + bytesToSkip);
                    }
                    for (int i = 0; i < numToRead; ++i) {
                        target[i] = (byte)(scalingOffset + scalingFactor * source.get());
                    }
                } else if (data_dtype == 2) {
                    if (firstDataIndex != 0) {
                        int bytesToSkip = 2 * firstDataIndex;
                        source.position(currentPosition + bytesToSkip);
                    }
                    for (int i = 0; i < numToRead; ++i) {
                        target[i] = (byte)(scalingOffset + scalingFactor * source.getShort());
                    }
                } else if (data_dtype == 3) {
                    if (firstDataIndex != 0) {
                        int bytesToSkip = 4 * firstDataIndex;
                        source.position(currentPosition + bytesToSkip);
                    }
                    for (int i = 0; i < numToRead; ++i) {
                        target[i] = (byte)(scalingOffset + scalingFactor * source.getInt());
                    }
                } else if (data_dtype == 4) {
                    if (firstDataIndex != 0) {
                        int bytesToSkip = 8 * firstDataIndex;
                        source.position(currentPosition + bytesToSkip);
                    }
                    for (int i = 0; i < numToRead; ++i) {
                        target[i] = (byte)((long)scalingOffset + (long)scalingFactor * source.getLong());
                    }
                } else if (data_dtype == 5) {
                    if (firstDataIndex != 0) {
                        int bytesToSkip = 4 * firstDataIndex;
                        source.position(currentPosition + bytesToSkip);
                    }
                    for (int i = 0; i < numToRead; ++i) {
                        target[i] = (byte)((float)scalingOffset + (float)scalingFactor * source.getFloat());
                    }
                } else if (data_dtype == 6) {
                    if (firstDataIndex != 0) {
                        int bytesToSkip = 8 * firstDataIndex;
                        source.position(currentPosition + bytesToSkip);
                    }
                    for (int i = 0; i < numToRead; ++i) {
                        target[i] = (byte)((double)scalingOffset + (double)scalingFactor * source.getDouble());
                    }
                } else {
                    throw new RuntimeException("unknown data dtype");
                }
                return target;
            }
            if (scaling_dtype == 2) {
                short scalingOffset = BinaryTimeseries.readScalingOffset_short(source);
                short scalingFactor = BinaryTimeseries.readScalingFactor_short(source);
                BinaryTimeseries.readReservedDummy(source);
                byte data_dtype = BinaryTimeseries.readDataType(source);
                int numSamples = BinaryTimeseries.readNumSamples(source);
                int numToRead = lastDataIndex == -1 ? numSamples - firstDataIndex : lastDataIndex - firstDataIndex + 1;
                int currentPosition = source.position();
                byte[] target = new byte[numToRead];
                if (data_dtype == 1) {
                    if (firstDataIndex != 0) {
                        int bytesToSkip = 1 * firstDataIndex;
                        source.position(currentPosition + bytesToSkip);
                    }
                    for (int i = 0; i < numToRead; ++i) {
                        target[i] = (byte)(scalingOffset + scalingFactor * source.get());
                    }
                } else if (data_dtype == 2) {
                    if (firstDataIndex != 0) {
                        int bytesToSkip = 2 * firstDataIndex;
                        source.position(currentPosition + bytesToSkip);
                    }
                    for (int i = 0; i < numToRead; ++i) {
                        target[i] = (byte)(scalingOffset + scalingFactor * source.getShort());
                    }
                } else if (data_dtype == 3) {
                    if (firstDataIndex != 0) {
                        int bytesToSkip = 4 * firstDataIndex;
                        source.position(currentPosition + bytesToSkip);
                    }
                    for (int i = 0; i < numToRead; ++i) {
                        target[i] = (byte)(scalingOffset + scalingFactor * source.getInt());
                    }
                } else if (data_dtype == 4) {
                    if (firstDataIndex != 0) {
                        int bytesToSkip = 8 * firstDataIndex;
                        source.position(currentPosition + bytesToSkip);
                    }
                    for (int i = 0; i < numToRead; ++i) {
                        target[i] = (byte)((long)scalingOffset + (long)scalingFactor * source.getLong());
                    }
                } else if (data_dtype == 5) {
                    if (firstDataIndex != 0) {
                        int bytesToSkip = 4 * firstDataIndex;
                        source.position(currentPosition + bytesToSkip);
                    }
                    for (int i = 0; i < numToRead; ++i) {
                        target[i] = (byte)((float)scalingOffset + (float)scalingFactor * source.getFloat());
                    }
                } else if (data_dtype == 6) {
                    if (firstDataIndex != 0) {
                        int bytesToSkip = 8 * firstDataIndex;
                        source.position(currentPosition + bytesToSkip);
                    }
                    for (int i = 0; i < numToRead; ++i) {
                        target[i] = (byte)((double)scalingOffset + (double)scalingFactor * source.getDouble());
                    }
                } else {
                    throw new RuntimeException("unknown data dtype");
                }
                return target;
            }
            if (scaling_dtype == 3) {
                int scalingOffset = BinaryTimeseries.readScalingOffset_int(source);
                int scalingFactor = BinaryTimeseries.readScalingFactor_int(source);
                BinaryTimeseries.readReservedDummy(source);
                byte data_dtype = BinaryTimeseries.readDataType(source);
                int numSamples = BinaryTimeseries.readNumSamples(source);
                int numToRead = lastDataIndex == -1 ? numSamples - firstDataIndex : lastDataIndex - firstDataIndex + 1;
                int currentPosition = source.position();
                byte[] target = new byte[numToRead];
                if (data_dtype == 1) {
                    if (firstDataIndex != 0) {
                        int bytesToSkip = 1 * firstDataIndex;
                        source.position(currentPosition + bytesToSkip);
                    }
                    for (int i = 0; i < numToRead; ++i) {
                        target[i] = (byte)(scalingOffset + scalingFactor * source.get());
                    }
                } else if (data_dtype == 2) {
                    if (firstDataIndex != 0) {
                        int bytesToSkip = 2 * firstDataIndex;
                        source.position(currentPosition + bytesToSkip);
                    }
                    for (int i = 0; i < numToRead; ++i) {
                        target[i] = (byte)(scalingOffset + scalingFactor * source.getShort());
                    }
                } else if (data_dtype == 3) {
                    if (firstDataIndex != 0) {
                        int bytesToSkip = 4 * firstDataIndex;
                        source.position(currentPosition + bytesToSkip);
                    }
                    for (int i = 0; i < numToRead; ++i) {
                        target[i] = (byte)(scalingOffset + scalingFactor * source.getInt());
                    }
                } else if (data_dtype == 4) {
                    if (firstDataIndex != 0) {
                        int bytesToSkip = 8 * firstDataIndex;
                        source.position(currentPosition + bytesToSkip);
                    }
                    for (int i = 0; i < numToRead; ++i) {
                        target[i] = (byte)((long)scalingOffset + (long)scalingFactor * source.getLong());
                    }
                } else if (data_dtype == 5) {
                    if (firstDataIndex != 0) {
                        int bytesToSkip = 4 * firstDataIndex;
                        source.position(currentPosition + bytesToSkip);
                    }
                    for (int i = 0; i < numToRead; ++i) {
                        target[i] = (byte)((float)scalingOffset + (float)scalingFactor * source.getFloat());
                    }
                } else if (data_dtype == 6) {
                    if (firstDataIndex != 0) {
                        int bytesToSkip = 8 * firstDataIndex;
                        source.position(currentPosition + bytesToSkip);
                    }
                    for (int i = 0; i < numToRead; ++i) {
                        target[i] = (byte)((double)scalingOffset + (double)scalingFactor * source.getDouble());
                    }
                } else {
                    throw new RuntimeException("unknown data dtype");
                }
                return target;
            }
            if (scaling_dtype == 4) {
                long scalingOffset = BinaryTimeseries.readScalingOffset_long(source);
                long scalingFactor = BinaryTimeseries.readScalingFactor_long(source);
                BinaryTimeseries.readReservedDummy(source);
                byte data_dtype = BinaryTimeseries.readDataType(source);
                int numSamples = BinaryTimeseries.readNumSamples(source);
                int numToRead = lastDataIndex == -1 ? numSamples - firstDataIndex : lastDataIndex - firstDataIndex + 1;
                int currentPosition = source.position();
                byte[] target = new byte[numToRead];
                if (data_dtype == 1) {
                    if (firstDataIndex != 0) {
                        int bytesToSkip = 1 * firstDataIndex;
                        source.position(currentPosition + bytesToSkip);
                    }
                    for (int i = 0; i < numToRead; ++i) {
                        target[i] = (byte)(scalingOffset + scalingFactor * (long)source.get());
                    }
                } else if (data_dtype == 2) {
                    if (firstDataIndex != 0) {
                        int bytesToSkip = 2 * firstDataIndex;
                        source.position(currentPosition + bytesToSkip);
                    }
                    for (int i = 0; i < numToRead; ++i) {
                        target[i] = (byte)(scalingOffset + scalingFactor * (long)source.getShort());
                    }
                } else if (data_dtype == 3) {
                    if (firstDataIndex != 0) {
                        int bytesToSkip = 4 * firstDataIndex;
                        source.position(currentPosition + bytesToSkip);
                    }
                    for (int i = 0; i < numToRead; ++i) {
                        target[i] = (byte)(scalingOffset + scalingFactor * (long)source.getInt());
                    }
                } else if (data_dtype == 4) {
                    if (firstDataIndex != 0) {
                        int bytesToSkip = 8 * firstDataIndex;
                        source.position(currentPosition + bytesToSkip);
                    }
                    for (int i = 0; i < numToRead; ++i) {
                        target[i] = (byte)(scalingOffset + scalingFactor * source.getLong());
                    }
                } else if (data_dtype == 5) {
                    if (firstDataIndex != 0) {
                        int bytesToSkip = 4 * firstDataIndex;
                        source.position(currentPosition + bytesToSkip);
                    }
                    for (int i = 0; i < numToRead; ++i) {
                        target[i] = (byte)((float)scalingOffset + (float)scalingFactor * source.getFloat());
                    }
                } else if (data_dtype == 6) {
                    if (firstDataIndex != 0) {
                        int bytesToSkip = 8 * firstDataIndex;
                        source.position(currentPosition + bytesToSkip);
                    }
                    for (int i = 0; i < numToRead; ++i) {
                        target[i] = (byte)((double)scalingOffset + (double)scalingFactor * source.getDouble());
                    }
                } else {
                    throw new RuntimeException("unknown data dtype");
                }
                return target;
            }
            if (scaling_dtype == 5) {
                float scalingOffset = BinaryTimeseries.readScalingOffset_float(source);
                float scalingFactor = BinaryTimeseries.readScalingFactor_float(source);
                BinaryTimeseries.readReservedDummy(source);
                byte data_dtype = BinaryTimeseries.readDataType(source);
                int numSamples = BinaryTimeseries.readNumSamples(source);
                int numToRead = lastDataIndex == -1 ? numSamples - firstDataIndex : lastDataIndex - firstDataIndex + 1;
                int currentPosition = source.position();
                byte[] target = new byte[numToRead];
                if (data_dtype == 1) {
                    if (firstDataIndex != 0) {
                        int bytesToSkip = 1 * firstDataIndex;
                        source.position(currentPosition + bytesToSkip);
                    }
                    for (int i = 0; i < numToRead; ++i) {
                        target[i] = (byte)(scalingOffset + scalingFactor * (float)source.get());
                    }
                } else if (data_dtype == 2) {
                    if (firstDataIndex != 0) {
                        int bytesToSkip = 2 * firstDataIndex;
                        source.position(currentPosition + bytesToSkip);
                    }
                    for (int i = 0; i < numToRead; ++i) {
                        target[i] = (byte)(scalingOffset + scalingFactor * (float)source.getShort());
                    }
                } else if (data_dtype == 3) {
                    if (firstDataIndex != 0) {
                        int bytesToSkip = 4 * firstDataIndex;
                        source.position(currentPosition + bytesToSkip);
                    }
                    for (int i = 0; i < numToRead; ++i) {
                        target[i] = (byte)(scalingOffset + scalingFactor * (float)source.getInt());
                    }
                } else if (data_dtype == 4) {
                    if (firstDataIndex != 0) {
                        int bytesToSkip = 8 * firstDataIndex;
                        source.position(currentPosition + bytesToSkip);
                    }
                    for (int i = 0; i < numToRead; ++i) {
                        target[i] = (byte)(scalingOffset + scalingFactor * (float)source.getLong());
                    }
                } else if (data_dtype == 5) {
                    if (firstDataIndex != 0) {
                        int bytesToSkip = 4 * firstDataIndex;
                        source.position(currentPosition + bytesToSkip);
                    }
                    for (int i = 0; i < numToRead; ++i) {
                        target[i] = (byte)(scalingOffset + scalingFactor * source.getFloat());
                    }
                } else if (data_dtype == 6) {
                    if (firstDataIndex != 0) {
                        int bytesToSkip = 8 * firstDataIndex;
                        source.position(currentPosition + bytesToSkip);
                    }
                    for (int i = 0; i < numToRead; ++i) {
                        target[i] = (byte)((double)scalingOffset + (double)scalingFactor * source.getDouble());
                    }
                } else {
                    throw new RuntimeException("unknown data dtype");
                }
                return target;
            }
            if (scaling_dtype == 6) {
                double scalingOffset = BinaryTimeseries.readScalingOffset_double(source);
                double scalingFactor = BinaryTimeseries.readScalingFactor_double(source);
                BinaryTimeseries.readReservedDummy(source);
                byte data_dtype = BinaryTimeseries.readDataType(source);
                int numSamples = BinaryTimeseries.readNumSamples(source);
                int numToRead = lastDataIndex == -1 ? numSamples - firstDataIndex : lastDataIndex - firstDataIndex + 1;
                int currentPosition = source.position();
                byte[] target = new byte[numToRead];
                if (data_dtype == 1) {
                    if (firstDataIndex != 0) {
                        int bytesToSkip = 1 * firstDataIndex;
                        source.position(currentPosition + bytesToSkip);
                    }
                    for (int i = 0; i < numToRead; ++i) {
                        target[i] = (byte)(scalingOffset + scalingFactor * (double)source.get());
                    }
                } else if (data_dtype == 2) {
                    if (firstDataIndex != 0) {
                        int bytesToSkip = 2 * firstDataIndex;
                        source.position(currentPosition + bytesToSkip);
                    }
                    for (int i = 0; i < numToRead; ++i) {
                        target[i] = (byte)(scalingOffset + scalingFactor * (double)source.getShort());
                    }
                } else if (data_dtype == 3) {
                    if (firstDataIndex != 0) {
                        int bytesToSkip = 4 * firstDataIndex;
                        source.position(currentPosition + bytesToSkip);
                    }
                    for (int i = 0; i < numToRead; ++i) {
                        target[i] = (byte)(scalingOffset + scalingFactor * (double)source.getInt());
                    }
                } else if (data_dtype == 4) {
                    if (firstDataIndex != 0) {
                        int bytesToSkip = 8 * firstDataIndex;
                        source.position(currentPosition + bytesToSkip);
                    }
                    for (int i = 0; i < numToRead; ++i) {
                        target[i] = (byte)(scalingOffset + scalingFactor * (double)source.getLong());
                    }
                } else if (data_dtype == 5) {
                    if (firstDataIndex != 0) {
                        int bytesToSkip = 4 * firstDataIndex;
                        source.position(currentPosition + bytesToSkip);
                    }
                    for (int i = 0; i < numToRead; ++i) {
                        target[i] = (byte)(scalingOffset + scalingFactor * (double)source.getFloat());
                    }
                } else if (data_dtype == 6) {
                    if (firstDataIndex != 0) {
                        int bytesToSkip = 8 * firstDataIndex;
                        source.position(currentPosition + bytesToSkip);
                    }
                    for (int i = 0; i < numToRead; ++i) {
                        target[i] = (byte)(scalingOffset + scalingFactor * source.getDouble());
                    }
                } else {
                    throw new RuntimeException("unknown data dtype");
                }
                return target;
            }
            throw new RuntimeException("unknown scaling dtype");
        }
        BinaryTimeseries.readScalingDisabled(source);
        BinaryTimeseries.readReservedDummy(source);
        byte data_dtype = BinaryTimeseries.readDataType(source);
        int numSamples = BinaryTimeseries.readNumSamples(source);
        int numToRead = lastDataIndex == -1 ? numSamples - firstDataIndex : lastDataIndex - firstDataIndex + 1;
        int currentPosition = source.position();
        byte[] target = new byte[numToRead];
        if (data_dtype == 1) {
            if (firstDataIndex != 0) {
                int bytesToSkip = 1 * firstDataIndex;
                source.position(currentPosition + bytesToSkip);
            }
            for (int i = 0; i < numToRead; ++i) {
                target[i] = source.get();
            }
        } else if (data_dtype == 2) {
            if (firstDataIndex != 0) {
                int bytesToSkip = 2 * firstDataIndex;
                source.position(currentPosition + bytesToSkip);
            }
            for (int i = 0; i < numToRead; ++i) {
                target[i] = (byte)source.getShort();
            }
        } else if (data_dtype == 3) {
            if (firstDataIndex != 0) {
                int bytesToSkip = 4 * firstDataIndex;
                source.position(currentPosition + bytesToSkip);
            }
            for (int i = 0; i < numToRead; ++i) {
                target[i] = (byte)source.getInt();
            }
        } else if (data_dtype == 4) {
            if (firstDataIndex != 0) {
                int bytesToSkip = 8 * firstDataIndex;
                source.position(currentPosition + bytesToSkip);
            }
            for (int i = 0; i < numToRead; ++i) {
                target[i] = (byte)source.getLong();
            }
        } else if (data_dtype == 5) {
            if (firstDataIndex != 0) {
                int bytesToSkip = 4 * firstDataIndex;
                source.position(currentPosition + bytesToSkip);
            }
            for (int i = 0; i < numToRead; ++i) {
                target[i] = (byte)source.getFloat();
            }
        } else if (data_dtype == 6) {
            if (firstDataIndex != 0) {
                int bytesToSkip = 8 * firstDataIndex;
                source.position(currentPosition + bytesToSkip);
            }
            for (int i = 0; i < numToRead; ++i) {
                target[i] = (byte)source.getDouble();
            }
        } else {
            throw new RuntimeException("unknown data dtype");
        }
        return target;
    }

    public static final short[] readData_short(ByteBuffer source) {
        boolean firstDataIndex = false;
        int lastDataIndex = -1;
        return BinaryTimeseries.readData_short(source, 0, -1);
    }

    public static final short[] readData_short(ByteBuffer source, int firstDataIndex, int lastDataIndex) {
        byte scaling_dtype = BinaryTimeseries.readScalingType(source);
        if (BinaryTimeseries.hasScaling(scaling_dtype)) {
            if (scaling_dtype == 1) {
                byte scalingOffset = BinaryTimeseries.readScalingOffset_byte(source);
                byte scalingFactor = BinaryTimeseries.readScalingFactor_byte(source);
                BinaryTimeseries.readReservedDummy(source);
                byte data_dtype = BinaryTimeseries.readDataType(source);
                int numSamples = BinaryTimeseries.readNumSamples(source);
                int numToRead = lastDataIndex == -1 ? numSamples - firstDataIndex : lastDataIndex - firstDataIndex + 1;
                int currentPosition = source.position();
                short[] target = new short[numToRead];
                if (data_dtype == 1) {
                    if (firstDataIndex != 0) {
                        int bytesToSkip = 1 * firstDataIndex;
                        source.position(currentPosition + bytesToSkip);
                    }
                    for (int i = 0; i < numToRead; ++i) {
                        target[i] = (short)(scalingOffset + scalingFactor * source.get());
                    }
                } else if (data_dtype == 2) {
                    if (firstDataIndex != 0) {
                        int bytesToSkip = 2 * firstDataIndex;
                        source.position(currentPosition + bytesToSkip);
                    }
                    for (int i = 0; i < numToRead; ++i) {
                        target[i] = (short)(scalingOffset + scalingFactor * source.getShort());
                    }
                } else if (data_dtype == 3) {
                    if (firstDataIndex != 0) {
                        int bytesToSkip = 4 * firstDataIndex;
                        source.position(currentPosition + bytesToSkip);
                    }
                    for (int i = 0; i < numToRead; ++i) {
                        target[i] = (short)(scalingOffset + scalingFactor * source.getInt());
                    }
                } else if (data_dtype == 4) {
                    if (firstDataIndex != 0) {
                        int bytesToSkip = 8 * firstDataIndex;
                        source.position(currentPosition + bytesToSkip);
                    }
                    for (int i = 0; i < numToRead; ++i) {
                        target[i] = (short)((long)scalingOffset + (long)scalingFactor * source.getLong());
                    }
                } else if (data_dtype == 5) {
                    if (firstDataIndex != 0) {
                        int bytesToSkip = 4 * firstDataIndex;
                        source.position(currentPosition + bytesToSkip);
                    }
                    for (int i = 0; i < numToRead; ++i) {
                        target[i] = (short)((float)scalingOffset + (float)scalingFactor * source.getFloat());
                    }
                } else if (data_dtype == 6) {
                    if (firstDataIndex != 0) {
                        int bytesToSkip = 8 * firstDataIndex;
                        source.position(currentPosition + bytesToSkip);
                    }
                    for (int i = 0; i < numToRead; ++i) {
                        target[i] = (short)((double)scalingOffset + (double)scalingFactor * source.getDouble());
                    }
                } else {
                    throw new RuntimeException("unknown data dtype");
                }
                return target;
            }
            if (scaling_dtype == 2) {
                short scalingOffset = BinaryTimeseries.readScalingOffset_short(source);
                short scalingFactor = BinaryTimeseries.readScalingFactor_short(source);
                BinaryTimeseries.readReservedDummy(source);
                byte data_dtype = BinaryTimeseries.readDataType(source);
                int numSamples = BinaryTimeseries.readNumSamples(source);
                int numToRead = lastDataIndex == -1 ? numSamples - firstDataIndex : lastDataIndex - firstDataIndex + 1;
                int currentPosition = source.position();
                short[] target = new short[numToRead];
                if (data_dtype == 1) {
                    if (firstDataIndex != 0) {
                        int bytesToSkip = 1 * firstDataIndex;
                        source.position(currentPosition + bytesToSkip);
                    }
                    for (int i = 0; i < numToRead; ++i) {
                        target[i] = (short)(scalingOffset + scalingFactor * source.get());
                    }
                } else if (data_dtype == 2) {
                    if (firstDataIndex != 0) {
                        int bytesToSkip = 2 * firstDataIndex;
                        source.position(currentPosition + bytesToSkip);
                    }
                    for (int i = 0; i < numToRead; ++i) {
                        target[i] = (short)(scalingOffset + scalingFactor * source.getShort());
                    }
                } else if (data_dtype == 3) {
                    if (firstDataIndex != 0) {
                        int bytesToSkip = 4 * firstDataIndex;
                        source.position(currentPosition + bytesToSkip);
                    }
                    for (int i = 0; i < numToRead; ++i) {
                        target[i] = (short)(scalingOffset + scalingFactor * source.getInt());
                    }
                } else if (data_dtype == 4) {
                    if (firstDataIndex != 0) {
                        int bytesToSkip = 8 * firstDataIndex;
                        source.position(currentPosition + bytesToSkip);
                    }
                    for (int i = 0; i < numToRead; ++i) {
                        target[i] = (short)((long)scalingOffset + (long)scalingFactor * source.getLong());
                    }
                } else if (data_dtype == 5) {
                    if (firstDataIndex != 0) {
                        int bytesToSkip = 4 * firstDataIndex;
                        source.position(currentPosition + bytesToSkip);
                    }
                    for (int i = 0; i < numToRead; ++i) {
                        target[i] = (short)((float)scalingOffset + (float)scalingFactor * source.getFloat());
                    }
                } else if (data_dtype == 6) {
                    if (firstDataIndex != 0) {
                        int bytesToSkip = 8 * firstDataIndex;
                        source.position(currentPosition + bytesToSkip);
                    }
                    for (int i = 0; i < numToRead; ++i) {
                        target[i] = (short)((double)scalingOffset + (double)scalingFactor * source.getDouble());
                    }
                } else {
                    throw new RuntimeException("unknown data dtype");
                }
                return target;
            }
            if (scaling_dtype == 3) {
                int scalingOffset = BinaryTimeseries.readScalingOffset_int(source);
                int scalingFactor = BinaryTimeseries.readScalingFactor_int(source);
                BinaryTimeseries.readReservedDummy(source);
                byte data_dtype = BinaryTimeseries.readDataType(source);
                int numSamples = BinaryTimeseries.readNumSamples(source);
                int numToRead = lastDataIndex == -1 ? numSamples - firstDataIndex : lastDataIndex - firstDataIndex + 1;
                int currentPosition = source.position();
                short[] target = new short[numToRead];
                if (data_dtype == 1) {
                    if (firstDataIndex != 0) {
                        int bytesToSkip = 1 * firstDataIndex;
                        source.position(currentPosition + bytesToSkip);
                    }
                    for (int i = 0; i < numToRead; ++i) {
                        target[i] = (short)(scalingOffset + scalingFactor * source.get());
                    }
                } else if (data_dtype == 2) {
                    if (firstDataIndex != 0) {
                        int bytesToSkip = 2 * firstDataIndex;
                        source.position(currentPosition + bytesToSkip);
                    }
                    for (int i = 0; i < numToRead; ++i) {
                        target[i] = (short)(scalingOffset + scalingFactor * source.getShort());
                    }
                } else if (data_dtype == 3) {
                    if (firstDataIndex != 0) {
                        int bytesToSkip = 4 * firstDataIndex;
                        source.position(currentPosition + bytesToSkip);
                    }
                    for (int i = 0; i < numToRead; ++i) {
                        target[i] = (short)(scalingOffset + scalingFactor * source.getInt());
                    }
                } else if (data_dtype == 4) {
                    if (firstDataIndex != 0) {
                        int bytesToSkip = 8 * firstDataIndex;
                        source.position(currentPosition + bytesToSkip);
                    }
                    for (int i = 0; i < numToRead; ++i) {
                        target[i] = (short)((long)scalingOffset + (long)scalingFactor * source.getLong());
                    }
                } else if (data_dtype == 5) {
                    if (firstDataIndex != 0) {
                        int bytesToSkip = 4 * firstDataIndex;
                        source.position(currentPosition + bytesToSkip);
                    }
                    for (int i = 0; i < numToRead; ++i) {
                        target[i] = (short)((float)scalingOffset + (float)scalingFactor * source.getFloat());
                    }
                } else if (data_dtype == 6) {
                    if (firstDataIndex != 0) {
                        int bytesToSkip = 8 * firstDataIndex;
                        source.position(currentPosition + bytesToSkip);
                    }
                    for (int i = 0; i < numToRead; ++i) {
                        target[i] = (short)((double)scalingOffset + (double)scalingFactor * source.getDouble());
                    }
                } else {
                    throw new RuntimeException("unknown data dtype");
                }
                return target;
            }
            if (scaling_dtype == 4) {
                long scalingOffset = BinaryTimeseries.readScalingOffset_long(source);
                long scalingFactor = BinaryTimeseries.readScalingFactor_long(source);
                BinaryTimeseries.readReservedDummy(source);
                byte data_dtype = BinaryTimeseries.readDataType(source);
                int numSamples = BinaryTimeseries.readNumSamples(source);
                int numToRead = lastDataIndex == -1 ? numSamples - firstDataIndex : lastDataIndex - firstDataIndex + 1;
                int currentPosition = source.position();
                short[] target = new short[numToRead];
                if (data_dtype == 1) {
                    if (firstDataIndex != 0) {
                        int bytesToSkip = 1 * firstDataIndex;
                        source.position(currentPosition + bytesToSkip);
                    }
                    for (int i = 0; i < numToRead; ++i) {
                        target[i] = (short)(scalingOffset + scalingFactor * (long)source.get());
                    }
                } else if (data_dtype == 2) {
                    if (firstDataIndex != 0) {
                        int bytesToSkip = 2 * firstDataIndex;
                        source.position(currentPosition + bytesToSkip);
                    }
                    for (int i = 0; i < numToRead; ++i) {
                        target[i] = (short)(scalingOffset + scalingFactor * (long)source.getShort());
                    }
                } else if (data_dtype == 3) {
                    if (firstDataIndex != 0) {
                        int bytesToSkip = 4 * firstDataIndex;
                        source.position(currentPosition + bytesToSkip);
                    }
                    for (int i = 0; i < numToRead; ++i) {
                        target[i] = (short)(scalingOffset + scalingFactor * (long)source.getInt());
                    }
                } else if (data_dtype == 4) {
                    if (firstDataIndex != 0) {
                        int bytesToSkip = 8 * firstDataIndex;
                        source.position(currentPosition + bytesToSkip);
                    }
                    for (int i = 0; i < numToRead; ++i) {
                        target[i] = (short)(scalingOffset + scalingFactor * source.getLong());
                    }
                } else if (data_dtype == 5) {
                    if (firstDataIndex != 0) {
                        int bytesToSkip = 4 * firstDataIndex;
                        source.position(currentPosition + bytesToSkip);
                    }
                    for (int i = 0; i < numToRead; ++i) {
                        target[i] = (short)((float)scalingOffset + (float)scalingFactor * source.getFloat());
                    }
                } else if (data_dtype == 6) {
                    if (firstDataIndex != 0) {
                        int bytesToSkip = 8 * firstDataIndex;
                        source.position(currentPosition + bytesToSkip);
                    }
                    for (int i = 0; i < numToRead; ++i) {
                        target[i] = (short)((double)scalingOffset + (double)scalingFactor * source.getDouble());
                    }
                } else {
                    throw new RuntimeException("unknown data dtype");
                }
                return target;
            }
            if (scaling_dtype == 5) {
                float scalingOffset = BinaryTimeseries.readScalingOffset_float(source);
                float scalingFactor = BinaryTimeseries.readScalingFactor_float(source);
                BinaryTimeseries.readReservedDummy(source);
                byte data_dtype = BinaryTimeseries.readDataType(source);
                int numSamples = BinaryTimeseries.readNumSamples(source);
                int numToRead = lastDataIndex == -1 ? numSamples - firstDataIndex : lastDataIndex - firstDataIndex + 1;
                int currentPosition = source.position();
                short[] target = new short[numToRead];
                if (data_dtype == 1) {
                    if (firstDataIndex != 0) {
                        int bytesToSkip = 1 * firstDataIndex;
                        source.position(currentPosition + bytesToSkip);
                    }
                    for (int i = 0; i < numToRead; ++i) {
                        target[i] = (short)(scalingOffset + scalingFactor * (float)source.get());
                    }
                } else if (data_dtype == 2) {
                    if (firstDataIndex != 0) {
                        int bytesToSkip = 2 * firstDataIndex;
                        source.position(currentPosition + bytesToSkip);
                    }
                    for (int i = 0; i < numToRead; ++i) {
                        target[i] = (short)(scalingOffset + scalingFactor * (float)source.getShort());
                    }
                } else if (data_dtype == 3) {
                    if (firstDataIndex != 0) {
                        int bytesToSkip = 4 * firstDataIndex;
                        source.position(currentPosition + bytesToSkip);
                    }
                    for (int i = 0; i < numToRead; ++i) {
                        target[i] = (short)(scalingOffset + scalingFactor * (float)source.getInt());
                    }
                } else if (data_dtype == 4) {
                    if (firstDataIndex != 0) {
                        int bytesToSkip = 8 * firstDataIndex;
                        source.position(currentPosition + bytesToSkip);
                    }
                    for (int i = 0; i < numToRead; ++i) {
                        target[i] = (short)(scalingOffset + scalingFactor * (float)source.getLong());
                    }
                } else if (data_dtype == 5) {
                    if (firstDataIndex != 0) {
                        int bytesToSkip = 4 * firstDataIndex;
                        source.position(currentPosition + bytesToSkip);
                    }
                    for (int i = 0; i < numToRead; ++i) {
                        target[i] = (short)(scalingOffset + scalingFactor * source.getFloat());
                    }
                } else if (data_dtype == 6) {
                    if (firstDataIndex != 0) {
                        int bytesToSkip = 8 * firstDataIndex;
                        source.position(currentPosition + bytesToSkip);
                    }
                    for (int i = 0; i < numToRead; ++i) {
                        target[i] = (short)((double)scalingOffset + (double)scalingFactor * source.getDouble());
                    }
                } else {
                    throw new RuntimeException("unknown data dtype");
                }
                return target;
            }
            if (scaling_dtype == 6) {
                double scalingOffset = BinaryTimeseries.readScalingOffset_double(source);
                double scalingFactor = BinaryTimeseries.readScalingFactor_double(source);
                BinaryTimeseries.readReservedDummy(source);
                byte data_dtype = BinaryTimeseries.readDataType(source);
                int numSamples = BinaryTimeseries.readNumSamples(source);
                int numToRead = lastDataIndex == -1 ? numSamples - firstDataIndex : lastDataIndex - firstDataIndex + 1;
                int currentPosition = source.position();
                short[] target = new short[numToRead];
                if (data_dtype == 1) {
                    if (firstDataIndex != 0) {
                        int bytesToSkip = 1 * firstDataIndex;
                        source.position(currentPosition + bytesToSkip);
                    }
                    for (int i = 0; i < numToRead; ++i) {
                        target[i] = (short)(scalingOffset + scalingFactor * (double)source.get());
                    }
                } else if (data_dtype == 2) {
                    if (firstDataIndex != 0) {
                        int bytesToSkip = 2 * firstDataIndex;
                        source.position(currentPosition + bytesToSkip);
                    }
                    for (int i = 0; i < numToRead; ++i) {
                        target[i] = (short)(scalingOffset + scalingFactor * (double)source.getShort());
                    }
                } else if (data_dtype == 3) {
                    if (firstDataIndex != 0) {
                        int bytesToSkip = 4 * firstDataIndex;
                        source.position(currentPosition + bytesToSkip);
                    }
                    for (int i = 0; i < numToRead; ++i) {
                        target[i] = (short)(scalingOffset + scalingFactor * (double)source.getInt());
                    }
                } else if (data_dtype == 4) {
                    if (firstDataIndex != 0) {
                        int bytesToSkip = 8 * firstDataIndex;
                        source.position(currentPosition + bytesToSkip);
                    }
                    for (int i = 0; i < numToRead; ++i) {
                        target[i] = (short)(scalingOffset + scalingFactor * (double)source.getLong());
                    }
                } else if (data_dtype == 5) {
                    if (firstDataIndex != 0) {
                        int bytesToSkip = 4 * firstDataIndex;
                        source.position(currentPosition + bytesToSkip);
                    }
                    for (int i = 0; i < numToRead; ++i) {
                        target[i] = (short)(scalingOffset + scalingFactor * (double)source.getFloat());
                    }
                } else if (data_dtype == 6) {
                    if (firstDataIndex != 0) {
                        int bytesToSkip = 8 * firstDataIndex;
                        source.position(currentPosition + bytesToSkip);
                    }
                    for (int i = 0; i < numToRead; ++i) {
                        target[i] = (short)(scalingOffset + scalingFactor * source.getDouble());
                    }
                } else {
                    throw new RuntimeException("unknown data dtype");
                }
                return target;
            }
            throw new RuntimeException("unknown scaling dtype");
        }
        BinaryTimeseries.readScalingDisabled(source);
        BinaryTimeseries.readReservedDummy(source);
        byte data_dtype = BinaryTimeseries.readDataType(source);
        int numSamples = BinaryTimeseries.readNumSamples(source);
        int numToRead = lastDataIndex == -1 ? numSamples - firstDataIndex : lastDataIndex - firstDataIndex + 1;
        int currentPosition = source.position();
        short[] target = new short[numToRead];
        if (data_dtype == 1) {
            if (firstDataIndex != 0) {
                int bytesToSkip = 1 * firstDataIndex;
                source.position(currentPosition + bytesToSkip);
            }
            for (int i = 0; i < numToRead; ++i) {
                target[i] = source.get();
            }
        } else if (data_dtype == 2) {
            if (firstDataIndex != 0) {
                int bytesToSkip = 2 * firstDataIndex;
                source.position(currentPosition + bytesToSkip);
            }
            for (int i = 0; i < numToRead; ++i) {
                target[i] = source.getShort();
            }
        } else if (data_dtype == 3) {
            if (firstDataIndex != 0) {
                int bytesToSkip = 4 * firstDataIndex;
                source.position(currentPosition + bytesToSkip);
            }
            for (int i = 0; i < numToRead; ++i) {
                target[i] = (short)source.getInt();
            }
        } else if (data_dtype == 4) {
            if (firstDataIndex != 0) {
                int bytesToSkip = 8 * firstDataIndex;
                source.position(currentPosition + bytesToSkip);
            }
            for (int i = 0; i < numToRead; ++i) {
                target[i] = (short)source.getLong();
            }
        } else if (data_dtype == 5) {
            if (firstDataIndex != 0) {
                int bytesToSkip = 4 * firstDataIndex;
                source.position(currentPosition + bytesToSkip);
            }
            for (int i = 0; i < numToRead; ++i) {
                target[i] = (short)source.getFloat();
            }
        } else if (data_dtype == 6) {
            if (firstDataIndex != 0) {
                int bytesToSkip = 8 * firstDataIndex;
                source.position(currentPosition + bytesToSkip);
            }
            for (int i = 0; i < numToRead; ++i) {
                target[i] = (short)source.getDouble();
            }
        } else {
            throw new RuntimeException("unknown data dtype");
        }
        return target;
    }

    public static final int[] readData_int(ByteBuffer source) {
        boolean firstDataIndex = false;
        int lastDataIndex = -1;
        return BinaryTimeseries.readData_int(source, 0, -1);
    }

    public static final int[] readData_int(ByteBuffer source, int firstDataIndex, int lastDataIndex) {
        byte scaling_dtype = BinaryTimeseries.readScalingType(source);
        if (BinaryTimeseries.hasScaling(scaling_dtype)) {
            if (scaling_dtype == 1) {
                byte scalingOffset = BinaryTimeseries.readScalingOffset_byte(source);
                byte scalingFactor = BinaryTimeseries.readScalingFactor_byte(source);
                BinaryTimeseries.readReservedDummy(source);
                byte data_dtype = BinaryTimeseries.readDataType(source);
                int numSamples = BinaryTimeseries.readNumSamples(source);
                int numToRead = lastDataIndex == -1 ? numSamples - firstDataIndex : lastDataIndex - firstDataIndex + 1;
                int currentPosition = source.position();
                int[] target = new int[numToRead];
                if (data_dtype == 1) {
                    if (firstDataIndex != 0) {
                        int bytesToSkip = 1 * firstDataIndex;
                        source.position(currentPosition + bytesToSkip);
                    }
                    for (int i = 0; i < numToRead; ++i) {
                        target[i] = scalingOffset + scalingFactor * source.get();
                    }
                } else if (data_dtype == 2) {
                    if (firstDataIndex != 0) {
                        int bytesToSkip = 2 * firstDataIndex;
                        source.position(currentPosition + bytesToSkip);
                    }
                    for (int i = 0; i < numToRead; ++i) {
                        target[i] = scalingOffset + scalingFactor * source.getShort();
                    }
                } else if (data_dtype == 3) {
                    if (firstDataIndex != 0) {
                        int bytesToSkip = 4 * firstDataIndex;
                        source.position(currentPosition + bytesToSkip);
                    }
                    for (int i = 0; i < numToRead; ++i) {
                        target[i] = scalingOffset + scalingFactor * source.getInt();
                    }
                } else if (data_dtype == 4) {
                    if (firstDataIndex != 0) {
                        int bytesToSkip = 8 * firstDataIndex;
                        source.position(currentPosition + bytesToSkip);
                    }
                    for (int i = 0; i < numToRead; ++i) {
                        target[i] = (int)((long)scalingOffset + (long)scalingFactor * source.getLong());
                    }
                } else if (data_dtype == 5) {
                    if (firstDataIndex != 0) {
                        int bytesToSkip = 4 * firstDataIndex;
                        source.position(currentPosition + bytesToSkip);
                    }
                    for (int i = 0; i < numToRead; ++i) {
                        target[i] = (int)((float)scalingOffset + (float)scalingFactor * source.getFloat());
                    }
                } else if (data_dtype == 6) {
                    if (firstDataIndex != 0) {
                        int bytesToSkip = 8 * firstDataIndex;
                        source.position(currentPosition + bytesToSkip);
                    }
                    for (int i = 0; i < numToRead; ++i) {
                        target[i] = (int)((double)scalingOffset + (double)scalingFactor * source.getDouble());
                    }
                } else {
                    throw new RuntimeException("unknown data dtype");
                }
                return target;
            }
            if (scaling_dtype == 2) {
                short scalingOffset = BinaryTimeseries.readScalingOffset_short(source);
                short scalingFactor = BinaryTimeseries.readScalingFactor_short(source);
                BinaryTimeseries.readReservedDummy(source);
                byte data_dtype = BinaryTimeseries.readDataType(source);
                int numSamples = BinaryTimeseries.readNumSamples(source);
                int numToRead = lastDataIndex == -1 ? numSamples - firstDataIndex : lastDataIndex - firstDataIndex + 1;
                int currentPosition = source.position();
                int[] target = new int[numToRead];
                if (data_dtype == 1) {
                    if (firstDataIndex != 0) {
                        int bytesToSkip = 1 * firstDataIndex;
                        source.position(currentPosition + bytesToSkip);
                    }
                    for (int i = 0; i < numToRead; ++i) {
                        target[i] = scalingOffset + scalingFactor * source.get();
                    }
                } else if (data_dtype == 2) {
                    if (firstDataIndex != 0) {
                        int bytesToSkip = 2 * firstDataIndex;
                        source.position(currentPosition + bytesToSkip);
                    }
                    for (int i = 0; i < numToRead; ++i) {
                        target[i] = scalingOffset + scalingFactor * source.getShort();
                    }
                } else if (data_dtype == 3) {
                    if (firstDataIndex != 0) {
                        int bytesToSkip = 4 * firstDataIndex;
                        source.position(currentPosition + bytesToSkip);
                    }
                    for (int i = 0; i < numToRead; ++i) {
                        target[i] = scalingOffset + scalingFactor * source.getInt();
                    }
                } else if (data_dtype == 4) {
                    if (firstDataIndex != 0) {
                        int bytesToSkip = 8 * firstDataIndex;
                        source.position(currentPosition + bytesToSkip);
                    }
                    for (int i = 0; i < numToRead; ++i) {
                        target[i] = (int)((long)scalingOffset + (long)scalingFactor * source.getLong());
                    }
                } else if (data_dtype == 5) {
                    if (firstDataIndex != 0) {
                        int bytesToSkip = 4 * firstDataIndex;
                        source.position(currentPosition + bytesToSkip);
                    }
                    for (int i = 0; i < numToRead; ++i) {
                        target[i] = (int)((float)scalingOffset + (float)scalingFactor * source.getFloat());
                    }
                } else if (data_dtype == 6) {
                    if (firstDataIndex != 0) {
                        int bytesToSkip = 8 * firstDataIndex;
                        source.position(currentPosition + bytesToSkip);
                    }
                    for (int i = 0; i < numToRead; ++i) {
                        target[i] = (int)((double)scalingOffset + (double)scalingFactor * source.getDouble());
                    }
                } else {
                    throw new RuntimeException("unknown data dtype");
                }
                return target;
            }
            if (scaling_dtype == 3) {
                int scalingOffset = BinaryTimeseries.readScalingOffset_int(source);
                int scalingFactor = BinaryTimeseries.readScalingFactor_int(source);
                BinaryTimeseries.readReservedDummy(source);
                byte data_dtype = BinaryTimeseries.readDataType(source);
                int numSamples = BinaryTimeseries.readNumSamples(source);
                int numToRead = lastDataIndex == -1 ? numSamples - firstDataIndex : lastDataIndex - firstDataIndex + 1;
                int currentPosition = source.position();
                int[] target = new int[numToRead];
                if (data_dtype == 1) {
                    if (firstDataIndex != 0) {
                        int bytesToSkip = 1 * firstDataIndex;
                        source.position(currentPosition + bytesToSkip);
                    }
                    for (int i = 0; i < numToRead; ++i) {
                        target[i] = scalingOffset + scalingFactor * source.get();
                    }
                } else if (data_dtype == 2) {
                    if (firstDataIndex != 0) {
                        int bytesToSkip = 2 * firstDataIndex;
                        source.position(currentPosition + bytesToSkip);
                    }
                    for (int i = 0; i < numToRead; ++i) {
                        target[i] = scalingOffset + scalingFactor * source.getShort();
                    }
                } else if (data_dtype == 3) {
                    if (firstDataIndex != 0) {
                        int bytesToSkip = 4 * firstDataIndex;
                        source.position(currentPosition + bytesToSkip);
                    }
                    for (int i = 0; i < numToRead; ++i) {
                        target[i] = scalingOffset + scalingFactor * source.getInt();
                    }
                } else if (data_dtype == 4) {
                    if (firstDataIndex != 0) {
                        int bytesToSkip = 8 * firstDataIndex;
                        source.position(currentPosition + bytesToSkip);
                    }
                    for (int i = 0; i < numToRead; ++i) {
                        target[i] = (int)((long)scalingOffset + (long)scalingFactor * source.getLong());
                    }
                } else if (data_dtype == 5) {
                    if (firstDataIndex != 0) {
                        int bytesToSkip = 4 * firstDataIndex;
                        source.position(currentPosition + bytesToSkip);
                    }
                    for (int i = 0; i < numToRead; ++i) {
                        target[i] = (int)((float)scalingOffset + (float)scalingFactor * source.getFloat());
                    }
                } else if (data_dtype == 6) {
                    if (firstDataIndex != 0) {
                        int bytesToSkip = 8 * firstDataIndex;
                        source.position(currentPosition + bytesToSkip);
                    }
                    for (int i = 0; i < numToRead; ++i) {
                        target[i] = (int)((double)scalingOffset + (double)scalingFactor * source.getDouble());
                    }
                } else {
                    throw new RuntimeException("unknown data dtype");
                }
                return target;
            }
            if (scaling_dtype == 4) {
                long scalingOffset = BinaryTimeseries.readScalingOffset_long(source);
                long scalingFactor = BinaryTimeseries.readScalingFactor_long(source);
                BinaryTimeseries.readReservedDummy(source);
                byte data_dtype = BinaryTimeseries.readDataType(source);
                int numSamples = BinaryTimeseries.readNumSamples(source);
                int numToRead = lastDataIndex == -1 ? numSamples - firstDataIndex : lastDataIndex - firstDataIndex + 1;
                int currentPosition = source.position();
                int[] target = new int[numToRead];
                if (data_dtype == 1) {
                    if (firstDataIndex != 0) {
                        int bytesToSkip = 1 * firstDataIndex;
                        source.position(currentPosition + bytesToSkip);
                    }
                    for (int i = 0; i < numToRead; ++i) {
                        target[i] = (int)(scalingOffset + scalingFactor * (long)source.get());
                    }
                } else if (data_dtype == 2) {
                    if (firstDataIndex != 0) {
                        int bytesToSkip = 2 * firstDataIndex;
                        source.position(currentPosition + bytesToSkip);
                    }
                    for (int i = 0; i < numToRead; ++i) {
                        target[i] = (int)(scalingOffset + scalingFactor * (long)source.getShort());
                    }
                } else if (data_dtype == 3) {
                    if (firstDataIndex != 0) {
                        int bytesToSkip = 4 * firstDataIndex;
                        source.position(currentPosition + bytesToSkip);
                    }
                    for (int i = 0; i < numToRead; ++i) {
                        target[i] = (int)(scalingOffset + scalingFactor * (long)source.getInt());
                    }
                } else if (data_dtype == 4) {
                    if (firstDataIndex != 0) {
                        int bytesToSkip = 8 * firstDataIndex;
                        source.position(currentPosition + bytesToSkip);
                    }
                    for (int i = 0; i < numToRead; ++i) {
                        target[i] = (int)(scalingOffset + scalingFactor * source.getLong());
                    }
                } else if (data_dtype == 5) {
                    if (firstDataIndex != 0) {
                        int bytesToSkip = 4 * firstDataIndex;
                        source.position(currentPosition + bytesToSkip);
                    }
                    for (int i = 0; i < numToRead; ++i) {
                        target[i] = (int)((float)scalingOffset + (float)scalingFactor * source.getFloat());
                    }
                } else if (data_dtype == 6) {
                    if (firstDataIndex != 0) {
                        int bytesToSkip = 8 * firstDataIndex;
                        source.position(currentPosition + bytesToSkip);
                    }
                    for (int i = 0; i < numToRead; ++i) {
                        target[i] = (int)((double)scalingOffset + (double)scalingFactor * source.getDouble());
                    }
                } else {
                    throw new RuntimeException("unknown data dtype");
                }
                return target;
            }
            if (scaling_dtype == 5) {
                float scalingOffset = BinaryTimeseries.readScalingOffset_float(source);
                float scalingFactor = BinaryTimeseries.readScalingFactor_float(source);
                BinaryTimeseries.readReservedDummy(source);
                byte data_dtype = BinaryTimeseries.readDataType(source);
                int numSamples = BinaryTimeseries.readNumSamples(source);
                int numToRead = lastDataIndex == -1 ? numSamples - firstDataIndex : lastDataIndex - firstDataIndex + 1;
                int currentPosition = source.position();
                int[] target = new int[numToRead];
                if (data_dtype == 1) {
                    if (firstDataIndex != 0) {
                        int bytesToSkip = 1 * firstDataIndex;
                        source.position(currentPosition + bytesToSkip);
                    }
                    for (int i = 0; i < numToRead; ++i) {
                        target[i] = (int)(scalingOffset + scalingFactor * (float)source.get());
                    }
                } else if (data_dtype == 2) {
                    if (firstDataIndex != 0) {
                        int bytesToSkip = 2 * firstDataIndex;
                        source.position(currentPosition + bytesToSkip);
                    }
                    for (int i = 0; i < numToRead; ++i) {
                        target[i] = (int)(scalingOffset + scalingFactor * (float)source.getShort());
                    }
                } else if (data_dtype == 3) {
                    if (firstDataIndex != 0) {
                        int bytesToSkip = 4 * firstDataIndex;
                        source.position(currentPosition + bytesToSkip);
                    }
                    for (int i = 0; i < numToRead; ++i) {
                        target[i] = (int)(scalingOffset + scalingFactor * (float)source.getInt());
                    }
                } else if (data_dtype == 4) {
                    if (firstDataIndex != 0) {
                        int bytesToSkip = 8 * firstDataIndex;
                        source.position(currentPosition + bytesToSkip);
                    }
                    for (int i = 0; i < numToRead; ++i) {
                        target[i] = (int)(scalingOffset + scalingFactor * (float)source.getLong());
                    }
                } else if (data_dtype == 5) {
                    if (firstDataIndex != 0) {
                        int bytesToSkip = 4 * firstDataIndex;
                        source.position(currentPosition + bytesToSkip);
                    }
                    for (int i = 0; i < numToRead; ++i) {
                        target[i] = (int)(scalingOffset + scalingFactor * source.getFloat());
                    }
                } else if (data_dtype == 6) {
                    if (firstDataIndex != 0) {
                        int bytesToSkip = 8 * firstDataIndex;
                        source.position(currentPosition + bytesToSkip);
                    }
                    for (int i = 0; i < numToRead; ++i) {
                        target[i] = (int)((double)scalingOffset + (double)scalingFactor * source.getDouble());
                    }
                } else {
                    throw new RuntimeException("unknown data dtype");
                }
                return target;
            }
            if (scaling_dtype == 6) {
                double scalingOffset = BinaryTimeseries.readScalingOffset_double(source);
                double scalingFactor = BinaryTimeseries.readScalingFactor_double(source);
                BinaryTimeseries.readReservedDummy(source);
                byte data_dtype = BinaryTimeseries.readDataType(source);
                int numSamples = BinaryTimeseries.readNumSamples(source);
                int numToRead = lastDataIndex == -1 ? numSamples - firstDataIndex : lastDataIndex - firstDataIndex + 1;
                int currentPosition = source.position();
                int[] target = new int[numToRead];
                if (data_dtype == 1) {
                    if (firstDataIndex != 0) {
                        int bytesToSkip = 1 * firstDataIndex;
                        source.position(currentPosition + bytesToSkip);
                    }
                    for (int i = 0; i < numToRead; ++i) {
                        target[i] = (int)(scalingOffset + scalingFactor * (double)source.get());
                    }
                } else if (data_dtype == 2) {
                    if (firstDataIndex != 0) {
                        int bytesToSkip = 2 * firstDataIndex;
                        source.position(currentPosition + bytesToSkip);
                    }
                    for (int i = 0; i < numToRead; ++i) {
                        target[i] = (int)(scalingOffset + scalingFactor * (double)source.getShort());
                    }
                } else if (data_dtype == 3) {
                    if (firstDataIndex != 0) {
                        int bytesToSkip = 4 * firstDataIndex;
                        source.position(currentPosition + bytesToSkip);
                    }
                    for (int i = 0; i < numToRead; ++i) {
                        target[i] = (int)(scalingOffset + scalingFactor * (double)source.getInt());
                    }
                } else if (data_dtype == 4) {
                    if (firstDataIndex != 0) {
                        int bytesToSkip = 8 * firstDataIndex;
                        source.position(currentPosition + bytesToSkip);
                    }
                    for (int i = 0; i < numToRead; ++i) {
                        target[i] = (int)(scalingOffset + scalingFactor * (double)source.getLong());
                    }
                } else if (data_dtype == 5) {
                    if (firstDataIndex != 0) {
                        int bytesToSkip = 4 * firstDataIndex;
                        source.position(currentPosition + bytesToSkip);
                    }
                    for (int i = 0; i < numToRead; ++i) {
                        target[i] = (int)(scalingOffset + scalingFactor * (double)source.getFloat());
                    }
                } else if (data_dtype == 6) {
                    if (firstDataIndex != 0) {
                        int bytesToSkip = 8 * firstDataIndex;
                        source.position(currentPosition + bytesToSkip);
                    }
                    for (int i = 0; i < numToRead; ++i) {
                        target[i] = (int)(scalingOffset + scalingFactor * source.getDouble());
                    }
                } else {
                    throw new RuntimeException("unknown data dtype");
                }
                return target;
            }
            throw new RuntimeException("unknown scaling dtype");
        }
        BinaryTimeseries.readScalingDisabled(source);
        BinaryTimeseries.readReservedDummy(source);
        byte data_dtype = BinaryTimeseries.readDataType(source);
        int numSamples = BinaryTimeseries.readNumSamples(source);
        int numToRead = lastDataIndex == -1 ? numSamples - firstDataIndex : lastDataIndex - firstDataIndex + 1;
        int currentPosition = source.position();
        int[] target = new int[numToRead];
        if (data_dtype == 1) {
            if (firstDataIndex != 0) {
                int bytesToSkip = 1 * firstDataIndex;
                source.position(currentPosition + bytesToSkip);
            }
            for (int i = 0; i < numToRead; ++i) {
                target[i] = source.get();
            }
        } else if (data_dtype == 2) {
            if (firstDataIndex != 0) {
                int bytesToSkip = 2 * firstDataIndex;
                source.position(currentPosition + bytesToSkip);
            }
            for (int i = 0; i < numToRead; ++i) {
                target[i] = source.getShort();
            }
        } else if (data_dtype == 3) {
            if (firstDataIndex != 0) {
                int bytesToSkip = 4 * firstDataIndex;
                source.position(currentPosition + bytesToSkip);
            }
            for (int i = 0; i < numToRead; ++i) {
                target[i] = source.getInt();
            }
        } else if (data_dtype == 4) {
            if (firstDataIndex != 0) {
                int bytesToSkip = 8 * firstDataIndex;
                source.position(currentPosition + bytesToSkip);
            }
            for (int i = 0; i < numToRead; ++i) {
                target[i] = (int)source.getLong();
            }
        } else if (data_dtype == 5) {
            if (firstDataIndex != 0) {
                int bytesToSkip = 4 * firstDataIndex;
                source.position(currentPosition + bytesToSkip);
            }
            for (int i = 0; i < numToRead; ++i) {
                target[i] = (int)source.getFloat();
            }
        } else if (data_dtype == 6) {
            if (firstDataIndex != 0) {
                int bytesToSkip = 8 * firstDataIndex;
                source.position(currentPosition + bytesToSkip);
            }
            for (int i = 0; i < numToRead; ++i) {
                target[i] = (int)source.getDouble();
            }
        } else {
            throw new RuntimeException("unknown data dtype");
        }
        return target;
    }

    public static final long[] readData_long(ByteBuffer source) {
        boolean firstDataIndex = false;
        int lastDataIndex = -1;
        return BinaryTimeseries.readData_long(source, 0, -1);
    }

    public static final long[] readData_long(ByteBuffer source, int firstDataIndex, int lastDataIndex) {
        byte scaling_dtype = BinaryTimeseries.readScalingType(source);
        if (BinaryTimeseries.hasScaling(scaling_dtype)) {
            if (scaling_dtype == 1) {
                byte scalingOffset = BinaryTimeseries.readScalingOffset_byte(source);
                byte scalingFactor = BinaryTimeseries.readScalingFactor_byte(source);
                BinaryTimeseries.readReservedDummy(source);
                byte data_dtype = BinaryTimeseries.readDataType(source);
                int numSamples = BinaryTimeseries.readNumSamples(source);
                int numToRead = lastDataIndex == -1 ? numSamples - firstDataIndex : lastDataIndex - firstDataIndex + 1;
                int currentPosition = source.position();
                long[] target = new long[numToRead];
                if (data_dtype == 1) {
                    if (firstDataIndex != 0) {
                        int bytesToSkip = 1 * firstDataIndex;
                        source.position(currentPosition + bytesToSkip);
                    }
                    for (int i = 0; i < numToRead; ++i) {
                        target[i] = scalingOffset + scalingFactor * source.get();
                    }
                } else if (data_dtype == 2) {
                    if (firstDataIndex != 0) {
                        int bytesToSkip = 2 * firstDataIndex;
                        source.position(currentPosition + bytesToSkip);
                    }
                    for (int i = 0; i < numToRead; ++i) {
                        target[i] = scalingOffset + scalingFactor * source.getShort();
                    }
                } else if (data_dtype == 3) {
                    if (firstDataIndex != 0) {
                        int bytesToSkip = 4 * firstDataIndex;
                        source.position(currentPosition + bytesToSkip);
                    }
                    for (int i = 0; i < numToRead; ++i) {
                        target[i] = scalingOffset + scalingFactor * source.getInt();
                    }
                } else if (data_dtype == 4) {
                    if (firstDataIndex != 0) {
                        int bytesToSkip = 8 * firstDataIndex;
                        source.position(currentPosition + bytesToSkip);
                    }
                    for (int i = 0; i < numToRead; ++i) {
                        target[i] = (long)scalingOffset + (long)scalingFactor * source.getLong();
                    }
                } else if (data_dtype == 5) {
                    if (firstDataIndex != 0) {
                        int bytesToSkip = 4 * firstDataIndex;
                        source.position(currentPosition + bytesToSkip);
                    }
                    for (int i = 0; i < numToRead; ++i) {
                        target[i] = (long)((float)scalingOffset + (float)scalingFactor * source.getFloat());
                    }
                } else if (data_dtype == 6) {
                    if (firstDataIndex != 0) {
                        int bytesToSkip = 8 * firstDataIndex;
                        source.position(currentPosition + bytesToSkip);
                    }
                    for (int i = 0; i < numToRead; ++i) {
                        target[i] = (long)((double)scalingOffset + (double)scalingFactor * source.getDouble());
                    }
                } else {
                    throw new RuntimeException("unknown data dtype");
                }
                return target;
            }
            if (scaling_dtype == 2) {
                short scalingOffset = BinaryTimeseries.readScalingOffset_short(source);
                short scalingFactor = BinaryTimeseries.readScalingFactor_short(source);
                BinaryTimeseries.readReservedDummy(source);
                byte data_dtype = BinaryTimeseries.readDataType(source);
                int numSamples = BinaryTimeseries.readNumSamples(source);
                int numToRead = lastDataIndex == -1 ? numSamples - firstDataIndex : lastDataIndex - firstDataIndex + 1;
                int currentPosition = source.position();
                long[] target = new long[numToRead];
                if (data_dtype == 1) {
                    if (firstDataIndex != 0) {
                        int bytesToSkip = 1 * firstDataIndex;
                        source.position(currentPosition + bytesToSkip);
                    }
                    for (int i = 0; i < numToRead; ++i) {
                        target[i] = scalingOffset + scalingFactor * source.get();
                    }
                } else if (data_dtype == 2) {
                    if (firstDataIndex != 0) {
                        int bytesToSkip = 2 * firstDataIndex;
                        source.position(currentPosition + bytesToSkip);
                    }
                    for (int i = 0; i < numToRead; ++i) {
                        target[i] = scalingOffset + scalingFactor * source.getShort();
                    }
                } else if (data_dtype == 3) {
                    if (firstDataIndex != 0) {
                        int bytesToSkip = 4 * firstDataIndex;
                        source.position(currentPosition + bytesToSkip);
                    }
                    for (int i = 0; i < numToRead; ++i) {
                        target[i] = scalingOffset + scalingFactor * source.getInt();
                    }
                } else if (data_dtype == 4) {
                    if (firstDataIndex != 0) {
                        int bytesToSkip = 8 * firstDataIndex;
                        source.position(currentPosition + bytesToSkip);
                    }
                    for (int i = 0; i < numToRead; ++i) {
                        target[i] = (long)scalingOffset + (long)scalingFactor * source.getLong();
                    }
                } else if (data_dtype == 5) {
                    if (firstDataIndex != 0) {
                        int bytesToSkip = 4 * firstDataIndex;
                        source.position(currentPosition + bytesToSkip);
                    }
                    for (int i = 0; i < numToRead; ++i) {
                        target[i] = (long)((float)scalingOffset + (float)scalingFactor * source.getFloat());
                    }
                } else if (data_dtype == 6) {
                    if (firstDataIndex != 0) {
                        int bytesToSkip = 8 * firstDataIndex;
                        source.position(currentPosition + bytesToSkip);
                    }
                    for (int i = 0; i < numToRead; ++i) {
                        target[i] = (long)((double)scalingOffset + (double)scalingFactor * source.getDouble());
                    }
                } else {
                    throw new RuntimeException("unknown data dtype");
                }
                return target;
            }
            if (scaling_dtype == 3) {
                int scalingOffset = BinaryTimeseries.readScalingOffset_int(source);
                int scalingFactor = BinaryTimeseries.readScalingFactor_int(source);
                BinaryTimeseries.readReservedDummy(source);
                byte data_dtype = BinaryTimeseries.readDataType(source);
                int numSamples = BinaryTimeseries.readNumSamples(source);
                int numToRead = lastDataIndex == -1 ? numSamples - firstDataIndex : lastDataIndex - firstDataIndex + 1;
                int currentPosition = source.position();
                long[] target = new long[numToRead];
                if (data_dtype == 1) {
                    if (firstDataIndex != 0) {
                        int bytesToSkip = 1 * firstDataIndex;
                        source.position(currentPosition + bytesToSkip);
                    }
                    for (int i = 0; i < numToRead; ++i) {
                        target[i] = scalingOffset + scalingFactor * source.get();
                    }
                } else if (data_dtype == 2) {
                    if (firstDataIndex != 0) {
                        int bytesToSkip = 2 * firstDataIndex;
                        source.position(currentPosition + bytesToSkip);
                    }
                    for (int i = 0; i < numToRead; ++i) {
                        target[i] = scalingOffset + scalingFactor * source.getShort();
                    }
                } else if (data_dtype == 3) {
                    if (firstDataIndex != 0) {
                        int bytesToSkip = 4 * firstDataIndex;
                        source.position(currentPosition + bytesToSkip);
                    }
                    for (int i = 0; i < numToRead; ++i) {
                        target[i] = scalingOffset + scalingFactor * source.getInt();
                    }
                } else if (data_dtype == 4) {
                    if (firstDataIndex != 0) {
                        int bytesToSkip = 8 * firstDataIndex;
                        source.position(currentPosition + bytesToSkip);
                    }
                    for (int i = 0; i < numToRead; ++i) {
                        target[i] = (long)scalingOffset + (long)scalingFactor * source.getLong();
                    }
                } else if (data_dtype == 5) {
                    if (firstDataIndex != 0) {
                        int bytesToSkip = 4 * firstDataIndex;
                        source.position(currentPosition + bytesToSkip);
                    }
                    for (int i = 0; i < numToRead; ++i) {
                        target[i] = (long)((float)scalingOffset + (float)scalingFactor * source.getFloat());
                    }
                } else if (data_dtype == 6) {
                    if (firstDataIndex != 0) {
                        int bytesToSkip = 8 * firstDataIndex;
                        source.position(currentPosition + bytesToSkip);
                    }
                    for (int i = 0; i < numToRead; ++i) {
                        target[i] = (long)((double)scalingOffset + (double)scalingFactor * source.getDouble());
                    }
                } else {
                    throw new RuntimeException("unknown data dtype");
                }
                return target;
            }
            if (scaling_dtype == 4) {
                long scalingOffset = BinaryTimeseries.readScalingOffset_long(source);
                long scalingFactor = BinaryTimeseries.readScalingFactor_long(source);
                BinaryTimeseries.readReservedDummy(source);
                byte data_dtype = BinaryTimeseries.readDataType(source);
                int numSamples = BinaryTimeseries.readNumSamples(source);
                int numToRead = lastDataIndex == -1 ? numSamples - firstDataIndex : lastDataIndex - firstDataIndex + 1;
                int currentPosition = source.position();
                long[] target = new long[numToRead];
                if (data_dtype == 1) {
                    if (firstDataIndex != 0) {
                        int bytesToSkip = 1 * firstDataIndex;
                        source.position(currentPosition + bytesToSkip);
                    }
                    for (int i = 0; i < numToRead; ++i) {
                        target[i] = scalingOffset + scalingFactor * (long)source.get();
                    }
                } else if (data_dtype == 2) {
                    if (firstDataIndex != 0) {
                        int bytesToSkip = 2 * firstDataIndex;
                        source.position(currentPosition + bytesToSkip);
                    }
                    for (int i = 0; i < numToRead; ++i) {
                        target[i] = scalingOffset + scalingFactor * (long)source.getShort();
                    }
                } else if (data_dtype == 3) {
                    if (firstDataIndex != 0) {
                        int bytesToSkip = 4 * firstDataIndex;
                        source.position(currentPosition + bytesToSkip);
                    }
                    for (int i = 0; i < numToRead; ++i) {
                        target[i] = scalingOffset + scalingFactor * (long)source.getInt();
                    }
                } else if (data_dtype == 4) {
                    if (firstDataIndex != 0) {
                        int bytesToSkip = 8 * firstDataIndex;
                        source.position(currentPosition + bytesToSkip);
                    }
                    for (int i = 0; i < numToRead; ++i) {
                        target[i] = scalingOffset + scalingFactor * source.getLong();
                    }
                } else if (data_dtype == 5) {
                    if (firstDataIndex != 0) {
                        int bytesToSkip = 4 * firstDataIndex;
                        source.position(currentPosition + bytesToSkip);
                    }
                    for (int i = 0; i < numToRead; ++i) {
                        target[i] = (long)((float)scalingOffset + (float)scalingFactor * source.getFloat());
                    }
                } else if (data_dtype == 6) {
                    if (firstDataIndex != 0) {
                        int bytesToSkip = 8 * firstDataIndex;
                        source.position(currentPosition + bytesToSkip);
                    }
                    for (int i = 0; i < numToRead; ++i) {
                        target[i] = (long)((double)scalingOffset + (double)scalingFactor * source.getDouble());
                    }
                } else {
                    throw new RuntimeException("unknown data dtype");
                }
                return target;
            }
            if (scaling_dtype == 5) {
                float scalingOffset = BinaryTimeseries.readScalingOffset_float(source);
                float scalingFactor = BinaryTimeseries.readScalingFactor_float(source);
                BinaryTimeseries.readReservedDummy(source);
                byte data_dtype = BinaryTimeseries.readDataType(source);
                int numSamples = BinaryTimeseries.readNumSamples(source);
                int numToRead = lastDataIndex == -1 ? numSamples - firstDataIndex : lastDataIndex - firstDataIndex + 1;
                int currentPosition = source.position();
                long[] target = new long[numToRead];
                if (data_dtype == 1) {
                    if (firstDataIndex != 0) {
                        int bytesToSkip = 1 * firstDataIndex;
                        source.position(currentPosition + bytesToSkip);
                    }
                    for (int i = 0; i < numToRead; ++i) {
                        target[i] = (long)(scalingOffset + scalingFactor * (float)source.get());
                    }
                } else if (data_dtype == 2) {
                    if (firstDataIndex != 0) {
                        int bytesToSkip = 2 * firstDataIndex;
                        source.position(currentPosition + bytesToSkip);
                    }
                    for (int i = 0; i < numToRead; ++i) {
                        target[i] = (long)(scalingOffset + scalingFactor * (float)source.getShort());
                    }
                } else if (data_dtype == 3) {
                    if (firstDataIndex != 0) {
                        int bytesToSkip = 4 * firstDataIndex;
                        source.position(currentPosition + bytesToSkip);
                    }
                    for (int i = 0; i < numToRead; ++i) {
                        target[i] = (long)(scalingOffset + scalingFactor * (float)source.getInt());
                    }
                } else if (data_dtype == 4) {
                    if (firstDataIndex != 0) {
                        int bytesToSkip = 8 * firstDataIndex;
                        source.position(currentPosition + bytesToSkip);
                    }
                    for (int i = 0; i < numToRead; ++i) {
                        target[i] = (long)(scalingOffset + scalingFactor * (float)source.getLong());
                    }
                } else if (data_dtype == 5) {
                    if (firstDataIndex != 0) {
                        int bytesToSkip = 4 * firstDataIndex;
                        source.position(currentPosition + bytesToSkip);
                    }
                    for (int i = 0; i < numToRead; ++i) {
                        target[i] = (long)(scalingOffset + scalingFactor * source.getFloat());
                    }
                } else if (data_dtype == 6) {
                    if (firstDataIndex != 0) {
                        int bytesToSkip = 8 * firstDataIndex;
                        source.position(currentPosition + bytesToSkip);
                    }
                    for (int i = 0; i < numToRead; ++i) {
                        target[i] = (long)((double)scalingOffset + (double)scalingFactor * source.getDouble());
                    }
                } else {
                    throw new RuntimeException("unknown data dtype");
                }
                return target;
            }
            if (scaling_dtype == 6) {
                double scalingOffset = BinaryTimeseries.readScalingOffset_double(source);
                double scalingFactor = BinaryTimeseries.readScalingFactor_double(source);
                BinaryTimeseries.readReservedDummy(source);
                byte data_dtype = BinaryTimeseries.readDataType(source);
                int numSamples = BinaryTimeseries.readNumSamples(source);
                int numToRead = lastDataIndex == -1 ? numSamples - firstDataIndex : lastDataIndex - firstDataIndex + 1;
                int currentPosition = source.position();
                long[] target = new long[numToRead];
                if (data_dtype == 1) {
                    if (firstDataIndex != 0) {
                        int bytesToSkip = 1 * firstDataIndex;
                        source.position(currentPosition + bytesToSkip);
                    }
                    for (int i = 0; i < numToRead; ++i) {
                        target[i] = (long)(scalingOffset + scalingFactor * (double)source.get());
                    }
                } else if (data_dtype == 2) {
                    if (firstDataIndex != 0) {
                        int bytesToSkip = 2 * firstDataIndex;
                        source.position(currentPosition + bytesToSkip);
                    }
                    for (int i = 0; i < numToRead; ++i) {
                        target[i] = (long)(scalingOffset + scalingFactor * (double)source.getShort());
                    }
                } else if (data_dtype == 3) {
                    if (firstDataIndex != 0) {
                        int bytesToSkip = 4 * firstDataIndex;
                        source.position(currentPosition + bytesToSkip);
                    }
                    for (int i = 0; i < numToRead; ++i) {
                        target[i] = (long)(scalingOffset + scalingFactor * (double)source.getInt());
                    }
                } else if (data_dtype == 4) {
                    if (firstDataIndex != 0) {
                        int bytesToSkip = 8 * firstDataIndex;
                        source.position(currentPosition + bytesToSkip);
                    }
                    for (int i = 0; i < numToRead; ++i) {
                        target[i] = (long)(scalingOffset + scalingFactor * (double)source.getLong());
                    }
                } else if (data_dtype == 5) {
                    if (firstDataIndex != 0) {
                        int bytesToSkip = 4 * firstDataIndex;
                        source.position(currentPosition + bytesToSkip);
                    }
                    for (int i = 0; i < numToRead; ++i) {
                        target[i] = (long)(scalingOffset + scalingFactor * (double)source.getFloat());
                    }
                } else if (data_dtype == 6) {
                    if (firstDataIndex != 0) {
                        int bytesToSkip = 8 * firstDataIndex;
                        source.position(currentPosition + bytesToSkip);
                    }
                    for (int i = 0; i < numToRead; ++i) {
                        target[i] = (long)(scalingOffset + scalingFactor * source.getDouble());
                    }
                } else {
                    throw new RuntimeException("unknown data dtype");
                }
                return target;
            }
            throw new RuntimeException("unknown scaling dtype");
        }
        BinaryTimeseries.readScalingDisabled(source);
        BinaryTimeseries.readReservedDummy(source);
        byte data_dtype = BinaryTimeseries.readDataType(source);
        int numSamples = BinaryTimeseries.readNumSamples(source);
        int numToRead = lastDataIndex == -1 ? numSamples - firstDataIndex : lastDataIndex - firstDataIndex + 1;
        int currentPosition = source.position();
        long[] target = new long[numToRead];
        if (data_dtype == 1) {
            if (firstDataIndex != 0) {
                int bytesToSkip = 1 * firstDataIndex;
                source.position(currentPosition + bytesToSkip);
            }
            for (int i = 0; i < numToRead; ++i) {
                target[i] = source.get();
            }
        } else if (data_dtype == 2) {
            if (firstDataIndex != 0) {
                int bytesToSkip = 2 * firstDataIndex;
                source.position(currentPosition + bytesToSkip);
            }
            for (int i = 0; i < numToRead; ++i) {
                target[i] = source.getShort();
            }
        } else if (data_dtype == 3) {
            if (firstDataIndex != 0) {
                int bytesToSkip = 4 * firstDataIndex;
                source.position(currentPosition + bytesToSkip);
            }
            for (int i = 0; i < numToRead; ++i) {
                target[i] = source.getInt();
            }
        } else if (data_dtype == 4) {
            if (firstDataIndex != 0) {
                int bytesToSkip = 8 * firstDataIndex;
                source.position(currentPosition + bytesToSkip);
            }
            for (int i = 0; i < numToRead; ++i) {
                target[i] = source.getLong();
            }
        } else if (data_dtype == 5) {
            if (firstDataIndex != 0) {
                int bytesToSkip = 4 * firstDataIndex;
                source.position(currentPosition + bytesToSkip);
            }
            for (int i = 0; i < numToRead; ++i) {
                target[i] = (long)source.getFloat();
            }
        } else if (data_dtype == 6) {
            if (firstDataIndex != 0) {
                int bytesToSkip = 8 * firstDataIndex;
                source.position(currentPosition + bytesToSkip);
            }
            for (int i = 0; i < numToRead; ++i) {
                target[i] = (long)source.getDouble();
            }
        } else {
            throw new RuntimeException("unknown data dtype");
        }
        return target;
    }

    public static final float[] readData_float(ByteBuffer source) {
        boolean firstDataIndex = false;
        int lastDataIndex = -1;
        return BinaryTimeseries.readData_float(source, 0, -1);
    }

    public static final float[] readData_float(ByteBuffer source, int firstDataIndex, int lastDataIndex) {
        byte scaling_dtype = BinaryTimeseries.readScalingType(source);
        if (BinaryTimeseries.hasScaling(scaling_dtype)) {
            if (scaling_dtype == 1) {
                byte scalingOffset = BinaryTimeseries.readScalingOffset_byte(source);
                byte scalingFactor = BinaryTimeseries.readScalingFactor_byte(source);
                BinaryTimeseries.readReservedDummy(source);
                byte data_dtype = BinaryTimeseries.readDataType(source);
                int numSamples = BinaryTimeseries.readNumSamples(source);
                int numToRead = lastDataIndex == -1 ? numSamples - firstDataIndex : lastDataIndex - firstDataIndex + 1;
                int currentPosition = source.position();
                float[] target = new float[numToRead];
                if (data_dtype == 1) {
                    if (firstDataIndex != 0) {
                        int bytesToSkip = 1 * firstDataIndex;
                        source.position(currentPosition + bytesToSkip);
                    }
                    for (int i = 0; i < numToRead; ++i) {
                        target[i] = scalingOffset + scalingFactor * source.get();
                    }
                } else if (data_dtype == 2) {
                    if (firstDataIndex != 0) {
                        int bytesToSkip = 2 * firstDataIndex;
                        source.position(currentPosition + bytesToSkip);
                    }
                    for (int i = 0; i < numToRead; ++i) {
                        target[i] = scalingOffset + scalingFactor * source.getShort();
                    }
                } else if (data_dtype == 3) {
                    if (firstDataIndex != 0) {
                        int bytesToSkip = 4 * firstDataIndex;
                        source.position(currentPosition + bytesToSkip);
                    }
                    for (int i = 0; i < numToRead; ++i) {
                        target[i] = scalingOffset + scalingFactor * source.getInt();
                    }
                } else if (data_dtype == 4) {
                    if (firstDataIndex != 0) {
                        int bytesToSkip = 8 * firstDataIndex;
                        source.position(currentPosition + bytesToSkip);
                    }
                    for (int i = 0; i < numToRead; ++i) {
                        target[i] = (long)scalingOffset + (long)scalingFactor * source.getLong();
                    }
                } else if (data_dtype == 5) {
                    if (firstDataIndex != 0) {
                        int bytesToSkip = 4 * firstDataIndex;
                        source.position(currentPosition + bytesToSkip);
                    }
                    for (int i = 0; i < numToRead; ++i) {
                        target[i] = (float)scalingOffset + (float)scalingFactor * source.getFloat();
                    }
                } else if (data_dtype == 6) {
                    if (firstDataIndex != 0) {
                        int bytesToSkip = 8 * firstDataIndex;
                        source.position(currentPosition + bytesToSkip);
                    }
                    for (int i = 0; i < numToRead; ++i) {
                        target[i] = (float)((double)scalingOffset + (double)scalingFactor * source.getDouble());
                    }
                } else {
                    throw new RuntimeException("unknown data dtype");
                }
                return target;
            }
            if (scaling_dtype == 2) {
                short scalingOffset = BinaryTimeseries.readScalingOffset_short(source);
                short scalingFactor = BinaryTimeseries.readScalingFactor_short(source);
                BinaryTimeseries.readReservedDummy(source);
                byte data_dtype = BinaryTimeseries.readDataType(source);
                int numSamples = BinaryTimeseries.readNumSamples(source);
                int numToRead = lastDataIndex == -1 ? numSamples - firstDataIndex : lastDataIndex - firstDataIndex + 1;
                int currentPosition = source.position();
                float[] target = new float[numToRead];
                if (data_dtype == 1) {
                    if (firstDataIndex != 0) {
                        int bytesToSkip = 1 * firstDataIndex;
                        source.position(currentPosition + bytesToSkip);
                    }
                    for (int i = 0; i < numToRead; ++i) {
                        target[i] = scalingOffset + scalingFactor * source.get();
                    }
                } else if (data_dtype == 2) {
                    if (firstDataIndex != 0) {
                        int bytesToSkip = 2 * firstDataIndex;
                        source.position(currentPosition + bytesToSkip);
                    }
                    for (int i = 0; i < numToRead; ++i) {
                        target[i] = scalingOffset + scalingFactor * source.getShort();
                    }
                } else if (data_dtype == 3) {
                    if (firstDataIndex != 0) {
                        int bytesToSkip = 4 * firstDataIndex;
                        source.position(currentPosition + bytesToSkip);
                    }
                    for (int i = 0; i < numToRead; ++i) {
                        target[i] = scalingOffset + scalingFactor * source.getInt();
                    }
                } else if (data_dtype == 4) {
                    if (firstDataIndex != 0) {
                        int bytesToSkip = 8 * firstDataIndex;
                        source.position(currentPosition + bytesToSkip);
                    }
                    for (int i = 0; i < numToRead; ++i) {
                        target[i] = (long)scalingOffset + (long)scalingFactor * source.getLong();
                    }
                } else if (data_dtype == 5) {
                    if (firstDataIndex != 0) {
                        int bytesToSkip = 4 * firstDataIndex;
                        source.position(currentPosition + bytesToSkip);
                    }
                    for (int i = 0; i < numToRead; ++i) {
                        target[i] = (float)scalingOffset + (float)scalingFactor * source.getFloat();
                    }
                } else if (data_dtype == 6) {
                    if (firstDataIndex != 0) {
                        int bytesToSkip = 8 * firstDataIndex;
                        source.position(currentPosition + bytesToSkip);
                    }
                    for (int i = 0; i < numToRead; ++i) {
                        target[i] = (float)((double)scalingOffset + (double)scalingFactor * source.getDouble());
                    }
                } else {
                    throw new RuntimeException("unknown data dtype");
                }
                return target;
            }
            if (scaling_dtype == 3) {
                int scalingOffset = BinaryTimeseries.readScalingOffset_int(source);
                int scalingFactor = BinaryTimeseries.readScalingFactor_int(source);
                BinaryTimeseries.readReservedDummy(source);
                byte data_dtype = BinaryTimeseries.readDataType(source);
                int numSamples = BinaryTimeseries.readNumSamples(source);
                int numToRead = lastDataIndex == -1 ? numSamples - firstDataIndex : lastDataIndex - firstDataIndex + 1;
                int currentPosition = source.position();
                float[] target = new float[numToRead];
                if (data_dtype == 1) {
                    if (firstDataIndex != 0) {
                        int bytesToSkip = 1 * firstDataIndex;
                        source.position(currentPosition + bytesToSkip);
                    }
                    for (int i = 0; i < numToRead; ++i) {
                        target[i] = scalingOffset + scalingFactor * source.get();
                    }
                } else if (data_dtype == 2) {
                    if (firstDataIndex != 0) {
                        int bytesToSkip = 2 * firstDataIndex;
                        source.position(currentPosition + bytesToSkip);
                    }
                    for (int i = 0; i < numToRead; ++i) {
                        target[i] = scalingOffset + scalingFactor * source.getShort();
                    }
                } else if (data_dtype == 3) {
                    if (firstDataIndex != 0) {
                        int bytesToSkip = 4 * firstDataIndex;
                        source.position(currentPosition + bytesToSkip);
                    }
                    for (int i = 0; i < numToRead; ++i) {
                        target[i] = scalingOffset + scalingFactor * source.getInt();
                    }
                } else if (data_dtype == 4) {
                    if (firstDataIndex != 0) {
                        int bytesToSkip = 8 * firstDataIndex;
                        source.position(currentPosition + bytesToSkip);
                    }
                    for (int i = 0; i < numToRead; ++i) {
                        target[i] = (long)scalingOffset + (long)scalingFactor * source.getLong();
                    }
                } else if (data_dtype == 5) {
                    if (firstDataIndex != 0) {
                        int bytesToSkip = 4 * firstDataIndex;
                        source.position(currentPosition + bytesToSkip);
                    }
                    for (int i = 0; i < numToRead; ++i) {
                        target[i] = (float)scalingOffset + (float)scalingFactor * source.getFloat();
                    }
                } else if (data_dtype == 6) {
                    if (firstDataIndex != 0) {
                        int bytesToSkip = 8 * firstDataIndex;
                        source.position(currentPosition + bytesToSkip);
                    }
                    for (int i = 0; i < numToRead; ++i) {
                        target[i] = (float)((double)scalingOffset + (double)scalingFactor * source.getDouble());
                    }
                } else {
                    throw new RuntimeException("unknown data dtype");
                }
                return target;
            }
            if (scaling_dtype == 4) {
                long scalingOffset = BinaryTimeseries.readScalingOffset_long(source);
                long scalingFactor = BinaryTimeseries.readScalingFactor_long(source);
                BinaryTimeseries.readReservedDummy(source);
                byte data_dtype = BinaryTimeseries.readDataType(source);
                int numSamples = BinaryTimeseries.readNumSamples(source);
                int numToRead = lastDataIndex == -1 ? numSamples - firstDataIndex : lastDataIndex - firstDataIndex + 1;
                int currentPosition = source.position();
                float[] target = new float[numToRead];
                if (data_dtype == 1) {
                    if (firstDataIndex != 0) {
                        int bytesToSkip = 1 * firstDataIndex;
                        source.position(currentPosition + bytesToSkip);
                    }
                    for (int i = 0; i < numToRead; ++i) {
                        target[i] = scalingOffset + scalingFactor * (long)source.get();
                    }
                } else if (data_dtype == 2) {
                    if (firstDataIndex != 0) {
                        int bytesToSkip = 2 * firstDataIndex;
                        source.position(currentPosition + bytesToSkip);
                    }
                    for (int i = 0; i < numToRead; ++i) {
                        target[i] = scalingOffset + scalingFactor * (long)source.getShort();
                    }
                } else if (data_dtype == 3) {
                    if (firstDataIndex != 0) {
                        int bytesToSkip = 4 * firstDataIndex;
                        source.position(currentPosition + bytesToSkip);
                    }
                    for (int i = 0; i < numToRead; ++i) {
                        target[i] = scalingOffset + scalingFactor * (long)source.getInt();
                    }
                } else if (data_dtype == 4) {
                    if (firstDataIndex != 0) {
                        int bytesToSkip = 8 * firstDataIndex;
                        source.position(currentPosition + bytesToSkip);
                    }
                    for (int i = 0; i < numToRead; ++i) {
                        target[i] = scalingOffset + scalingFactor * source.getLong();
                    }
                } else if (data_dtype == 5) {
                    if (firstDataIndex != 0) {
                        int bytesToSkip = 4 * firstDataIndex;
                        source.position(currentPosition + bytesToSkip);
                    }
                    for (int i = 0; i < numToRead; ++i) {
                        target[i] = (float)scalingOffset + (float)scalingFactor * source.getFloat();
                    }
                } else if (data_dtype == 6) {
                    if (firstDataIndex != 0) {
                        int bytesToSkip = 8 * firstDataIndex;
                        source.position(currentPosition + bytesToSkip);
                    }
                    for (int i = 0; i < numToRead; ++i) {
                        target[i] = (float)((double)scalingOffset + (double)scalingFactor * source.getDouble());
                    }
                } else {
                    throw new RuntimeException("unknown data dtype");
                }
                return target;
            }
            if (scaling_dtype == 5) {
                float scalingOffset = BinaryTimeseries.readScalingOffset_float(source);
                float scalingFactor = BinaryTimeseries.readScalingFactor_float(source);
                BinaryTimeseries.readReservedDummy(source);
                byte data_dtype = BinaryTimeseries.readDataType(source);
                int numSamples = BinaryTimeseries.readNumSamples(source);
                int numToRead = lastDataIndex == -1 ? numSamples - firstDataIndex : lastDataIndex - firstDataIndex + 1;
                int currentPosition = source.position();
                float[] target = new float[numToRead];
                if (data_dtype == 1) {
                    if (firstDataIndex != 0) {
                        int bytesToSkip = 1 * firstDataIndex;
                        source.position(currentPosition + bytesToSkip);
                    }
                    for (int i = 0; i < numToRead; ++i) {
                        target[i] = scalingOffset + scalingFactor * (float)source.get();
                    }
                } else if (data_dtype == 2) {
                    if (firstDataIndex != 0) {
                        int bytesToSkip = 2 * firstDataIndex;
                        source.position(currentPosition + bytesToSkip);
                    }
                    for (int i = 0; i < numToRead; ++i) {
                        target[i] = scalingOffset + scalingFactor * (float)source.getShort();
                    }
                } else if (data_dtype == 3) {
                    if (firstDataIndex != 0) {
                        int bytesToSkip = 4 * firstDataIndex;
                        source.position(currentPosition + bytesToSkip);
                    }
                    for (int i = 0; i < numToRead; ++i) {
                        target[i] = scalingOffset + scalingFactor * (float)source.getInt();
                    }
                } else if (data_dtype == 4) {
                    if (firstDataIndex != 0) {
                        int bytesToSkip = 8 * firstDataIndex;
                        source.position(currentPosition + bytesToSkip);
                    }
                    for (int i = 0; i < numToRead; ++i) {
                        target[i] = scalingOffset + scalingFactor * (float)source.getLong();
                    }
                } else if (data_dtype == 5) {
                    if (firstDataIndex != 0) {
                        int bytesToSkip = 4 * firstDataIndex;
                        source.position(currentPosition + bytesToSkip);
                    }
                    for (int i = 0; i < numToRead; ++i) {
                        target[i] = scalingOffset + scalingFactor * source.getFloat();
                    }
                } else if (data_dtype == 6) {
                    if (firstDataIndex != 0) {
                        int bytesToSkip = 8 * firstDataIndex;
                        source.position(currentPosition + bytesToSkip);
                    }
                    for (int i = 0; i < numToRead; ++i) {
                        target[i] = (float)((double)scalingOffset + (double)scalingFactor * source.getDouble());
                    }
                } else {
                    throw new RuntimeException("unknown data dtype");
                }
                return target;
            }
            if (scaling_dtype == 6) {
                double scalingOffset = BinaryTimeseries.readScalingOffset_double(source);
                double scalingFactor = BinaryTimeseries.readScalingFactor_double(source);
                BinaryTimeseries.readReservedDummy(source);
                byte data_dtype = BinaryTimeseries.readDataType(source);
                int numSamples = BinaryTimeseries.readNumSamples(source);
                int numToRead = lastDataIndex == -1 ? numSamples - firstDataIndex : lastDataIndex - firstDataIndex + 1;
                int currentPosition = source.position();
                float[] target = new float[numToRead];
                if (data_dtype == 1) {
                    if (firstDataIndex != 0) {
                        int bytesToSkip = 1 * firstDataIndex;
                        source.position(currentPosition + bytesToSkip);
                    }
                    for (int i = 0; i < numToRead; ++i) {
                        target[i] = (float)(scalingOffset + scalingFactor * (double)source.get());
                    }
                } else if (data_dtype == 2) {
                    if (firstDataIndex != 0) {
                        int bytesToSkip = 2 * firstDataIndex;
                        source.position(currentPosition + bytesToSkip);
                    }
                    for (int i = 0; i < numToRead; ++i) {
                        target[i] = (float)(scalingOffset + scalingFactor * (double)source.getShort());
                    }
                } else if (data_dtype == 3) {
                    if (firstDataIndex != 0) {
                        int bytesToSkip = 4 * firstDataIndex;
                        source.position(currentPosition + bytesToSkip);
                    }
                    for (int i = 0; i < numToRead; ++i) {
                        target[i] = (float)(scalingOffset + scalingFactor * (double)source.getInt());
                    }
                } else if (data_dtype == 4) {
                    if (firstDataIndex != 0) {
                        int bytesToSkip = 8 * firstDataIndex;
                        source.position(currentPosition + bytesToSkip);
                    }
                    for (int i = 0; i < numToRead; ++i) {
                        target[i] = (float)(scalingOffset + scalingFactor * (double)source.getLong());
                    }
                } else if (data_dtype == 5) {
                    if (firstDataIndex != 0) {
                        int bytesToSkip = 4 * firstDataIndex;
                        source.position(currentPosition + bytesToSkip);
                    }
                    for (int i = 0; i < numToRead; ++i) {
                        target[i] = (float)(scalingOffset + scalingFactor * (double)source.getFloat());
                    }
                } else if (data_dtype == 6) {
                    if (firstDataIndex != 0) {
                        int bytesToSkip = 8 * firstDataIndex;
                        source.position(currentPosition + bytesToSkip);
                    }
                    for (int i = 0; i < numToRead; ++i) {
                        target[i] = (float)(scalingOffset + scalingFactor * source.getDouble());
                    }
                } else {
                    throw new RuntimeException("unknown data dtype");
                }
                return target;
            }
            throw new RuntimeException("unknown scaling dtype");
        }
        BinaryTimeseries.readScalingDisabled(source);
        BinaryTimeseries.readReservedDummy(source);
        byte data_dtype = BinaryTimeseries.readDataType(source);
        int numSamples = BinaryTimeseries.readNumSamples(source);
        int numToRead = lastDataIndex == -1 ? numSamples - firstDataIndex : lastDataIndex - firstDataIndex + 1;
        int currentPosition = source.position();
        float[] target = new float[numToRead];
        if (data_dtype == 1) {
            if (firstDataIndex != 0) {
                int bytesToSkip = 1 * firstDataIndex;
                source.position(currentPosition + bytesToSkip);
            }
            for (int i = 0; i < numToRead; ++i) {
                target[i] = source.get();
            }
        } else if (data_dtype == 2) {
            if (firstDataIndex != 0) {
                int bytesToSkip = 2 * firstDataIndex;
                source.position(currentPosition + bytesToSkip);
            }
            for (int i = 0; i < numToRead; ++i) {
                target[i] = source.getShort();
            }
        } else if (data_dtype == 3) {
            if (firstDataIndex != 0) {
                int bytesToSkip = 4 * firstDataIndex;
                source.position(currentPosition + bytesToSkip);
            }
            for (int i = 0; i < numToRead; ++i) {
                target[i] = source.getInt();
            }
        } else if (data_dtype == 4) {
            if (firstDataIndex != 0) {
                int bytesToSkip = 8 * firstDataIndex;
                source.position(currentPosition + bytesToSkip);
            }
            for (int i = 0; i < numToRead; ++i) {
                target[i] = source.getLong();
            }
        } else if (data_dtype == 5) {
            if (firstDataIndex != 0) {
                int bytesToSkip = 4 * firstDataIndex;
                source.position(currentPosition + bytesToSkip);
            }
            for (int i = 0; i < numToRead; ++i) {
                target[i] = source.getFloat();
            }
        } else if (data_dtype == 6) {
            if (firstDataIndex != 0) {
                int bytesToSkip = 8 * firstDataIndex;
                source.position(currentPosition + bytesToSkip);
            }
            for (int i = 0; i < numToRead; ++i) {
                target[i] = (float)source.getDouble();
            }
        } else {
            throw new RuntimeException("unknown data dtype");
        }
        return target;
    }

    public static final double[] readData_double(ByteBuffer source) {
        boolean firstDataIndex = false;
        int lastDataIndex = -1;
        return BinaryTimeseries.readData_double(source, 0, -1);
    }

    public static final double[] readData_double(ByteBuffer source, int firstDataIndex, int lastDataIndex) {
        byte scaling_dtype = BinaryTimeseries.readScalingType(source);
        if (BinaryTimeseries.hasScaling(scaling_dtype)) {
            if (scaling_dtype == 1) {
                byte scalingOffset = BinaryTimeseries.readScalingOffset_byte(source);
                byte scalingFactor = BinaryTimeseries.readScalingFactor_byte(source);
                BinaryTimeseries.readReservedDummy(source);
                byte data_dtype = BinaryTimeseries.readDataType(source);
                int numSamples = BinaryTimeseries.readNumSamples(source);
                int numToRead = lastDataIndex == -1 ? numSamples - firstDataIndex : lastDataIndex - firstDataIndex + 1;
                int currentPosition = source.position();
                double[] target = new double[numToRead];
                if (data_dtype == 1) {
                    if (firstDataIndex != 0) {
                        int bytesToSkip = 1 * firstDataIndex;
                        source.position(currentPosition + bytesToSkip);
                    }
                    for (int i = 0; i < numToRead; ++i) {
                        target[i] = scalingOffset + scalingFactor * source.get();
                    }
                } else if (data_dtype == 2) {
                    if (firstDataIndex != 0) {
                        int bytesToSkip = 2 * firstDataIndex;
                        source.position(currentPosition + bytesToSkip);
                    }
                    for (int i = 0; i < numToRead; ++i) {
                        target[i] = scalingOffset + scalingFactor * source.getShort();
                    }
                } else if (data_dtype == 3) {
                    if (firstDataIndex != 0) {
                        int bytesToSkip = 4 * firstDataIndex;
                        source.position(currentPosition + bytesToSkip);
                    }
                    for (int i = 0; i < numToRead; ++i) {
                        target[i] = scalingOffset + scalingFactor * source.getInt();
                    }
                } else if (data_dtype == 4) {
                    if (firstDataIndex != 0) {
                        int bytesToSkip = 8 * firstDataIndex;
                        source.position(currentPosition + bytesToSkip);
                    }
                    for (int i = 0; i < numToRead; ++i) {
                        target[i] = (long)scalingOffset + (long)scalingFactor * source.getLong();
                    }
                } else if (data_dtype == 5) {
                    if (firstDataIndex != 0) {
                        int bytesToSkip = 4 * firstDataIndex;
                        source.position(currentPosition + bytesToSkip);
                    }
                    for (int i = 0; i < numToRead; ++i) {
                        target[i] = (float)scalingOffset + (float)scalingFactor * source.getFloat();
                    }
                } else if (data_dtype == 6) {
                    if (firstDataIndex != 0) {
                        int bytesToSkip = 8 * firstDataIndex;
                        source.position(currentPosition + bytesToSkip);
                    }
                    for (int i = 0; i < numToRead; ++i) {
                        target[i] = (double)scalingOffset + (double)scalingFactor * source.getDouble();
                    }
                } else {
                    throw new RuntimeException("unknown data dtype");
                }
                return target;
            }
            if (scaling_dtype == 2) {
                short scalingOffset = BinaryTimeseries.readScalingOffset_short(source);
                short scalingFactor = BinaryTimeseries.readScalingFactor_short(source);
                BinaryTimeseries.readReservedDummy(source);
                byte data_dtype = BinaryTimeseries.readDataType(source);
                int numSamples = BinaryTimeseries.readNumSamples(source);
                int numToRead = lastDataIndex == -1 ? numSamples - firstDataIndex : lastDataIndex - firstDataIndex + 1;
                int currentPosition = source.position();
                double[] target = new double[numToRead];
                if (data_dtype == 1) {
                    if (firstDataIndex != 0) {
                        int bytesToSkip = 1 * firstDataIndex;
                        source.position(currentPosition + bytesToSkip);
                    }
                    for (int i = 0; i < numToRead; ++i) {
                        target[i] = scalingOffset + scalingFactor * source.get();
                    }
                } else if (data_dtype == 2) {
                    if (firstDataIndex != 0) {
                        int bytesToSkip = 2 * firstDataIndex;
                        source.position(currentPosition + bytesToSkip);
                    }
                    for (int i = 0; i < numToRead; ++i) {
                        target[i] = scalingOffset + scalingFactor * source.getShort();
                    }
                } else if (data_dtype == 3) {
                    if (firstDataIndex != 0) {
                        int bytesToSkip = 4 * firstDataIndex;
                        source.position(currentPosition + bytesToSkip);
                    }
                    for (int i = 0; i < numToRead; ++i) {
                        target[i] = scalingOffset + scalingFactor * source.getInt();
                    }
                } else if (data_dtype == 4) {
                    if (firstDataIndex != 0) {
                        int bytesToSkip = 8 * firstDataIndex;
                        source.position(currentPosition + bytesToSkip);
                    }
                    for (int i = 0; i < numToRead; ++i) {
                        target[i] = (long)scalingOffset + (long)scalingFactor * source.getLong();
                    }
                } else if (data_dtype == 5) {
                    if (firstDataIndex != 0) {
                        int bytesToSkip = 4 * firstDataIndex;
                        source.position(currentPosition + bytesToSkip);
                    }
                    for (int i = 0; i < numToRead; ++i) {
                        target[i] = (float)scalingOffset + (float)scalingFactor * source.getFloat();
                    }
                } else if (data_dtype == 6) {
                    if (firstDataIndex != 0) {
                        int bytesToSkip = 8 * firstDataIndex;
                        source.position(currentPosition + bytesToSkip);
                    }
                    for (int i = 0; i < numToRead; ++i) {
                        target[i] = (double)scalingOffset + (double)scalingFactor * source.getDouble();
                    }
                } else {
                    throw new RuntimeException("unknown data dtype");
                }
                return target;
            }
            if (scaling_dtype == 3) {
                int scalingOffset = BinaryTimeseries.readScalingOffset_int(source);
                int scalingFactor = BinaryTimeseries.readScalingFactor_int(source);
                BinaryTimeseries.readReservedDummy(source);
                byte data_dtype = BinaryTimeseries.readDataType(source);
                int numSamples = BinaryTimeseries.readNumSamples(source);
                int numToRead = lastDataIndex == -1 ? numSamples - firstDataIndex : lastDataIndex - firstDataIndex + 1;
                int currentPosition = source.position();
                double[] target = new double[numToRead];
                if (data_dtype == 1) {
                    if (firstDataIndex != 0) {
                        int bytesToSkip = 1 * firstDataIndex;
                        source.position(currentPosition + bytesToSkip);
                    }
                    for (int i = 0; i < numToRead; ++i) {
                        target[i] = scalingOffset + scalingFactor * source.get();
                    }
                } else if (data_dtype == 2) {
                    if (firstDataIndex != 0) {
                        int bytesToSkip = 2 * firstDataIndex;
                        source.position(currentPosition + bytesToSkip);
                    }
                    for (int i = 0; i < numToRead; ++i) {
                        target[i] = scalingOffset + scalingFactor * source.getShort();
                    }
                } else if (data_dtype == 3) {
                    if (firstDataIndex != 0) {
                        int bytesToSkip = 4 * firstDataIndex;
                        source.position(currentPosition + bytesToSkip);
                    }
                    for (int i = 0; i < numToRead; ++i) {
                        target[i] = scalingOffset + scalingFactor * source.getInt();
                    }
                } else if (data_dtype == 4) {
                    if (firstDataIndex != 0) {
                        int bytesToSkip = 8 * firstDataIndex;
                        source.position(currentPosition + bytesToSkip);
                    }
                    for (int i = 0; i < numToRead; ++i) {
                        target[i] = (long)scalingOffset + (long)scalingFactor * source.getLong();
                    }
                } else if (data_dtype == 5) {
                    if (firstDataIndex != 0) {
                        int bytesToSkip = 4 * firstDataIndex;
                        source.position(currentPosition + bytesToSkip);
                    }
                    for (int i = 0; i < numToRead; ++i) {
                        target[i] = (float)scalingOffset + (float)scalingFactor * source.getFloat();
                    }
                } else if (data_dtype == 6) {
                    if (firstDataIndex != 0) {
                        int bytesToSkip = 8 * firstDataIndex;
                        source.position(currentPosition + bytesToSkip);
                    }
                    for (int i = 0; i < numToRead; ++i) {
                        target[i] = (double)scalingOffset + (double)scalingFactor * source.getDouble();
                    }
                } else {
                    throw new RuntimeException("unknown data dtype");
                }
                return target;
            }
            if (scaling_dtype == 4) {
                long scalingOffset = BinaryTimeseries.readScalingOffset_long(source);
                long scalingFactor = BinaryTimeseries.readScalingFactor_long(source);
                BinaryTimeseries.readReservedDummy(source);
                byte data_dtype = BinaryTimeseries.readDataType(source);
                int numSamples = BinaryTimeseries.readNumSamples(source);
                int numToRead = lastDataIndex == -1 ? numSamples - firstDataIndex : lastDataIndex - firstDataIndex + 1;
                int currentPosition = source.position();
                double[] target = new double[numToRead];
                if (data_dtype == 1) {
                    if (firstDataIndex != 0) {
                        int bytesToSkip = 1 * firstDataIndex;
                        source.position(currentPosition + bytesToSkip);
                    }
                    for (int i = 0; i < numToRead; ++i) {
                        target[i] = scalingOffset + scalingFactor * (long)source.get();
                    }
                } else if (data_dtype == 2) {
                    if (firstDataIndex != 0) {
                        int bytesToSkip = 2 * firstDataIndex;
                        source.position(currentPosition + bytesToSkip);
                    }
                    for (int i = 0; i < numToRead; ++i) {
                        target[i] = scalingOffset + scalingFactor * (long)source.getShort();
                    }
                } else if (data_dtype == 3) {
                    if (firstDataIndex != 0) {
                        int bytesToSkip = 4 * firstDataIndex;
                        source.position(currentPosition + bytesToSkip);
                    }
                    for (int i = 0; i < numToRead; ++i) {
                        target[i] = scalingOffset + scalingFactor * (long)source.getInt();
                    }
                } else if (data_dtype == 4) {
                    if (firstDataIndex != 0) {
                        int bytesToSkip = 8 * firstDataIndex;
                        source.position(currentPosition + bytesToSkip);
                    }
                    for (int i = 0; i < numToRead; ++i) {
                        target[i] = scalingOffset + scalingFactor * source.getLong();
                    }
                } else if (data_dtype == 5) {
                    if (firstDataIndex != 0) {
                        int bytesToSkip = 4 * firstDataIndex;
                        source.position(currentPosition + bytesToSkip);
                    }
                    for (int i = 0; i < numToRead; ++i) {
                        target[i] = (float)scalingOffset + (float)scalingFactor * source.getFloat();
                    }
                } else if (data_dtype == 6) {
                    if (firstDataIndex != 0) {
                        int bytesToSkip = 8 * firstDataIndex;
                        source.position(currentPosition + bytesToSkip);
                    }
                    for (int i = 0; i < numToRead; ++i) {
                        target[i] = (double)scalingOffset + (double)scalingFactor * source.getDouble();
                    }
                } else {
                    throw new RuntimeException("unknown data dtype");
                }
                return target;
            }
            if (scaling_dtype == 5) {
                float scalingOffset = BinaryTimeseries.readScalingOffset_float(source);
                float scalingFactor = BinaryTimeseries.readScalingFactor_float(source);
                BinaryTimeseries.readReservedDummy(source);
                byte data_dtype = BinaryTimeseries.readDataType(source);
                int numSamples = BinaryTimeseries.readNumSamples(source);
                int numToRead = lastDataIndex == -1 ? numSamples - firstDataIndex : lastDataIndex - firstDataIndex + 1;
                int currentPosition = source.position();
                double[] target = new double[numToRead];
                if (data_dtype == 1) {
                    if (firstDataIndex != 0) {
                        int bytesToSkip = 1 * firstDataIndex;
                        source.position(currentPosition + bytesToSkip);
                    }
                    for (int i = 0; i < numToRead; ++i) {
                        target[i] = scalingOffset + scalingFactor * (float)source.get();
                    }
                } else if (data_dtype == 2) {
                    if (firstDataIndex != 0) {
                        int bytesToSkip = 2 * firstDataIndex;
                        source.position(currentPosition + bytesToSkip);
                    }
                    for (int i = 0; i < numToRead; ++i) {
                        target[i] = scalingOffset + scalingFactor * (float)source.getShort();
                    }
                } else if (data_dtype == 3) {
                    if (firstDataIndex != 0) {
                        int bytesToSkip = 4 * firstDataIndex;
                        source.position(currentPosition + bytesToSkip);
                    }
                    for (int i = 0; i < numToRead; ++i) {
                        target[i] = scalingOffset + scalingFactor * (float)source.getInt();
                    }
                } else if (data_dtype == 4) {
                    if (firstDataIndex != 0) {
                        int bytesToSkip = 8 * firstDataIndex;
                        source.position(currentPosition + bytesToSkip);
                    }
                    for (int i = 0; i < numToRead; ++i) {
                        target[i] = scalingOffset + scalingFactor * (float)source.getLong();
                    }
                } else if (data_dtype == 5) {
                    if (firstDataIndex != 0) {
                        int bytesToSkip = 4 * firstDataIndex;
                        source.position(currentPosition + bytesToSkip);
                    }
                    for (int i = 0; i < numToRead; ++i) {
                        target[i] = scalingOffset + scalingFactor * source.getFloat();
                    }
                } else if (data_dtype == 6) {
                    if (firstDataIndex != 0) {
                        int bytesToSkip = 8 * firstDataIndex;
                        source.position(currentPosition + bytesToSkip);
                    }
                    for (int i = 0; i < numToRead; ++i) {
                        target[i] = (double)scalingOffset + (double)scalingFactor * source.getDouble();
                    }
                } else {
                    throw new RuntimeException("unknown data dtype");
                }
                return target;
            }
            if (scaling_dtype == 6) {
                double scalingOffset = BinaryTimeseries.readScalingOffset_double(source);
                double scalingFactor = BinaryTimeseries.readScalingFactor_double(source);
                BinaryTimeseries.readReservedDummy(source);
                byte data_dtype = BinaryTimeseries.readDataType(source);
                int numSamples = BinaryTimeseries.readNumSamples(source);
                int numToRead = lastDataIndex == -1 ? numSamples - firstDataIndex : lastDataIndex - firstDataIndex + 1;
                int currentPosition = source.position();
                double[] target = new double[numToRead];
                if (data_dtype == 1) {
                    if (firstDataIndex != 0) {
                        int bytesToSkip = 1 * firstDataIndex;
                        source.position(currentPosition + bytesToSkip);
                    }
                    for (int i = 0; i < numSamples; ++i) {
                        target[i] = scalingOffset + scalingFactor * (double)source.get();
                    }
                } else if (data_dtype == 2) {
                    if (firstDataIndex != 0) {
                        int bytesToSkip = 2 * firstDataIndex;
                        source.position(currentPosition + bytesToSkip);
                    }
                    for (int i = 0; i < numToRead; ++i) {
                        target[i] = scalingOffset + scalingFactor * (double)source.getShort();
                    }
                } else if (data_dtype == 3) {
                    if (firstDataIndex != 0) {
                        int bytesToSkip = 4 * firstDataIndex;
                        source.position(currentPosition + bytesToSkip);
                    }
                    for (int i = 0; i < numToRead; ++i) {
                        target[i] = scalingOffset + scalingFactor * (double)source.getInt();
                    }
                } else if (data_dtype == 4) {
                    if (firstDataIndex != 0) {
                        int bytesToSkip = 8 * firstDataIndex;
                        source.position(currentPosition + bytesToSkip);
                    }
                    for (int i = 0; i < numToRead; ++i) {
                        target[i] = scalingOffset + scalingFactor * (double)source.getLong();
                    }
                } else if (data_dtype == 5) {
                    if (firstDataIndex != 0) {
                        int bytesToSkip = 4 * firstDataIndex;
                        source.position(currentPosition + bytesToSkip);
                    }
                    for (int i = 0; i < numToRead; ++i) {
                        target[i] = scalingOffset + scalingFactor * (double)source.getFloat();
                    }
                } else if (data_dtype == 6) {
                    if (firstDataIndex != 0) {
                        int bytesToSkip = 8 * firstDataIndex;
                        source.position(currentPosition + bytesToSkip);
                    }
                    for (int i = 0; i < numToRead; ++i) {
                        target[i] = scalingOffset + scalingFactor * source.getDouble();
                    }
                } else {
                    throw new RuntimeException("unknown data dtype");
                }
                return target;
            }
            throw new RuntimeException("unknown scaling dtype");
        }
        BinaryTimeseries.readScalingDisabled(source);
        BinaryTimeseries.readReservedDummy(source);
        byte data_dtype = BinaryTimeseries.readDataType(source);
        int numSamples = BinaryTimeseries.readNumSamples(source);
        int numToRead = lastDataIndex == -1 ? numSamples - firstDataIndex : lastDataIndex - firstDataIndex + 1;
        int currentPosition = source.position();
        double[] target = new double[numToRead];
        if (data_dtype == 1) {
            if (firstDataIndex != 0) {
                int bytesToSkip = 1 * firstDataIndex;
                source.position(currentPosition + bytesToSkip);
            }
            for (int i = 0; i < numToRead; ++i) {
                target[i] = source.get();
            }
        } else if (data_dtype == 2) {
            if (firstDataIndex != 0) {
                int bytesToSkip = 2 * firstDataIndex;
                source.position(currentPosition + bytesToSkip);
            }
            for (int i = 0; i < numToRead; ++i) {
                target[i] = source.getShort();
            }
        } else if (data_dtype == 3) {
            if (firstDataIndex != 0) {
                int bytesToSkip = 4 * firstDataIndex;
                source.position(currentPosition + bytesToSkip);
            }
            for (int i = 0; i < numToRead; ++i) {
                target[i] = source.getInt();
            }
        } else if (data_dtype == 4) {
            if (firstDataIndex != 0) {
                int bytesToSkip = 8 * firstDataIndex;
                source.position(currentPosition + bytesToSkip);
            }
            for (int i = 0; i < numToRead; ++i) {
                target[i] = source.getLong();
            }
        } else if (data_dtype == 5) {
            if (firstDataIndex != 0) {
                int bytesToSkip = 4 * firstDataIndex;
                source.position(currentPosition + bytesToSkip);
            }
            for (int i = 0; i < numToRead; ++i) {
                target[i] = source.getFloat();
            }
        } else if (data_dtype == 6) {
            if (firstDataIndex != 0) {
                int bytesToSkip = 8 * firstDataIndex;
                source.position(currentPosition + bytesToSkip);
            }
            for (int i = 0; i < numToRead; ++i) {
                target[i] = source.getDouble();
            }
        } else {
            throw new RuntimeException("unknown data dtype");
        }
        return target;
    }
}

