/*
 * Decompiled with CFR 0.152.
 */
package examples;

import de.labathome.BinaryTimeseries;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteOrder;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Locale;

public class Examples {
    public static void main(String[] args) {
        Examples.Example1();
        Examples.Example2();
    }

    public static void Example1() {
        double t0 = 0.0;
        double dt = 0.001;
        double f_Signal = 10.0;
        double phi_Signal = 0.5759586531581288;
        double U_Signal = 0.77;
        int nSamples = 1000;
        double[] signal = new double[nSamples];
        for (int i = 0; i < nSamples; ++i) {
            double U;
            double t = t0 + (double)i * dt;
            signal[i] = U = U_Signal * Math.sin(Math.PI * 2 * f_Signal * t + phi_Signal);
        }
        Path outputFile = Paths.get(System.getProperty("java.io.tmpdir") + File.separator + "example1.bts", new String[0]);
        System.out.println("using '" + outputFile + "' for example 1 of BinaryTimeseries");
        int filesize = BinaryTimeseries.fileOffset(8, nSamples);
        System.out.println("size of output file for example 1 is " + filesize / 1024 + " kB");
        try (RandomAccessFile memoryFile = new RandomAccessFile(outputFile.toFile(), "rw");){
            MappedByteBuffer mappedByteBuffer = memoryFile.getChannel().map(FileChannel.MapMode.READ_WRITE, 0L, filesize);
            long wrintingStart = -System.nanoTime();
            BinaryTimeseries.write(mappedByteBuffer, t0, dt, signal);
            System.out.println("writing took " + (int)Math.round((double)(wrintingStart + System.nanoTime()) / 1000.0) + " us");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        byte dtype_time_readback = 0;
        double t0_readback = Double.NaN;
        double dt_readback = Double.NaN;
        double[] signal_readback = null;
        try (RandomAccessFile memoryFile = new RandomAccessFile(outputFile.toFile(), "r");){
            MappedByteBuffer mappedByteBuffer = memoryFile.getChannel().map(FileChannel.MapMode.READ_ONLY, 0L, memoryFile.length());
            mappedByteBuffer.order(mappedByteBuffer.order() == ByteOrder.BIG_ENDIAN ? ByteOrder.LITTLE_ENDIAN : ByteOrder.BIG_ENDIAN);
            long readingStart = -System.nanoTime();
            if (!BinaryTimeseries.readEndianessOk(mappedByteBuffer)) {
                mappedByteBuffer.order(mappedByteBuffer.order() == ByteOrder.BIG_ENDIAN ? ByteOrder.LITTLE_ENDIAN : ByteOrder.BIG_ENDIAN);
                System.out.println("swapped endianess of read buffer");
            }
            if ((dtype_time_readback = BinaryTimeseries.readTimeType(mappedByteBuffer)) == 6) {
                t0_readback = BinaryTimeseries.readTimeT0_double(mappedByteBuffer);
                dt_readback = BinaryTimeseries.readTimeDt_double(mappedByteBuffer);
            }
            signal_readback = BinaryTimeseries.readData_double(mappedByteBuffer);
            System.out.println("reading took " + (int)Math.round((double)(readingStart + System.nanoTime()) / 1000.0) + " us");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (Files.exists(outputFile, new LinkOption[0])) {
            try {
                Files.delete(outputFile);
                System.out.println("deleted temporary file for example 1: '" + outputFile + "'");
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else {
            throw new RuntimeException("output file for example 1 was not created");
        }
        if (dtype_time_readback != 6) {
            throw new RuntimeException("readback data type of time is not DTYPE_DOUBLE but '" + BinaryTimeseries.dtypeStr(dtype_time_readback) + "'");
        }
        if (t0 != t0_readback) {
            throw new RuntimeException("readback t0 is not original t0");
        }
        if (dt != dt_readback) {
            throw new RuntimeException("readback dt is not original dt");
        }
        if (signal_readback == null) {
            throw new RuntimeException("readback signal is null");
        }
        if (nSamples != signal_readback.length) {
            throw new RuntimeException("readback signal does not have length nSamples (=" + nSamples + ") but " + signal_readback.length);
        }
        for (int i = 0; i < nSamples; ++i) {
            double t = t0 + (double)i * dt;
            System.out.println(String.format(Locale.ENGLISH, "%.6e\t%.6e\t%.6e", t, signal[i], signal_readback[i]));
            if (signal[i] == signal_readback[i]) continue;
            throw new RuntimeException("readback signal mismatch at t=" + t + " signal(t)=" + signal[i] + " signal_readback(t)=" + signal_readback[i]);
        }
    }

    public static void Example2() {
        double t0 = 0.0;
        double dt = 0.001;
        double f_Signal = 10.0;
        double phi_Signal = 0.5759586531581288;
        double U_Signal = 0.77;
        double maxInput = 1.0;
        double minInput = -1.0;
        double U_LSB = (maxInput - minInput) / 65535.0;
        int nSamples = 1000;
        short[] signal = new short[nSamples];
        for (int i = 0; i < nSamples; ++i) {
            short adcValue;
            double t = t0 + (double)i * dt;
            double U = U_Signal * Math.sin(Math.PI * 2 * f_Signal * t + phi_Signal);
            signal[i] = adcValue = (short)(32768L + Math.round((U - minInput) / U_LSB));
        }
        Path outputFile = Paths.get(System.getProperty("java.io.tmpdir") + File.separator + "example2.bts", new String[0]);
        System.out.println("using '" + outputFile + "' for example 2 of BinaryTimeseries");
        int filesize = BinaryTimeseries.fileOffset(2, nSamples);
        System.out.println("size of output file for example 2 is " + filesize / 1024 + " kB");
        try (RandomAccessFile memoryFile = new RandomAccessFile(outputFile.toFile(), "rw");){
            MappedByteBuffer mappedByteBuffer = memoryFile.getChannel().map(FileChannel.MapMode.READ_WRITE, 0L, filesize);
            long wrintingStart = -System.nanoTime();
            BinaryTimeseries.write(mappedByteBuffer, t0, dt, signal, 0.0, U_LSB);
            System.out.println("writing took " + (int)Math.round((double)(wrintingStart + System.nanoTime()) / 1000.0) + " us");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        byte dtype_time_readback = 0;
        double t0_readback = Double.NaN;
        double dt_readback = Double.NaN;
        double[] signal_readback = null;
        try (RandomAccessFile memoryFile = new RandomAccessFile(outputFile.toFile(), "r");){
            MappedByteBuffer mappedByteBuffer = memoryFile.getChannel().map(FileChannel.MapMode.READ_ONLY, 0L, memoryFile.length());
            long readingStart = -System.nanoTime();
            if (!BinaryTimeseries.readEndianessOk(mappedByteBuffer)) {
                mappedByteBuffer.order(mappedByteBuffer.order() == ByteOrder.BIG_ENDIAN ? ByteOrder.LITTLE_ENDIAN : ByteOrder.BIG_ENDIAN);
            }
            if ((dtype_time_readback = BinaryTimeseries.readTimeType(mappedByteBuffer)) == 6) {
                t0_readback = BinaryTimeseries.readTimeT0_double(mappedByteBuffer);
                dt_readback = BinaryTimeseries.readTimeDt_double(mappedByteBuffer);
            }
            signal_readback = BinaryTimeseries.readData_double(mappedByteBuffer);
            System.out.println("reading took " + (int)Math.round((double)(readingStart + System.nanoTime()) / 1000.0) + " us");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (Files.exists(outputFile, new LinkOption[0])) {
            try {
                Files.delete(outputFile);
                System.out.println("deleted temporary file for example 1: '" + outputFile + "'");
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else {
            throw new RuntimeException("output file for example 1 was not created");
        }
        if (dtype_time_readback != 6) {
            throw new RuntimeException("readback data type of time is not DTYPE_DOUBLE but '" + BinaryTimeseries.dtypeStr(dtype_time_readback) + "'");
        }
        if (t0 != t0_readback) {
            throw new RuntimeException("readback t0 is not original t0");
        }
        if (dt != dt_readback) {
            throw new RuntimeException("readback dt is not original dt");
        }
        if (signal_readback == null) {
            throw new RuntimeException("readback signal is null");
        }
        if (nSamples != signal_readback.length) {
            throw new RuntimeException("readback signal does not have length nSamples (=" + nSamples + ") but " + signal_readback.length);
        }
        for (int i = 0; i < nSamples; ++i) {
            double t = t0 + (double)i * dt;
            System.out.println(String.format(Locale.ENGLISH, "%.6e\t%.6e\t%.6e", t, (double)signal[i] * U_LSB, signal_readback[i]));
            if ((double)signal[i] * U_LSB == signal_readback[i]) continue;
            throw new RuntimeException("readback signal mismatch at t=" + t + " signal(t)=" + (double)signal[i] * U_LSB + " signal_readback(t)=" + signal_readback[i]);
        }
    }
}

