/*
 * Decompiled with CFR 0.152.
 */
package de.labathome.gears;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import org.apache.commons.math3.fraction.Fraction;

public class GearsInput {
    Fraction[] transmissionRatios;
    int maxToothSum = 200;
    int minToothSum = 2;
    boolean outputTeethCounts = false;

    public GearsInput(Fraction[] transmissionRatios) {
        this.transmissionRatios = transmissionRatios;
    }

    public void setMaxToothSum(int maxToothSum) {
        this.maxToothSum = maxToothSum;
    }

    public void setMinToothSum(int minToothSum) {
        this.minToothSum = minToothSum;
    }

    public void setOutputTeethCounts(boolean outputTeethCounts) {
        this.outputTeethCounts = outputTeethCounts;
    }

    public static GearsInput fromJson(JsonObject json) {
        JsonElement outputTeethCountsElement;
        JsonElement minToothSumElement;
        JsonArray trArr = json.getAsJsonArray("transmissionRatios");
        int numRatios = trArr.size();
        if (numRatios < 1) {
            throw new RuntimeException(String.format("Must specify at least one ratio, but got %d ratios.", numRatios));
        }
        Fraction[] transmissionRatios = new Fraction[numRatios];
        for (int idxRatio = 0; idxRatio < numRatios; ++idxRatio) {
            JsonArray ratioArr = trArr.get(idxRatio).getAsJsonArray();
            if (ratioArr.size() != 2) {
                throw new RuntimeException(String.format("Each ratio must consist of two elements (numerator and denominator), but got %d elements.", ratioArr.size()));
            }
            int numerator = ratioArr.get(0).getAsInt();
            int denominator = ratioArr.get(1).getAsInt();
            transmissionRatios[idxRatio] = new Fraction(numerator, denominator);
        }
        GearsInput input = new GearsInput(transmissionRatios);
        JsonElement maxToothSumElement = json.get("maxToothSum");
        if (maxToothSumElement != null) {
            input.setMaxToothSum(maxToothSumElement.getAsInt());
        }
        if ((minToothSumElement = json.get("minToothSum")) != null) {
            input.setMinToothSum(minToothSumElement.getAsInt());
        }
        if ((outputTeethCountsElement = json.get("outputTeethCounts")) != null) {
            input.setOutputTeethCounts(outputTeethCountsElement.getAsBoolean());
        }
        return input;
    }
}

