// Generated by delombok at Mon Feb 24 18:39:29 UTC 2025
package de.larssh.utils;

/**
 * Implementation of a boolean {@code completed} status, allowing objects to
 * differentiate between an initialization phase and their final value. This
 * implementation is synchronized.
 *
 * <p>
 * Each getter is recommended to call {@code #complete()}, while
 * {@code #throwIfCompleted()} must be called prior to object modification.
 *
 * <p>
 * Before using {@code Completable} think about using either a non-modifiable
 * constructor or a builder class.
 */
@SuppressWarnings("PMD.AbstractClassWithoutAbstractMethod")
public abstract class Completable {
	/**
	 * Completed status
	 */
	private volatile boolean completed = false;

	/**
	 * Finishes the objects initialization phase.
	 *
	 * <p>
	 * This method is recommended to be called by each getter.
	 */
	protected void complete() {
		completed = true;
	}

	/**
	 * In case the object has already been completed a {@link CompletedException} is
	 * thrown. Else nothing happens.
	 *
	 * <p>
	 * This method must be called by prior to object modification.
	 *
	 * @throws CompletedException if object is completed
	 */
	protected void throwIfCompleted() {
		if (completed) {
			throw new CompletedException();
		}
	}

	/**
	 * Completed status
	 *
	 * @return completed status
	 */
	@java.lang.SuppressWarnings("all")
	@edu.umd.cs.findbugs.annotations.SuppressFBWarnings(justification = "generated code")
	@lombok.Generated
	public boolean isCompleted() {
		return this.completed;
	}

	@java.lang.SuppressWarnings("all")
	@edu.umd.cs.findbugs.annotations.SuppressFBWarnings(justification = "generated code")
	@lombok.Generated
	public Completable() {
	}
}
