// Generated by delombok at Mon Feb 24 18:39:29 UTC 2025
package de.larssh.utils.collection;

import java.util.Iterator;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.Nullable;

/**
 * An abstract {@link Iterator} implementation pointing to a given iterator.
 *
 * @param <E> the type of elements in this iterator
 */
public abstract class ProxiedIterator<E> implements Iterator<E> {
	/**
	 * Wrapped iterator
	 */
	private final Iterator<E> iterator;
	/**
	 * Flag specifying if the underlying collection can be modified
	 */
	private boolean modifiable = true;

	/**
	 * {@inheritDoc}
	 */
	@Override
	public boolean equals(@CheckForNull final Object object) {
		return getProxiedForRead().equals(object);
	}

	/**
	 * Verifies if the underlying collection is modifiable and either returns the
	 * wrapped iterator or throws an appropriate exception.
	 *
	 * @return the wrapped iterator if the underlying collection is modifiable
	 * @throws UnsupportedOperationException if the underlying collection is
	 *                                       unmodifiable
	 */
	protected Iterator<E> getProxiedIfModifiable() {
		if (isModifiable()) {
			return iterator;
		}
		throw new UnsupportedOperationException();
	}

	/**
	 * Returns the wrapped iterator without verifying if modifying the underlying
	 * collection is prohibited.
	 *
	 * @return the wrapped iterator
	 */
	protected Iterator<E> getProxiedForRead() {
		return iterator;
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public int hashCode() {
		return getProxiedForRead().hashCode();
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public boolean hasNext() {
		return getProxiedForRead().hasNext();
	}

	/**
	 * {@inheritDoc}
	 */
	@Nullable
	@Override
	public E next() {
		return getProxiedForRead().next();
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public void remove() {
		getProxiedIfModifiable().remove();
	}

	/**
	 * Creates a new {@code ProxiedIterator} instance.
	 *
	 * @param iterator Wrapped iterator
	 */
	@java.lang.SuppressWarnings("all")
	@edu.umd.cs.findbugs.annotations.SuppressFBWarnings(justification = "generated code")
	@lombok.Generated
	public ProxiedIterator(final Iterator<E> iterator) {
		this.iterator = iterator;
	}

	/**
	 * Flag specifying if the underlying collection can be modified
	 *
	 * @return {@code true} if the underlying collection is modifiable, else
	 *         {@code false}
	 */
	@java.lang.SuppressWarnings("all")
	@edu.umd.cs.findbugs.annotations.SuppressFBWarnings(justification = "generated code")
	@lombok.Generated
	public boolean isModifiable() {
		return this.modifiable;
	}

	/**
	 * Flag specifying if the underlying collection can be modified
	 *
	 * @param modifiable flag
	 */
	@java.lang.SuppressWarnings("all")
	@edu.umd.cs.findbugs.annotations.SuppressFBWarnings(justification = "generated code")
	@lombok.Generated
	protected void setModifiable(final boolean modifiable) {
		this.modifiable = modifiable;
	}
}
