// Generated by delombok at Mon Feb 24 18:39:29 UTC 2025
package de.larssh.utils.xml;

import javax.xml.transform.TransformerFactory;

/**
 * Allows reading and writing attributes of {@link TransformerFactory} in a
 * typed way.
 *
 * @param <T> the attribute type
 */
public class TransformerFactoryAttribute<T> {
	/**
	 * Attribute Name
	 */
	private final String name;

	/**
	 * Allows the user to retrieve specific attributes of the underlying
	 * implementation.
	 *
	 * <p>
	 * An {@code IllegalArgumentException} is thrown if the underlying
	 * implementation doesn't recognize the attribute.
	 *
	 * @param transformerFactory the transformer factory
	 * @return value the value of the attribute
	 * @throws IllegalArgumentException if implementation does not recognize the
	 *                                  attribute
	 */
	@SuppressWarnings("unchecked")
	public T get(final TransformerFactory transformerFactory) {
		return (T) transformerFactory.getAttribute(getName());
	}

	/**
	 * Allows the user to set specific attributes on the underlying implementation.
	 * An attribute in this context is defined to be an option that the
	 * implementation provides.
	 *
	 * <p>
	 * An {@code IllegalArgumentException} is thrown if the underlying
	 * implementation doesn't recognize the attribute.
	 *
	 * @param transformerFactory the transformer factory
	 * @param value              the value of the attribute
	 * @throws IllegalArgumentException if implementation does not recognize the
	 *                                  attribute
	 */
	public void set(final TransformerFactory transformerFactory, final T value) {
		transformerFactory.setAttribute(getName(), value);
	}

	/**
	 * Attribute Name
	 *
	 * @return the attribute name
	 */
	@java.lang.SuppressWarnings("all")
	@edu.umd.cs.findbugs.annotations.SuppressFBWarnings(justification = "generated code")
	@lombok.Generated
	public String getName() {
		return this.name;
	}

	/**
	 * Creates a new {@code TransformerFactoryAttribute} instance.
	 *
	 * @param name Attribute Name
	 */
	@java.lang.SuppressWarnings("all")
	@edu.umd.cs.findbugs.annotations.SuppressFBWarnings(justification = "generated code")
	@lombok.Generated
	public TransformerFactoryAttribute(final String name) {
		this.name = name;
	}
}
