/*
 * Decompiled with CFR 0.152.
 */
package de.larssh.utils;

import de.larssh.utils.text.Strings;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collector;
import lombok.Generated;

public final class Collectors {
    public static <T> BinaryOperator<T> throwingMerger() {
        return (u, v) -> {
            throw new IllegalStateException(Strings.format("Duplicate key %s", u));
        };
    }

    public static <K, V> Collector<Map.Entry<K, V>, ?, Map<K, V>> toLinkedHashMap() {
        return Collectors.toLinkedHashMap(Map.Entry::getKey, Map.Entry::getValue, Collectors.throwingMerger());
    }

    public static <T, K, U> Collector<T, ?, Map<K, U>> toLinkedHashMap(Function<? super T, ? extends K> keyMapper, Function<? super T, ? extends U> valueMapper) {
        return Collectors.toLinkedHashMap(keyMapper, valueMapper, Collectors.throwingMerger());
    }

    public static <T, K, U> Collector<T, ?, Map<K, U>> toLinkedHashMap(Function<? super T, ? extends K> keyMapper, Function<? super T, ? extends U> valueMapper, BinaryOperator<U> mergeFunction) {
        return Collectors.toMap(keyMapper, valueMapper, mergeFunction, LinkedHashMap::new);
    }

    public static <T> Collector<T, ?, Set<T>> toLinkedHashSet() {
        return java.util.stream.Collectors.toCollection(LinkedHashSet::new);
    }

    public static <K, V, M extends Map<K, V>> Collector<Map.Entry<K, V>, ?, M> toMap(Supplier<M> mapSupplier) {
        return Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, Collectors.throwingMerger(), mapSupplier);
    }

    public static <T, K, U> Collector<T, ?, Map<K, U>> toMap(Function<? super T, ? extends K> keyMapper, Function<? super T, ? extends U> valueMapper) {
        return Collectors.toMap(keyMapper, valueMapper, Collectors.throwingMerger());
    }

    public static <T, K, U> Collector<T, ?, Map<K, U>> toMap(Function<? super T, ? extends K> keyMapper, Function<? super T, ? extends U> valueMapper, BinaryOperator<U> mergeFunction) {
        return Collectors.toMap(keyMapper, valueMapper, mergeFunction, HashMap::new);
    }

    public static <T, K, U, M extends Map<K, U>> Collector<T, ?, M> toMap(Function<? super T, ? extends K> keyMapper, Function<? super T, ? extends U> valueMapper, Supplier<M> mapSupplier) {
        return Collectors.toMap(keyMapper, valueMapper, Collectors.throwingMerger(), mapSupplier);
    }

    public static <T, K, U, M extends Map<K, U>> Collector<T, ?, M> toMap(Function<? super T, ? extends K> keyMapper, Function<? super T, ? extends U> valueMapper, BinaryOperator<U> mergeFunction, Supplier<M> mapSupplier) {
        return java.util.stream.Collectors.toMap(keyMapper, valueMapper, mergeFunction, mapSupplier);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    private Collectors() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

