/*
 * Decompiled with CFR 0.152.
 */
package de.larssh.utils;

import de.larssh.utils.function.IntToIntFunction;
import edu.umd.cs.findbugs.annotations.Nullable;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Arrays;
import java.util.Optional;
import java.util.OptionalDouble;
import java.util.OptionalInt;
import java.util.OptionalLong;
import java.util.function.IntFunction;
import java.util.function.IntPredicate;
import java.util.function.IntToDoubleFunction;
import java.util.function.IntToLongFunction;
import java.util.stream.IntStream;
import lombok.Generated;

public final class OptionalInts {
    public static final IntPredicate IS_NEGATIVE = value -> value < 0;
    public static final IntPredicate IS_NEGATIVE_OR_ZERO = value -> value <= 0;
    public static final IntPredicate IS_POSITIVE = value -> value > 0;
    public static final IntPredicate IS_POSITIVE_OR_ZERO = value -> value >= 0;

    public static Optional<Integer> boxed(OptionalInt optional) {
        return optional.isPresent() ? Optional.ofNullable(optional.getAsInt()) : Optional.empty();
    }

    public static OptionalInt filter(OptionalInt optional, IntPredicate predicate) {
        return optional.isPresent() && predicate.test(optional.getAsInt()) ? optional : OptionalInt.empty();
    }

    public static OptionalInt flatMap(OptionalInt optional, IntFunction<OptionalInt> mapper) {
        return optional.isPresent() ? mapper.apply(optional.getAsInt()) : OptionalInt.empty();
    }

    public static OptionalDouble flatMapToDouble(OptionalInt optional, IntFunction<OptionalDouble> mapper) {
        return optional.isPresent() ? mapper.apply(optional.getAsInt()) : OptionalDouble.empty();
    }

    public static OptionalLong flatMapToLong(OptionalInt optional, IntFunction<OptionalLong> mapper) {
        return optional.isPresent() ? mapper.apply(optional.getAsInt()) : OptionalLong.empty();
    }

    public static <T> Optional<T> flatMapToObj(OptionalInt optional, IntFunction<Optional<T>> mapper) {
        return optional.isPresent() ? mapper.apply(optional.getAsInt()) : Optional.empty();
    }

    public static OptionalInt map(OptionalInt optional, IntToIntFunction mapper) {
        return optional.isPresent() ? OptionalInt.of(mapper.applyAsInt(optional.getAsInt())) : OptionalInt.empty();
    }

    public static OptionalDouble mapToDouble(OptionalInt optional, IntToDoubleFunction mapper) {
        return optional.isPresent() ? OptionalDouble.of(mapper.applyAsDouble(optional.getAsInt())) : OptionalDouble.empty();
    }

    public static OptionalLong mapToLong(OptionalInt optional, IntToLongFunction mapper) {
        return optional.isPresent() ? OptionalLong.of(mapper.applyAsLong(optional.getAsInt())) : OptionalLong.empty();
    }

    public static <T> Optional<T> mapToObj(OptionalInt optional, IntFunction<T> mapper) {
        return optional.isPresent() ? Optional.ofNullable(mapper.apply(optional.getAsInt())) : Optional.empty();
    }

    public static OptionalInt ofNon(IntPredicate isEmpty, int value) {
        return isEmpty.test(value) ? OptionalInt.empty() : OptionalInt.of(value);
    }

    public static OptionalInt ofNullable(@Nullable Integer value) {
        return value == null ? OptionalInt.empty() : OptionalInt.of(value);
    }

    @SafeVarargs
    public static IntStream stream(OptionalInt ... optionals) {
        return Arrays.stream(optionals).filter(OptionalInt::isPresent).mapToInt(OptionalInt::getAsInt);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    private OptionalInts() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

