/*
 * Decompiled with CFR 0.152.
 */
package de.larssh.utils;

import de.larssh.utils.function.LongToLongFunction;
import edu.umd.cs.findbugs.annotations.Nullable;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Arrays;
import java.util.Optional;
import java.util.OptionalDouble;
import java.util.OptionalInt;
import java.util.OptionalLong;
import java.util.function.LongFunction;
import java.util.function.LongPredicate;
import java.util.function.LongToDoubleFunction;
import java.util.function.LongToIntFunction;
import java.util.stream.LongStream;
import lombok.Generated;

public final class OptionalLongs {
    public static final LongPredicate IS_NEGATIVE = value -> value < 0L;
    public static final LongPredicate IS_NEGATIVE_OR_ZERO = value -> value <= 0L;
    public static final LongPredicate IS_POSITIVE = value -> value > 0L;
    public static final LongPredicate IS_POSITIVE_OR_ZERO = value -> value >= 0L;

    public static Optional<Long> boxed(OptionalLong optional) {
        return optional.isPresent() ? Optional.ofNullable(optional.getAsLong()) : Optional.empty();
    }

    public static OptionalLong filter(OptionalLong optional, LongPredicate predicate) {
        return optional.isPresent() && predicate.test(optional.getAsLong()) ? optional : OptionalLong.empty();
    }

    public static OptionalLong flatMap(OptionalLong optional, LongFunction<OptionalLong> mapper) {
        return optional.isPresent() ? mapper.apply(optional.getAsLong()) : OptionalLong.empty();
    }

    public static OptionalDouble flatMapToDouble(OptionalLong optional, LongFunction<OptionalDouble> mapper) {
        return optional.isPresent() ? mapper.apply(optional.getAsLong()) : OptionalDouble.empty();
    }

    public static OptionalInt flatMapToInt(OptionalLong optional, LongFunction<OptionalInt> mapper) {
        return optional.isPresent() ? mapper.apply(optional.getAsLong()) : OptionalInt.empty();
    }

    public static <T> Optional<T> flatMapToObj(OptionalLong optional, LongFunction<Optional<T>> mapper) {
        return optional.isPresent() ? mapper.apply(optional.getAsLong()) : Optional.empty();
    }

    public static OptionalLong map(OptionalLong optional, LongToLongFunction mapper) {
        return optional.isPresent() ? OptionalLong.of(mapper.applyAsLong(optional.getAsLong())) : OptionalLong.empty();
    }

    public static OptionalDouble mapToDouble(OptionalLong optional, LongToDoubleFunction mapper) {
        return optional.isPresent() ? OptionalDouble.of(mapper.applyAsDouble(optional.getAsLong())) : OptionalDouble.empty();
    }

    public static OptionalInt mapToInt(OptionalLong optional, LongToIntFunction mapper) {
        return optional.isPresent() ? OptionalInt.of(mapper.applyAsInt(optional.getAsLong())) : OptionalInt.empty();
    }

    public static <T> Optional<T> mapToObj(OptionalLong optional, LongFunction<T> mapper) {
        return optional.isPresent() ? Optional.ofNullable(mapper.apply(optional.getAsLong())) : Optional.empty();
    }

    public static OptionalLong ofNon(LongPredicate isEmpty, long value) {
        return isEmpty.test(value) ? OptionalLong.empty() : OptionalLong.of(value);
    }

    public static OptionalLong ofNullable(@Nullable Long value) {
        return value == null ? OptionalLong.empty() : OptionalLong.of(value);
    }

    @SafeVarargs
    public static LongStream stream(OptionalLong ... optionals) {
        return Arrays.stream(optionals).filter(OptionalLong::isPresent).mapToLong(OptionalLong::getAsLong);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    private OptionalLongs() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

