/*
 * Decompiled with CFR 0.152.
 */
package de.larssh.utils;

import de.larssh.utils.Nullables;
import de.larssh.utils.TooManyElementsException;
import de.larssh.utils.text.Characters;
import de.larssh.utils.text.Strings;
import edu.umd.cs.findbugs.annotations.Nullable;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Optional;
import java.util.OptionalDouble;
import java.util.OptionalInt;
import java.util.OptionalLong;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.function.ToDoubleFunction;
import java.util.function.ToIntFunction;
import java.util.function.ToLongFunction;
import java.util.stream.Stream;
import lombok.Generated;

public final class Optionals {
    public static <T extends Comparable<T>> Comparator<? super Optional<? extends T>> comparator() {
        return Optionals.comparator((first, second) -> {
            if (first == null) {
                if (second == null) {
                    return 0;
                }
                int compare = second.compareTo(null);
                return compare == Integer.MIN_VALUE ? Integer.MAX_VALUE : -compare;
            }
            return first.compareTo(second);
        });
    }

    public static <T> Comparator<? super Optional<? extends T>> comparator(Comparator<? super T> comparator) {
        return (first, second) -> comparator.compare(Nullables.map(second, optional -> optional.orElse(null)), Nullables.map(second, optional -> optional.orElse(null)));
    }

    public static <T, U extends Comparable<U>> Comparator<T> comparator(Function<T, Optional<U>> keyExtractor) {
        return (first, second) -> {
            Optional firstOptional = (Optional)keyExtractor.apply(first);
            Optional secondOptional = (Optional)keyExtractor.apply(second);
            if (firstOptional.isPresent()) {
                return secondOptional.isPresent() ? ((Comparable)firstOptional.get()).compareTo(secondOptional.get()) : 1;
            }
            return secondOptional.isPresent() ? -1 : 0;
        };
    }

    public static <T> OptionalDouble flatMapToDouble(Optional<T> optional, Function<? super T, OptionalDouble> mapper) {
        return optional.isPresent() ? mapper.apply(optional.get()) : OptionalDouble.empty();
    }

    public static <T> OptionalInt flatMapToInt(Optional<T> optional, Function<? super T, OptionalInt> mapper) {
        return optional.isPresent() ? mapper.apply(optional.get()) : OptionalInt.empty();
    }

    public static <T> OptionalLong flatMapToLong(Optional<T> optional, Function<? super T, OptionalLong> mapper) {
        return optional.isPresent() ? mapper.apply(optional.get()) : OptionalLong.empty();
    }

    @SafeVarargs
    public static <T> Optional<T> getFirst(Optional<T> ... values) {
        for (Optional<T> value : values) {
            if (!value.isPresent()) continue;
            return value;
        }
        return Optional.empty();
    }

    @SafeVarargs
    public static <T> Optional<T> getFirst(Supplier<? extends Optional<T>> ... suppliers) {
        for (Supplier<Optional<Optional<T>>> supplier : suppliers) {
            Optional<T> value = supplier.get();
            if (!value.isPresent()) continue;
            return value;
        }
        return Optional.empty();
    }

    @SafeVarargs
    public static <T> Optional<T> getFirst(Predicate<? super T> isPresent, Supplier<? extends T> ... suppliers) {
        for (Supplier<T> supplier : suppliers) {
            T value = supplier.get();
            if (!isPresent.test(value)) continue;
            return Optional.ofNullable(value);
        }
        return Optional.empty();
    }

    @SafeVarargs
    public static <T> Optional<T> getFirstValue(Predicate<? super T> isPresent, T ... values) {
        for (T value : values) {
            if (!isPresent.test(value)) continue;
            return Optional.ofNullable(value);
        }
        return Optional.empty();
    }

    @SuppressFBWarnings(value={"FII_USE_METHOD_REFERENCE"}, justification="Missing ToLongFunction.identity()")
    public static OptionalDouble mapToDouble(Optional<Double> optional) {
        return Optionals.mapToDouble(optional, value -> value);
    }

    public static <T> OptionalDouble mapToDouble(Optional<T> optional, ToDoubleFunction<? super T> mapper) {
        return optional.isPresent() ? OptionalDouble.of(mapper.applyAsDouble(optional.get())) : OptionalDouble.empty();
    }

    @SuppressFBWarnings(value={"FII_USE_METHOD_REFERENCE"}, justification="Missing ToLongFunction.identity()")
    public static OptionalInt mapToInt(Optional<Integer> optional) {
        return Optionals.mapToInt(optional, value -> value);
    }

    public static <T> OptionalInt mapToInt(Optional<T> optional, ToIntFunction<? super T> mapper) {
        return optional.isPresent() ? OptionalInt.of(mapper.applyAsInt(optional.get())) : OptionalInt.empty();
    }

    @SuppressFBWarnings(value={"FII_USE_METHOD_REFERENCE"}, justification="Missing ToLongFunction.identity()")
    public static OptionalLong mapToLong(Optional<Long> optional) {
        return Optionals.mapToLong(optional, value -> value);
    }

    public static <T> OptionalLong mapToLong(Optional<T> optional, ToLongFunction<? super T> mapper) {
        return optional.isPresent() ? OptionalLong.of(mapper.applyAsLong(optional.get())) : OptionalLong.empty();
    }

    public static <T> Optional<T> ofNon(Predicate<? super T> isEmpty, @Nullable T value) {
        return value == null || isEmpty.test(value) ? Optional.empty() : Optional.of(value);
    }

    public static Optional<String> ofNonBlank(@Nullable String string) {
        return Optionals.ofNon(Strings::isBlank, string);
    }

    @SuppressFBWarnings(value={"UVA_USE_VAR_ARGS"}, justification="var args make no sense as their length is constant")
    public static <T> Optional<T[]> ofNonEmpty(@Nullable T[] array) {
        return Optionals.ofNon(a -> ((Object[])a).length == 0, array);
    }

    public static <T extends Collection<?>> Optional<T> ofNonEmpty(@Nullable T collection) {
        return Optionals.ofNon(Collection::isEmpty, collection);
    }

    public static Optional<String> ofNonEmpty(@Nullable String string) {
        return Optionals.ofNon(String::isEmpty, string);
    }

    @SuppressFBWarnings(value={"UVA_USE_VAR_ARGS"}, justification="var args make no sense as their length is constant")
    public static <T> Optional<T> ofSingle(T[] array) {
        if (array.length == 0) {
            return Optional.empty();
        }
        if (array.length == 1) {
            return Optional.ofNullable(array[0]);
        }
        throw new TooManyElementsException();
    }

    public static <T> Optional<T> ofSingle(Iterable<T> iterable) {
        return Optionals.ofSingle(iterable.iterator());
    }

    public static <T> Optional<T> ofSingle(Iterator<T> iterator) {
        if (!iterator.hasNext()) {
            return Optional.empty();
        }
        Optional<T> optional = Optional.ofNullable(iterator.next());
        if (iterator.hasNext()) {
            throw new TooManyElementsException();
        }
        return optional;
    }

    public static <T> Optional<T> ofSingle(Stream<T> stream) {
        return Optionals.ofSingle(stream.iterator());
    }

    public static OptionalInt ofSingle(CharSequence string) {
        int length = string.length();
        if (length == 0) {
            return OptionalInt.empty();
        }
        for (int index = 1; index < length; ++index) {
            if (Characters.isAsciiWhitespace(string.charAt(index))) continue;
            throw new TooManyElementsException();
        }
        return OptionalInt.of(string.charAt(0));
    }

    @SafeVarargs
    public static <T> Stream<T> stream(Optional<T> ... optionals) {
        return Arrays.stream(optionals).filter(Optional::isPresent).map(Optional::get);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    private Optionals() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

