/*
 * Decompiled with CFR 0.152.
 */
package de.larssh.utils.collection;

import de.larssh.utils.collection.ProxiedIterator;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Collection;
import java.util.Iterator;
import lombok.Generated;

public abstract class ProxiedCollection<E>
implements Collection<E> {
    private final Collection<E> collection;

    @Override
    public boolean add(@Nullable E element) {
        return this.getWrappedIfModifiable().add(element);
    }

    @Override
    public boolean addAll(@Nullable Collection<? extends E> collection) {
        return this.getWrappedIfModifiable().addAll(collection);
    }

    @Override
    public void clear() {
        this.getWrappedIfModifiable().clear();
    }

    @Override
    public boolean contains(@Nullable Object object) {
        return this.getWrappedForRead().contains(object);
    }

    @Override
    public boolean containsAll(@Nullable Collection<?> collection) {
        return this.getWrappedForRead().containsAll(collection);
    }

    @Override
    public boolean equals(@CheckForNull Object object) {
        return this.getWrappedForRead().equals(object);
    }

    protected Collection<E> getWrappedIfModifiable() {
        if (this.isModifiable()) {
            return this.collection;
        }
        throw new UnsupportedOperationException();
    }

    protected Collection<E> getWrappedForRead() {
        return this.collection;
    }

    @Override
    public int hashCode() {
        return this.getWrappedForRead().hashCode();
    }

    @Override
    public boolean isEmpty() {
        return this.getWrappedForRead().isEmpty();
    }

    public abstract boolean isModifiable();

    @Override
    public Iterator<E> iterator() {
        return new ProxiedIterator<E>(this.getWrappedForRead().iterator()){

            @Override
            public boolean isModifiable() {
                return ProxiedCollection.this.isModifiable();
            }
        };
    }

    @Override
    public boolean remove(@Nullable Object object) {
        return this.getWrappedIfModifiable().remove(object);
    }

    @Override
    public boolean removeAll(@Nullable Collection<?> collection) {
        return this.getWrappedIfModifiable().removeAll(collection);
    }

    @Override
    public boolean retainAll(@Nullable Collection<?> collection) {
        return this.getWrappedIfModifiable().retainAll(collection);
    }

    @Override
    public int size() {
        return this.getWrappedForRead().size();
    }

    @Override
    public Object[] toArray() {
        return this.getWrappedForRead().toArray();
    }

    @Override
    public <T> T[] toArray(@Nullable T[] array) {
        return this.getWrappedForRead().toArray(array);
    }

    public String toString() {
        return this.getWrappedForRead().toString();
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public ProxiedCollection(Collection<E> collection) {
        this.collection = collection;
    }
}

