/*
 * Decompiled with CFR 0.152.
 */
package de.larssh.utils.collection;

import de.larssh.utils.collection.ProxiedCollection;
import de.larssh.utils.collection.ProxiedListIterator;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.Collection;
import java.util.List;
import java.util.ListIterator;

public abstract class ProxiedList<E>
extends ProxiedCollection<E>
implements List<E> {
    private final List<E> list;

    protected ProxiedList(List<E> list) {
        super(list);
        this.list = list;
    }

    @Override
    public void add(int index, @Nullable E element) {
        this.getWrappedIfModifiable().add(index, element);
    }

    @Override
    public boolean addAll(int index, @Nullable Collection<? extends E> collection) {
        return this.getWrappedIfModifiable().addAll(index, collection);
    }

    @Override
    @Nullable
    public E get(int index) {
        return this.getWrappedForRead().get(index);
    }

    @Override
    protected List<E> getWrappedIfModifiable() {
        if (this.isModifiable()) {
            return this.list;
        }
        throw new UnsupportedOperationException();
    }

    @Override
    protected List<E> getWrappedForRead() {
        return this.list;
    }

    @Override
    public int indexOf(@Nullable Object object) {
        return this.getWrappedForRead().indexOf(object);
    }

    @Override
    public int lastIndexOf(@Nullable Object object) {
        return this.getWrappedForRead().lastIndexOf(object);
    }

    @Override
    public ListIterator<E> listIterator() {
        return new ProxiedListIterator<E>(this.getWrappedForRead().listIterator()){

            @Override
            public boolean isModifiable() {
                return ProxiedList.this.isModifiable();
            }
        };
    }

    @Override
    public ListIterator<E> listIterator(int index) {
        return new ProxiedListIterator<E>(this.getWrappedForRead().listIterator(index)){

            @Override
            public boolean isModifiable() {
                return ProxiedList.this.isModifiable();
            }
        };
    }

    @Override
    @Nullable
    public E remove(int index) {
        return this.getWrappedIfModifiable().remove(index);
    }

    @Override
    @Nullable
    public E set(int index, @Nullable E element) {
        return this.getWrappedIfModifiable().set(index, element);
    }

    @Override
    public List<E> subList(int fromIndex, int toIndex) {
        return new ProxiedList<E>(this.getWrappedForRead().subList(fromIndex, toIndex)){

            @Override
            public boolean isModifiable() {
                return ProxiedList.this.isModifiable();
            }
        };
    }
}

