/*
 * Decompiled with CFR 0.152.
 */
package de.larssh.utils.collection;

import de.larssh.utils.Finals;
import de.larssh.utils.Nullables;
import de.larssh.utils.collection.ProxiedCollection;
import de.larssh.utils.collection.ProxiedIterator;
import de.larssh.utils.collection.ProxiedSet;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.function.BooleanSupplier;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import lombok.Generated;

public abstract class ProxiedMap<K, V>
implements Map<K, V> {
    private final Map<K, V> map;
    private final Supplier<Set<Map.Entry<K, V>>> entrySet = Finals.lazy(() -> new ProxiedSet<Map.Entry<K, V>>(this.getProxiedForRead().entrySet()){

        @Override
        public boolean isModifiable() {
            return ProxiedMap.this.isModifiable();
        }

        @Override
        public Iterator<Map.Entry<K, V>> iterator() {
            return new ProxiedIterator<Map.Entry<K, V>>(this.getWrappedForRead().iterator()){

                @Override
                public boolean isModifiable() {
                    return ProxiedMap.this.isModifiable();
                }

                @Override
                @Nullable
                public Map.Entry<K, V> next() {
                    return new ProxiedEntry(this::isModifiable, (Map.Entry)Nullables.orElseThrow(super.next()));
                }
            };
        }

        @Override
        public Object[] toArray() {
            return this.stream().map(entry -> new ProxiedEntry(this::isModifiable, entry)).toArray();
        }

        @Override
        public <T> T[] toArray(@Nullable T[] array) {
            return this.stream().map(entry -> new ProxiedEntry(this::isModifiable, entry)).collect(Collectors.toList()).toArray(array);
        }
    });
    private final Supplier<Set<K>> keySet = Finals.lazy(() -> new ProxiedSet<K>(this.getProxiedForRead().keySet()){

        @Override
        public boolean isModifiable() {
            return ProxiedMap.this.isModifiable();
        }
    });
    private final Supplier<Collection<V>> values = Finals.lazy(() -> new ProxiedCollection<V>(this.getProxiedForRead().values()){

        @Override
        public boolean isModifiable() {
            return ProxiedMap.this.isModifiable();
        }
    });

    @Override
    public void clear() {
        this.getProxiedIfModifiable().clear();
    }

    @Override
    public boolean containsKey(@Nullable Object key) {
        return this.getProxiedForRead().containsKey(key);
    }

    @Override
    public boolean containsValue(@Nullable Object value) {
        return this.getProxiedForRead().containsValue(value);
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return this.entrySet.get();
    }

    @Override
    public boolean equals(@CheckForNull Object object) {
        return this.getProxiedForRead().equals(object);
    }

    @Override
    @Nullable
    public V get(@Nullable Object key) {
        return this.getProxiedForRead().get(key);
    }

    protected Map<K, V> getProxiedIfModifiable() {
        if (this.isModifiable()) {
            return this.map;
        }
        throw new UnsupportedOperationException();
    }

    protected Map<K, V> getProxiedForRead() {
        return this.map;
    }

    @Override
    public int hashCode() {
        return this.getProxiedForRead().hashCode();
    }

    @Override
    public boolean isEmpty() {
        return this.getProxiedForRead().isEmpty();
    }

    public abstract boolean isModifiable();

    @Override
    public Set<K> keySet() {
        return this.keySet.get();
    }

    @Override
    @Nullable
    public V put(@Nullable K key, @Nullable V value) {
        return this.getProxiedIfModifiable().put(key, value);
    }

    @Override
    public void putAll(@Nullable Map<? extends K, ? extends V> map) {
        this.getProxiedIfModifiable().putAll(map);
    }

    @Override
    @Nullable
    public V remove(@Nullable Object key) {
        return this.getProxiedIfModifiable().remove(key);
    }

    @Override
    public int size() {
        return this.getProxiedForRead().size();
    }

    public String toString() {
        return this.getProxiedForRead().toString();
    }

    @Override
    public Collection<V> values() {
        return this.values.get();
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public ProxiedMap(Map<K, V> map) {
        this.map = map;
    }

    private static class ProxiedEntry<K, V>
    implements Map.Entry<K, V> {
        private final BooleanSupplier isModifiable;
        private final Map.Entry<K, V> entry;

        @Override
        public boolean equals(@CheckForNull Object object) {
            return this.getEntry().equals(object);
        }

        @Override
        @Nullable
        public K getKey() {
            return this.getEntry().getKey();
        }

        @Override
        @Nullable
        public V getValue() {
            return this.getEntry().getValue();
        }

        @Override
        public int hashCode() {
            return this.getEntry().hashCode();
        }

        @Override
        @Nullable
        public V setValue(@Nullable V value) {
            if (this.isModifiable.getAsBoolean()) {
                return this.getEntry().setValue(value);
            }
            throw new UnsupportedOperationException();
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public ProxiedEntry(BooleanSupplier isModifiable, Map.Entry<K, V> entry) {
            this.isModifiable = isModifiable;
            this.entry = entry;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public Map.Entry<K, V> getEntry() {
            return this.entry;
        }
    }
}

