/*
 * Decompiled with CFR 0.152.
 */
package de.larssh.utils.io;

import edu.umd.cs.findbugs.annotations.Nullable;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.Optional;
import lombok.Generated;

public class MultiInputStream
extends InputStream {
    private static final int END_OF_INPUT_STREAM = -1;
    private boolean closed = false;
    private Optional<InputStream> currentInputStream = Optional.empty();
    private final Iterator<InputStream> inputStreamIterator;

    @Override
    public void close() throws IOException {
        this.closed = true;
        if (this.currentInputStream.isPresent()) {
            this.currentInputStream.get().close();
            this.currentInputStream = Optional.empty();
        }
    }

    private Optional<InputStream> getCurrentInputStream() {
        if (this.closed) {
            return Optional.empty();
        }
        if (this.currentInputStream.isPresent()) {
            return this.currentInputStream;
        }
        Optional<Object> optional = this.currentInputStream = this.inputStreamIterator.hasNext() ? Optional.of(this.inputStreamIterator.next()) : Optional.empty();
        if (!this.currentInputStream.isPresent()) {
            this.closed = true;
        }
        return this.currentInputStream;
    }

    @Override
    public int read() throws IOException {
        Optional<InputStream> inputStream = this.getCurrentInputStream();
        if (!inputStream.isPresent()) {
            return -1;
        }
        int value = inputStream.get().read();
        if (value != -1) {
            return value;
        }
        this.currentInputStream = Optional.empty();
        inputStream.get().close();
        return this.read();
    }

    @Override
    public int read(@Nullable byte[] outputBuffer, int offset, int length) throws IOException {
        Optional<InputStream> inputStream = this.getCurrentInputStream();
        if (!inputStream.isPresent()) {
            return -1;
        }
        int chars = inputStream.get().read(outputBuffer, offset, length);
        if (chars == length) {
            return chars;
        }
        this.currentInputStream = Optional.empty();
        inputStream.get().close();
        int nonNegativeChars = chars == -1 ? 0 : chars;
        int nextChars = this.read(outputBuffer, offset + nonNegativeChars, length - nonNegativeChars);
        return nonNegativeChars + (nextChars == -1 ? 0 : nextChars);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public MultiInputStream(Iterator<InputStream> inputStreamIterator) {
        this.inputStreamIterator = inputStreamIterator;
    }
}

