/*
 * Decompiled with CFR 0.152.
 */
package de.larssh.utils.io;

import de.larssh.utils.Nullables;
import edu.umd.cs.findbugs.annotations.Nullable;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.io.Reader;
import java.util.NoSuchElementException;
import lombok.Generated;

public class PeekableReader
extends Reader {
    private final Reader reader;
    private int peekedCharacter = -1;
    private ReaderState state = ReaderState.CALL_FOR_NEXT;
    private int markedPeekedCharacter = -1;
    private ReaderState markedState = ReaderState.CALL_FOR_NEXT;

    @Override
    public void close() throws IOException {
        this.reader.close();
    }

    public final boolean hasNext() throws IOException {
        if (this.state == ReaderState.CALL_FOR_NEXT) {
            this.peekedCharacter = this.reader.read();
            this.state = this.peekedCharacter == -1 ? ReaderState.END_OF_DATA : ReaderState.PEEKED;
        }
        return this.state == ReaderState.PEEKED;
    }

    @Override
    public void mark(int readAheadLimit) throws IOException {
        this.reader.mark(readAheadLimit);
        this.markedPeekedCharacter = this.peekedCharacter;
        this.markedState = this.state;
    }

    @Override
    public boolean markSupported() {
        return this.reader.markSupported();
    }

    public final char next() throws IOException {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        if (this.state == ReaderState.PEEKED) {
            this.state = ReaderState.CALL_FOR_NEXT;
        }
        char next = (char)this.peekedCharacter;
        this.peekedCharacter = -1;
        return next;
    }

    public char peek() throws IOException {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        return (char)this.peekedCharacter;
    }

    @Override
    public int read() throws IOException {
        if (this.state == ReaderState.PEEKED) {
            this.state = ReaderState.CALL_FOR_NEXT;
            return (char)this.peekedCharacter;
        }
        return super.read();
    }

    @Override
    public int read(@Nullable char[] buffer, int offset, int length) throws IOException {
        if (this.state == ReaderState.CALL_FOR_NEXT) {
            return this.reader.read(buffer, offset, length);
        }
        if (this.state == ReaderState.END_OF_DATA) {
            return -1;
        }
        char[] nonNullableBuffer = Nullables.orElseThrow(buffer);
        if (offset < 0 || length < 0 || offset + length > nonNullableBuffer.length) {
            throw new IndexOutOfBoundsException();
        }
        if (length == 0) {
            return 0;
        }
        nonNullableBuffer[offset] = (char)this.peekedCharacter;
        this.state = ReaderState.CALL_FOR_NEXT;
        if (length == 1) {
            return 1;
        }
        int noOfCharacters = this.reader.read(buffer, offset + 1, length - 1);
        if (noOfCharacters == -1) {
            this.state = ReaderState.END_OF_DATA;
            return 1;
        }
        return noOfCharacters + 1;
    }

    @Override
    public void reset() throws IOException {
        this.reader.reset();
        this.peekedCharacter = this.markedPeekedCharacter;
        this.state = this.markedState;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public PeekableReader(Reader reader) {
        this.reader = reader;
    }

    private static enum ReaderState {
        CALL_FOR_NEXT,
        END_OF_DATA,
        PEEKED;

    }
}

