/*
 * Decompiled with CFR 0.152.
 */
package de.larssh.utils.io;

import de.larssh.utils.Nullables;
import de.larssh.utils.SystemUtils;
import de.larssh.utils.collection.Enumerations;
import de.larssh.utils.io.ResourcePathException;
import de.larssh.utils.text.Patterns;
import de.larssh.utils.text.Strings;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.URI;
import java.net.URL;
import java.nio.file.FileSystemNotFoundException;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Optional;
import java.util.jar.JarInputStream;
import java.util.jar.Manifest;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import lombok.Generated;

public final class Resources {
    private static final String FILE_EXTENSION_CLASS = "class";
    private static final Pattern PATTERN_CHECK_LEASING_PREVIOUS_FOLDER = Pattern.compile("^/?\\.\\.(/|$)");
    private static final Pattern PATTERN_FIX_CURRENT_FOLDER = Pattern.compile("/(\\.?/)+");
    private static final Pattern PATTERN_JAR_FROM_URL = Pattern.compile("(?i)^jar:(?<pathToJar>.*)![^!]*$");

    private static String checkAndFixResourcePath(Path resource) {
        String path = resource.normalize().toString();
        path = path.replace(resource.getFileSystem().getSeparator(), SystemUtils.DEFAULT_FILE_NAME_SEPARATOR);
        if ((path = Strings.replaceAll(path, PATTERN_FIX_CURRENT_FOLDER, SystemUtils.DEFAULT_FILE_NAME_SEPARATOR)).isEmpty()) {
            throw new ResourcePathException("The resource path must not be empty.", new Object[0]);
        }
        if (SystemUtils.DEFAULT_FILE_NAME_SEPARATOR.equals(path)) {
            throw new ResourcePathException("The resource path must not point to root.", new Object[0]);
        }
        if (Strings.find(path, PATTERN_CHECK_LEASING_PREVIOUS_FOLDER)) {
            throw new ResourcePathException("The resource path \"%s\" must not point to a location prior root.", resource.toString());
        }
        return path;
    }

    private static Path createPath(String url) {
        URI uri = URI.create(url);
        try {
            return Paths.get(uri);
        }
        catch (FileSystemNotFoundException fileSystemNotFoundException) {
            try {
                FileSystems.newFileSystem(uri, Collections.emptyMap());
            }
            catch (IOException e) {
                e.addSuppressed(fileSystemNotFoundException);
                throw new UncheckedIOException(e);
            }
            return Paths.get(uri);
        }
    }

    @SuppressFBWarnings(value={"EXS_EXCEPTION_SOFTENING_NO_CONSTRAINTS"}, justification="should not happen on regular usage")
    private static boolean endsPathWithCaseSensitive(Path path, Path end) {
        Path canonicalPath;
        try {
            canonicalPath = path.toFile().getCanonicalFile().toPath();
        }
        catch (UnsupportedOperationException e) {
            canonicalPath = path;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        int pathNames = canonicalPath.getNameCount();
        int endNames = end.getNameCount();
        if (pathNames < endNames) {
            return false;
        }
        for (int index = endNames - 1; index >= 0; --index) {
            if (canonicalPath.getName(pathNames - endNames + index).toString().equals(end.getName(index).toString())) continue;
            return false;
        }
        return true;
    }

    private static ClassLoader getClassLoader(Class<?> clazz) {
        return Nullables.orElseGet(clazz.getClassLoader(), ClassLoader::getSystemClassLoader);
    }

    public static Optional<Path> getPathToClass(Class<?> clazz) {
        return Resources.getUrlToClass(clazz).map(URL::toString).map(Resources::createPath);
    }

    public static Optional<Path> getPathToJar(Class<?> clazz) {
        return Resources.getUrlToClass(clazz).map(URL::toString).flatMap(url -> Patterns.matches(PATTERN_JAR_FROM_URL, url)).map(matcher -> matcher.group("pathToJar")).map(Resources::createPath);
    }

    public static Optional<Path> getResource(ClassLoader classLoader, Path resource) {
        String fixedPath = Resources.checkAndFixResourcePath(resource);
        return Optional.ofNullable(classLoader.getResource(fixedPath)).map(URL::toString).map(Resources::createPath).filter(path -> Resources.endsPathWithCaseSensitive(path, Paths.get(fixedPath, new String[0])));
    }

    @SuppressFBWarnings(value={"PATH_TRAVERSAL_IN"}, justification="processing as described in JavaDoc")
    public static Optional<Path> getResourceRelativeTo(Class<?> clazz, Path resource) {
        return Resources.getResourceStringToClass(clazz).map(x$0 -> Paths.get(x$0, new String[0])).map(Path::getParent).map(path -> path.resolve(resource)).flatMap(absoluteResource -> Resources.getResource(Resources.getClassLoader(clazz), absoluteResource));
    }

    @SuppressFBWarnings(value={"EXS_EXCEPTION_SOFTENING_NO_CONSTRAINTS"}, justification="converting to unchecked IOException")
    public static Stream<Path> getResources(ClassLoader classLoader, Path resource) {
        Enumeration<URL> enumeration;
        String fixedPath = Resources.checkAndFixResourcePath(resource);
        try {
            enumeration = classLoader.getResources(fixedPath);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        return Enumerations.stream(enumeration).map(URL::toString).map(Resources::createPath).filter(path -> Resources.endsPathWithCaseSensitive(path, Paths.get(fixedPath, new String[0])));
    }

    @SuppressFBWarnings(value={"PATH_TRAVERSAL_IN"}, justification="processing as described in JavaDoc")
    public static Stream<Path> getResourcesRelativeTo(Class<?> clazz, Path resource) {
        return Resources.getResourceStringToClass(clazz).map(x$0 -> Paths.get(x$0, new String[0])).map(Path::getParent).map(path -> path.resolve(resource)).map(absoluteResource -> Resources.getResources(Resources.getClassLoader(clazz), absoluteResource)).orElseGet(Stream::empty);
    }

    private static Optional<String> getResourceStringToClass(Class<?> clazz) {
        String className = clazz.getName();
        return className.indexOf(SystemUtils.FILE_EXTENSION_SEPARATOR_CHAR) == -1 ? Optional.empty() : Optional.of(className.replace(SystemUtils.FILE_EXTENSION_SEPARATOR_CHAR, SystemUtils.DEFAULT_FILE_NAME_SEPARATOR_CHAR) + SystemUtils.FILE_EXTENSION_SEPARATOR_CHAR + FILE_EXTENSION_CLASS);
    }

    private static Optional<URL> getUrlToClass(Class<?> clazz) {
        return Resources.getResourceStringToClass(clazz).map(resource -> Resources.getClassLoader(clazz).getResource((String)resource));
    }

    public static Optional<Manifest> readManifest(Class<?> clazz) throws IOException {
        Optional<Path> path = Resources.getPathToJar(clazz);
        if (!path.isPresent()) {
            return Optional.empty();
        }
        try (JarInputStream inputStream = new JarInputStream(Files.newInputStream(path.get(), new OpenOption[0]));){
            Optional<Manifest> optional = Optional.ofNullable(inputStream.getManifest());
            return optional;
        }
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    private Resources() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

