/*
 * Decompiled with CFR 0.152.
 */
package de.larssh.utils.text;

import de.larssh.utils.annotations.PackagePrivate;
import de.larssh.utils.collection.ProxiedList;
import de.larssh.utils.text.Csv;
import de.larssh.utils.text.StringConverters;
import edu.umd.cs.findbugs.annotations.Nullable;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.List;
import java.util.Optional;
import lombok.Generated;

public class CsvRow
extends ProxiedList<String> {
    private final Csv csv;
    private final int rowIndex;

    @PackagePrivate
    CsvRow(Csv csv, int rowIndex, List<String> data) {
        super(data);
        if (rowIndex < 0) {
            throw new IllegalArgumentException(String.format("CSV row index must not be less tan zero, but was %d.", rowIndex));
        }
        this.csv = csv;
        this.rowIndex = rowIndex;
    }

    @SuppressFBWarnings(value={"BED_BOGUS_EXCEPTION_DECLARATION", "FI_USELESS"}, justification="finalize implemented as final method to avoid finalizer attacks when throwing an exception in the constructor")
    protected final void finalize() throws Throwable {
        super.finalize();
    }

    public Optional<String> get(String header) {
        int index = this.getCsv().getHeaders().indexOf(header);
        return index == -1 || index >= this.size() ? Optional.empty() : Optional.of(this.get(index));
    }

    @Override
    public boolean isModifiable() {
        return this.getCsv().isModifiable();
    }

    @Override
    public String toString() {
        return this.toString(this.getCsv().getSeparator(), this.getCsv().getEscaper());
    }

    public String toString(char separator, char escaper) {
        return StringConverters.encodeCsvRow(this, separator, escaper);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public Csv getCsv() {
        return this.csv;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public int getRowIndex() {
        return this.rowIndex;
    }

    @Override
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CsvRow)) {
            return false;
        }
        CsvRow other = (CsvRow)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.getRowIndex() != other.getRowIndex()) {
            return false;
        }
        Csv this$csv = this.getCsv();
        Csv other$csv = other.getCsv();
        return !(this$csv == null ? other$csv != null : !((Object)this$csv).equals(other$csv));
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    protected boolean canEqual(@Nullable Object other) {
        return other instanceof CsvRow;
    }

    @Override
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + this.getRowIndex();
        Csv $csv = this.getCsv();
        result = result * 59 + ($csv == null ? 43 : ((Object)$csv).hashCode());
        return result;
    }
}

