/*
 * Decompiled with CFR 0.152.
 */
package de.larssh.utils.text;

import de.larssh.utils.Collectors;
import de.larssh.utils.Finals;
import de.larssh.utils.Optionals;
import de.larssh.utils.collection.Maps;
import de.larssh.utils.text.Characters;
import de.larssh.utils.text.NumericTextComparator;
import de.larssh.utils.text.Patterns;
import de.larssh.utils.text.StringParseException;
import edu.umd.cs.findbugs.annotations.Nullable;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Formatter;
import java.util.IllegalFormatException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.IntStream;
import lombok.Generated;

@SuppressFBWarnings(value={"POTENTIAL_XML_INJECTION"}, justification="false positive caused by named groups")
public final class Strings {
    private static final String PATTERN_STRING_SEPARATOR = "|";
    public static final Map<String, BigDecimal> BINARY_UNITS = Collections.unmodifiableMap(Strings.getBinaryUnits());
    private static final Pattern BINARY_UNIT_PATTERN = Pattern.compile("(?i)^\\s*(?<value>[+-]?\\s*(\\d([\\d_]*\\d)?)?\\.?\\d([\\d_]*\\d)?)\\s*((?<unit>" + BINARY_UNITS.keySet().stream().map(Pattern::quote).collect(java.util.stream.Collectors.joining("|")) + ")i?)?\\s*$");
    @SuppressFBWarnings(value={"PSC_PRESIZE_COLLECTIONS"}, justification="this method is called just once (in static initializer); keep code simple")
    public static final Map<String, Integer> DECIMAL_UNITS = Maps.builder(new LinkedHashMap()).put("y", -24).put("z", -21).put("a", -18).put("f", -15).put("p", -12).put("n", -9).put("u", -6).put("\u03bc", -6).put("m", -3).put("c", -2).put("d", -1).put("da", 1).put("h", 2).put("k", 3).put("M", 6).put("G", 9).put("T", 12).put("P", 15).put("E", 18).put("Z", 21).put("Y", 24).unmodifiable();
    private static final Pattern DECIMAL_UNIT_PATTERN = Pattern.compile("(?i)^\\s*(?<value>[+-]?\\s*(\\d([\\d_]*\\d)?)?\\.?\\d([\\d_]*\\d)?)\\s*(?<unit>" + DECIMAL_UNITS.keySet().stream().map(Pattern::quote).collect(java.util.stream.Collectors.joining("|")) + ")?\\s*$");
    public static final Charset DEFAULT_CHARSET = StandardCharsets.UTF_8;
    public static final Locale DEFAULT_LOCALE = Locale.ROOT;
    public static final String NEW_LINE = Finals.constant("\n");
    private static final Pattern UNIT_WHITE_SPACE_PATTERN = Pattern.compile("[\\s_]+");

    public static int compareIgnoreCaseAscii(CharSequence first, CharSequence second) {
        int firstLength = first.length();
        int secondLength = second.length();
        int minLength = Math.min(firstLength, secondLength);
        for (int index = 0; index < minLength; ++index) {
            int compare = Characters.compareIgnoreCaseAscii(first.charAt(index), second.charAt(index));
            if (compare == 0) continue;
            return compare;
        }
        if (firstLength == secondLength) {
            return 0;
        }
        return firstLength < secondLength ? -1 : 1;
    }

    public static boolean containsIgnoreCase(CharSequence string, CharSequence substring) {
        return Strings.indexOfIgnoreCase(string, substring) != -1;
    }

    public static boolean containsIgnoreCaseAscii(CharSequence string, CharSequence substring) {
        return Strings.indexOfIgnoreCaseAscii(string, substring) != -1;
    }

    public static boolean equalsIgnoreCaseAscii(@Nullable CharSequence first, @Nullable CharSequence second) {
        if (first == null || second == null) {
            return first == second;
        }
        return Strings.compareIgnoreCaseAscii(first, second) == 0;
    }

    public static boolean endsWithIgnoreCase(CharSequence value, CharSequence suffix) {
        return Strings.startsWithIgnoreCase(value, suffix, value.length() - suffix.length());
    }

    public static boolean endsWithIgnoreCaseAscii(CharSequence value, CharSequence suffix) {
        return Strings.startsWithIgnoreCaseAscii(value, suffix, value.length() - suffix.length());
    }

    public static boolean find(CharSequence input, Pattern pattern) {
        return pattern.matcher(input).find();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @SuppressFBWarnings(value={"FORMAT_STRING_MANIPULATION"}, justification="formatting exceptions are catched and handled accordingly")
    public static String format(String format, Object ... arguments) {
        if (arguments.length < 1) {
            return format;
        }
        try (Formatter formatter = new Formatter(DEFAULT_LOCALE);){
            String string = formatter.format(format, arguments).toString();
            return string;
        }
        catch (IllegalFormatException e) {
            return "Failed formatting string [" + format + "]: " + e.getMessage();
        }
    }

    private static Map<String, BigDecimal> getBinaryUnits() {
        List<String> binaryUnits = Arrays.asList("K", "M", "G", "T", "P", "E", "Z", "Y");
        BigDecimal oneThousandTwentyFour = new BigDecimal(1024);
        return IntStream.range(0, binaryUnits.size()).boxed().collect(Collectors.toLinkedHashMap(binaryUnits::get, index -> oneThousandTwentyFour.pow(index + 1)));
    }

    private static int indexOf(CharSequence string, CharSequence substring, int fromIndex, BiCharPredicate equals) {
        int index;
        int stringLength = string.length();
        if (substring.length() == 0) {
            return index;
        }
        char substringFirst = substring.charAt(0);
        int maxIndex = stringLength - substring.length();
        for (index = fromIndex < 0 ? 0 : (fromIndex >= stringLength ? stringLength : fromIndex); index <= maxIndex; ++index) {
            if (!equals.test(string.charAt(index), substringFirst) || !Strings.startsWith(string, substring, index, equals)) continue;
            return index;
        }
        return -1;
    }

    public static int indexOfIgnoreCase(CharSequence string, CharSequence substring) {
        return Strings.indexOfIgnoreCase(string, substring, 0);
    }

    public static int indexOfIgnoreCase(CharSequence string, CharSequence substring, int fromIndex) {
        return Strings.indexOf(string, substring, fromIndex, Characters::equalsIgnoreCase);
    }

    public static int indexOfIgnoreCaseAscii(CharSequence string, CharSequence substring) {
        return Strings.indexOfIgnoreCaseAscii(string, substring, 0);
    }

    public static int indexOfIgnoreCaseAscii(CharSequence string, CharSequence substring, int fromIndex) {
        return Strings.indexOf(string, substring, fromIndex, Characters::equalsIgnoreCaseAscii);
    }

    public static boolean isBlank(@Nullable CharSequence value) {
        if (value == null) {
            return true;
        }
        int length = value.length();
        for (int index = 0; index < length; ++index) {
            if (Characters.isAsciiWhitespace(value.charAt(index))) continue;
            return false;
        }
        return true;
    }

    public static boolean matches(CharSequence input, Pattern pattern) {
        return pattern.matcher(input).matches();
    }

    public static Comparator<String> numericTextComparator(boolean caseInsensitive) {
        return caseInsensitive ? NumericTextComparator.COMPARATOR_CASE_INSENSITIVE : NumericTextComparator.COMPARATOR_CASE_SENSITIVE;
    }

    public static BigInteger parseBinaryUnit(CharSequence binaryValue) throws StringParseException {
        Optional<Matcher> matcher = Patterns.matches(BINARY_UNIT_PATTERN, binaryValue);
        if (!matcher.isPresent()) {
            throw new StringParseException("Value [%s] does not match binary unit pattern.", binaryValue);
        }
        String value = matcher.get().group("value");
        if (value == null) {
            throw new StringParseException("No binary unit value given in string [%s].", binaryValue);
        }
        String unit = matcher.get().group("unit");
        BigDecimal multiplicator = unit == null ? BigDecimal.ONE : BINARY_UNITS.get(Strings.toUpperCaseAscii(unit));
        return new BigDecimal(Strings.replaceAll(value, UNIT_WHITE_SPACE_PATTERN, "")).multiply(multiplicator).toBigIntegerExact();
    }

    public static BigDecimal parseDecimalUnit(CharSequence decimalValue) throws StringParseException {
        Optional<Matcher> matcher = Patterns.matches(DECIMAL_UNIT_PATTERN, decimalValue);
        if (!matcher.isPresent()) {
            throw new StringParseException("Value [%s] does not match decimal unit pattern.", decimalValue);
        }
        String value = matcher.get().group("value");
        if (value == null) {
            throw new StringParseException("No decimal unit value given in string [%s].", decimalValue);
        }
        String unit = matcher.get().group("unit");
        int powerOfTen = Optionals.getFirst(Objects::nonNull, () -> unit == null ? Integer.valueOf(0) : null, () -> DECIMAL_UNITS.get(unit), () -> DECIMAL_UNITS.get(Strings.toUpperCaseAscii(unit)), () -> DECIMAL_UNITS.get(Strings.toLowerCaseAscii(unit))).orElseThrow(() -> new StringParseException("Found unexpected decimal unit [%s].", unit));
        return new BigDecimal(Strings.replaceAll(value, UNIT_WHITE_SPACE_PATTERN, "")).scaleByPowerOfTen(powerOfTen);
    }

    public static String replaceFirst(CharSequence input, Pattern pattern, String replacement) {
        return pattern.matcher(input).replaceFirst(replacement);
    }

    public static String replaceAll(CharSequence input, Pattern pattern, String replacement) {
        return pattern.matcher(input).replaceAll(replacement);
    }

    private static boolean startsWith(CharSequence value, CharSequence prefix, int offset, BiCharPredicate equals) {
        int prefixLength = prefix.length();
        if (offset < 0 || offset + prefixLength > value.length()) {
            return false;
        }
        for (int index = 0; index < prefixLength; ++index) {
            if (equals.test(value.charAt(offset + index), prefix.charAt(index))) continue;
            return false;
        }
        return true;
    }

    public static boolean startsWithIgnoreCase(CharSequence value, CharSequence prefix) {
        return Strings.startsWithIgnoreCase(value, prefix, 0);
    }

    public static boolean startsWithIgnoreCase(CharSequence value, CharSequence prefix, int offset) {
        return Strings.startsWith(value, prefix, offset, Characters::equalsIgnoreCase);
    }

    public static boolean startsWithIgnoreCaseAscii(CharSequence value, CharSequence prefix) {
        return Strings.startsWithIgnoreCaseAscii(value, prefix, 0);
    }

    public static boolean startsWithIgnoreCaseAscii(CharSequence value, CharSequence prefix, int offset) {
        return Strings.startsWith(value, prefix, offset, Characters::equalsIgnoreCaseAscii);
    }

    public static String toLowerCaseAscii(CharSequence value) {
        int length = value.length();
        StringBuilder builder = new StringBuilder(length);
        for (int index = 0; index < length; ++index) {
            builder.append(Characters.toLowerCaseAscii(value.charAt(index)));
        }
        return builder.toString();
    }

    public static String toLowerCaseNeutral(String value) {
        return value.toLowerCase(DEFAULT_LOCALE);
    }

    public static String toTitleCaseNeutral(String value) {
        if (value.isEmpty()) {
            return value;
        }
        int length = value.length();
        if (length == 1) {
            return Character.toString(Character.toTitleCase(value.charAt(0)));
        }
        String lowerCase = value.toLowerCase(DEFAULT_LOCALE);
        return new StringBuilder(length).append(Character.toTitleCase(value.charAt(0))).append(lowerCase, 1, lowerCase.length()).toString();
    }

    public static String toUpperCaseAscii(CharSequence value) {
        int length = value.length();
        StringBuilder builder = new StringBuilder(length);
        for (int index = 0; index < length; ++index) {
            builder.append(Characters.toUpperCaseAscii(value.charAt(index)));
        }
        return builder.toString();
    }

    public static String toUpperCaseNeutral(String value) {
        return value.toUpperCase(DEFAULT_LOCALE);
    }

    public static String trimStart(CharSequence value) {
        int start;
        int length = value.length();
        for (start = 0; start < length && Characters.isAsciiWhitespace(value.charAt(start)); ++start) {
        }
        return value.subSequence(start, length).toString();
    }

    public static String trimEnd(CharSequence value) {
        int end;
        for (end = value.length(); end > 0 && Characters.isAsciiWhitespace(value.charAt(end - 1)); --end) {
        }
        return value.subSequence(0, end).toString();
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    private Strings() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    @FunctionalInterface
    private static interface BiCharPredicate {
        public boolean test(char var1, char var2);
    }
}

