/*
 * Decompiled with CFR 0.152.
 */
package de.larssh.utils.time;

import de.larssh.utils.CompletedException;
import de.larssh.utils.time.Stopwatch;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.time.Duration;
import java.time.Instant;
import java.util.Optional;
import lombok.Generated;

public abstract class CloseableStopwatch
extends Stopwatch
implements AutoCloseable {
    private volatile Optional<Instant> stopInstant = Optional.empty();
    private final Object lock = new Object();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Stopwatch.Checkpoint checkpoint(String name) {
        Object object = this.lock;
        synchronized (object) {
            if (this.isStopped()) {
                throw new CompletedException();
            }
            return super.checkpoint(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        Object object = this.lock;
        synchronized (object) {
            if (!this.isStopped()) {
                this.stopInstant = Optional.of(Instant.now());
            }
        }
    }

    public boolean isStopped() {
        return this.stopInstant.isPresent();
    }

    @Override
    public Duration sinceLast() {
        return Duration.between(this.getLastInstant(), this.getStopInstant().orElseGet(Instant::now));
    }

    @Override
    public Duration sinceStart() {
        return Duration.between(this.getStartInstant(), this.getStopInstant().orElseGet(Instant::now));
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public Optional<Instant> getStopInstant() {
        return this.stopInstant;
    }

    @Override
    @NonNull
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String toString() {
        return "CloseableStopwatch(super=" + super.toString() + ", stopInstant=" + this.getStopInstant() + ")";
    }
}

