/*
 * Decompiled with CFR 0.152.
 */
package de.larssh.utils.time;

import de.larssh.utils.Nullables;
import de.larssh.utils.function.ThrowingConsumer;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.time.Duration;
import java.time.Instant;
import java.time.temporal.TemporalAccessor;
import java.time.temporal.TemporalField;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Stream;
import lombok.Generated;

public class Stopwatch {
    private final List<Checkpoint> checkpoints = Collections.synchronizedList(new LinkedList());
    private final Instant startInstant = Instant.now();
    private final Object lock = new Object();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Checkpoint checkpoint(String name) {
        Object object = this.lock;
        synchronized (object) {
            Checkpoint checkpoint = new Checkpoint(this, name, Instant.now(), this.getLastCheckpoint());
            this.checkpoints.add(checkpoint);
            return checkpoint;
        }
    }

    public List<Checkpoint> getCheckpoints() {
        return Collections.unmodifiableList(this.checkpoints);
    }

    public Optional<Checkpoint> getLastCheckpoint() {
        return this.checkpoints.isEmpty() ? Optional.empty() : Optional.of(this.checkpoints.get(this.checkpoints.size() - 1));
    }

    public Instant getLastInstant() {
        return this.checkpoints.isEmpty() ? this.getStartInstant() : this.checkpoints.get(this.checkpoints.size() - 1).getInstant();
    }

    public Duration sinceLast() {
        return Duration.between(this.getLastInstant(), Instant.now());
    }

    public Duration sinceStart() {
        return Duration.between(this.getStartInstant(), Instant.now());
    }

    @SuppressFBWarnings(value={"MDM_THREAD_YIELD"}, justification="This is really intended to sleep for a specified duration.")
    public boolean waitFor(Duration duration, Duration timeoutSinceStart) throws InterruptedException {
        return this.waitFor(duration, timeoutSinceStart, ThrowingConsumer.throwing(waiting -> Thread.sleep(Nullables.orElseThrow(waiting).toMillis())));
    }

    @SuppressFBWarnings(value={"PRMC_POSSIBLY_REDUNDANT_METHOD_CALLS"}, justification="no redundant calls, because Instant.now() might return different values")
    public boolean waitFor(Duration duration, Duration timeoutSinceStart, Consumer<Duration> wait) {
        Duration actualWaiting;
        if (duration.isNegative()) {
            throw new IllegalArgumentException(String.format("Parameter \"duration\" must not be negative, but is %s.", duration));
        }
        if (timeoutSinceStart.isNegative()) {
            throw new IllegalArgumentException(String.format("Parameter \"timeoutSinceStart\" must not be negative, but is %s.", timeoutSinceStart));
        }
        Instant timeout = this.getStartInstant().plus(timeoutSinceStart);
        Duration maxWaiting = Duration.between(Instant.now(), timeout);
        Duration duration2 = actualWaiting = maxWaiting.compareTo(duration) > 0 ? duration : maxWaiting;
        if (!actualWaiting.isNegative() && !actualWaiting.isZero()) {
            wait.accept(actualWaiting);
        }
        return !Instant.now().isAfter(timeout);
    }

    public Stream<Checkpoint> stream() {
        return this.checkpoints.stream();
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public Instant getStartInstant() {
        return this.startInstant;
    }

    @NonNull
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String toString() {
        return "Stopwatch(checkpoints=" + this.getCheckpoints() + ", startInstant=" + this.getStartInstant() + ")";
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public Stopwatch() {
    }

    public static class Checkpoint
    implements Comparable<Checkpoint>,
    TemporalAccessor {
        private static final Comparator<Checkpoint> COMPARATOR = Comparator.comparing(Checkpoint::getInstant).thenComparing(Comparator.comparing(checkpoint -> checkpoint.getPreviousCheckpoint().map(Checkpoint::getInstant).orElse(Instant.MIN)));
        private final Stopwatch stopwatch;
        private final String name;
        private final Instant instant;
        private final Optional<Checkpoint> previousCheckpoint;

        @Override
        public int compareTo(@Nullable Checkpoint object) {
            return Objects.compare(this, object, COMPARATOR);
        }

        @Override
        public long getLong(@Nullable TemporalField field) {
            return this.getInstant().getLong(field);
        }

        public Instant getPreviousInstant() {
            return this.getPreviousCheckpoint().map(Checkpoint::getInstant).orElseGet(this.getStopwatch()::getStartInstant);
        }

        @Override
        public boolean isSupported(@Nullable TemporalField field) {
            return this.getInstant().isSupported(field);
        }

        public Duration sincePrevious() {
            return Duration.between(this.getPreviousInstant(), this.getInstant());
        }

        public Duration sinceStart() {
            return Duration.between(this.getStopwatch().getStartInstant(), this.getInstant());
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public Stopwatch getStopwatch() {
            return this.stopwatch;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public String getName() {
            return this.name;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public Instant getInstant() {
            return this.instant;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public Optional<Checkpoint> getPreviousCheckpoint() {
            return this.previousCheckpoint;
        }

        @NonNull
        @SuppressFBWarnings(justification="generated code")
        @Generated
        public String toString() {
            return "Stopwatch.Checkpoint(instant=" + this.getInstant() + ", name=" + this.getName() + ", previousCheckpoint=" + this.getPreviousCheckpoint() + ", stopwatch=" + this.getStopwatch() + ")";
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Checkpoint)) {
                return false;
            }
            Checkpoint other = (Checkpoint)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$name = this.getName();
            String other$name = other.getName();
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                return false;
            }
            Instant this$instant = this.getInstant();
            Instant other$instant = other.getInstant();
            if (this$instant == null ? other$instant != null : !((Object)this$instant).equals(other$instant)) {
                return false;
            }
            Optional<Checkpoint> this$previousCheckpoint = this.getPreviousCheckpoint();
            Optional<Checkpoint> other$previousCheckpoint = other.getPreviousCheckpoint();
            return !(this$previousCheckpoint == null ? other$previousCheckpoint != null : !((Object)this$previousCheckpoint).equals(other$previousCheckpoint));
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        protected boolean canEqual(@Nullable Object other) {
            return other instanceof Checkpoint;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            Instant $instant = this.getInstant();
            result = result * 59 + ($instant == null ? 43 : ((Object)$instant).hashCode());
            Optional<Checkpoint> $previousCheckpoint = this.getPreviousCheckpoint();
            result = result * 59 + ($previousCheckpoint == null ? 43 : ((Object)$previousCheckpoint).hashCode());
            return result;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        protected Checkpoint(Stopwatch stopwatch, String name, Instant instant, Optional<Checkpoint> previousCheckpoint) {
            this.stopwatch = stopwatch;
            this.name = name;
            this.instant = instant;
            this.previousCheckpoint = previousCheckpoint;
        }
    }
}

