/*
 * Decompiled with CFR 0.152.
 */
package de.larsgrefer.sass.embedded.connection;

import de.larsgrefer.sass.embedded.SassCompilerFactory;
import de.larsgrefer.sass.embedded.connection.ProcessConnection;
import de.larsgrefer.sass.embedded.util.IOUtils;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import lombok.Generated;

public final class ConnectionFactory {
    private static File bundledDartExec;

    public static ProcessConnection bundled() throws IOException {
        ProcessBuilder processBuilder = new ProcessBuilder(ConnectionFactory.getBundledDartExec().getAbsolutePath());
        return new ProcessConnection(processBuilder);
    }

    static File getBundledDartExec() throws IOException {
        if (bundledDartExec == null) {
            ConnectionFactory.extractBundled();
        }
        return bundledDartExec;
    }

    static synchronized void extractBundled() throws IOException {
        String resourcePath = ConnectionFactory.getBundledCompilerDistPath();
        URL dist = SassCompilerFactory.class.getResource(resourcePath);
        if (dist == null) {
            throw new IllegalStateException("Resource not found: " + resourcePath);
        }
        Path tempDirectory = Files.createTempDirectory("dart-sass", new FileAttribute[0]);
        IOUtils.extract(dist, tempDirectory);
        File execDir = tempDirectory.resolve("sass_embedded").toFile();
        File[] execFile = execDir.listFiles(pathname -> pathname.isFile() && pathname.getName().startsWith("dart-sass-embedded"));
        if (execFile == null || execFile.length != 1) {
            throw new IllegalStateException("No (unique) executable file found in " + execDir);
        }
        bundledDartExec = execFile[0];
        bundledDartExec.setWritable(false);
        bundledDartExec.setExecutable(true, true);
    }

    private static String getBundledCompilerDistPath() {
        String classifier;
        String osName = System.getProperty("os.name").toLowerCase();
        String osArch = System.getProperty("os.arch").toLowerCase();
        String archiveExtension = "tar.gz";
        if (osName.contains("mac")) {
            classifier = "macos-x64";
        } else if (osName.contains("win")) {
            archiveExtension = "zip";
            classifier = osArch.contains("64") ? "windows-x64" : "windows-ia32";
        } else {
            classifier = osArch.contains("64") ? "linux-x64" : "linux-ia32";
        }
        return String.format("/de/larsgrefer/sass/embedded/sass_embedded-%s.%s", classifier, archiveExtension);
    }

    @Generated
    private ConnectionFactory() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

