/*
 * Decompiled with CFR 0.152.
 */
package de.larsgrefer.sass.embedded.importer;

import de.larsgrefer.sass.embedded.importer.CanonicalizationHelper;
import de.larsgrefer.sass.embedded.importer.CustomImporter;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import sass.embedded_protocol.EmbeddedSass;

class AutoCanonicalizingImporter
extends CustomImporter {
    public final CustomImporter delegate;

    @Override
    public String canonicalize(String url, boolean fromImport) throws Exception {
        String canonUrl = this.delegate.canonicalize(url, fromImport);
        if (canonUrl != null) {
            return canonUrl;
        }
        canonUrl = this.canonicalize(url, CanonicalizationHelper.resolvePossiblePaths(url));
        if (canonUrl != null) {
            return canonUrl;
        }
        return this.canonicalize(url, CanonicalizationHelper.resolvePossibleIndexPaths(url));
    }

    private String canonicalize(String baseUrl, List<String> possibleUrls) throws Exception {
        ArrayList<String> canonicalizedUrls = new ArrayList<String>(possibleUrls.size());
        for (String indexPath : possibleUrls) {
            String canonUrl = this.delegate.canonicalize(indexPath, false);
            if (canonUrl == null) continue;
            canonicalizedUrls.add(canonUrl);
        }
        if (canonicalizedUrls.isEmpty()) {
            return null;
        }
        if (canonicalizedUrls.size() == 1) {
            return (String)canonicalizedUrls.get(0);
        }
        throw new IllegalStateException("Import '" + baseUrl + "' is ambiguous: " + canonicalizedUrls);
    }

    @Override
    public EmbeddedSass.InboundMessage.ImportResponse.ImportSuccess handleImport(String url) throws Exception {
        return this.delegate.handleImport(url);
    }

    @Override
    public AutoCanonicalizingImporter autoCanonicalize() {
        return this;
    }

    @Generated
    public AutoCanonicalizingImporter(CustomImporter delegate) {
        this.delegate = delegate;
    }
}

