/*
 * Decompiled with CFR 0.152.
 */
package de.larsgrefer.sass.embedded.importer;

import com.google.protobuf.ByteString;
import de.larsgrefer.sass.embedded.importer.CustomImporter;
import de.larsgrefer.sass.embedded.util.SyntaxUtil;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.JarURLConnection;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sass.embedded_protocol.EmbeddedSass;

public abstract class CustomUrlImporter
extends CustomImporter {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CustomUrlImporter.class);
    private final Set<String> protocols = new HashSet<String>();
    private final Set<String> usedPrefixes = new HashSet<String>();

    @Override
    public String canonicalize(String url, boolean fromImport) throws Exception {
        String urlString;
        URL result = this.canonicalizeUrl(url);
        if (result == null && !this.usedPrefixes.isEmpty() && this.isAbsolute(url)) {
            result = this.canonicalizeUrl(this.getRelativePart(url));
        }
        if (result == null) {
            return null;
        }
        if (result.getProtocol().equals("file")) {
            URI fileUri = new File(result.getPath()).toPath().toUri();
            this.protocols.add(fileUri.getScheme());
            urlString = fileUri.toString();
        } else {
            this.protocols.add(result.getProtocol());
            urlString = result.toString();
        }
        if (urlString.length() > url.length()) {
            if (urlString.endsWith(url)) {
                this.usedPrefixes.add(urlString.substring(0, urlString.length() - url.length()));
            } else {
                log.info("{} -> {}", (Object)url, (Object)urlString);
            }
        }
        return urlString;
    }

    @Nullable
    public abstract URL canonicalizeUrl(String var1) throws Exception;

    private boolean isAbsolute(String url) {
        if (!url.contains(":")) {
            return false;
        }
        for (String protocol : this.protocols) {
            if (!url.startsWith(protocol + ":")) continue;
            return true;
        }
        return false;
    }

    private String getRelativePart(String url) {
        List prefixes = this.usedPrefixes.stream().filter(url::startsWith).sorted(Comparator.comparingInt(String::length)).collect(Collectors.toList());
        if (prefixes.size() == 0) {
            throw new IllegalStateException(url + " has no known prefix");
        }
        if (prefixes.size() == 1) {
            String prefix = (String)prefixes.get(0);
            return url.substring(prefix.length());
        }
        throw new IllegalStateException("Multiple prefixes for URL " + url);
    }

    @Override
    public EmbeddedSass.InboundMessage.ImportResponse.ImportSuccess handleImport(String string) throws Exception {
        URL url = new URL(string);
        return this.handleImport(url);
    }

    public EmbeddedSass.InboundMessage.ImportResponse.ImportSuccess handleImport(URL url) throws Exception {
        EmbeddedSass.InboundMessage.ImportResponse.ImportSuccess.Builder result = EmbeddedSass.InboundMessage.ImportResponse.ImportSuccess.newBuilder();
        URLConnection urlConnection = url.openConnection();
        try (InputStream in = urlConnection.getInputStream();){
            ByteString content = ByteString.readFrom((InputStream)in);
            result.setContentsBytes(content);
            result.setSyntax(SyntaxUtil.guessSyntax(urlConnection));
        }
        return result.build();
    }

    protected boolean isFile(URL url) throws IOException {
        String urlPath = url.getPath();
        if (url.getProtocol().equals("file")) {
            File file = new File(urlPath);
            return file.exists() && file.isFile();
        }
        URLConnection connection = url.openConnection();
        if (connection instanceof JarURLConnection) {
            JarURLConnection jarURLConnection = (JarURLConnection)connection;
            try {
                JarEntry jarEntry = jarURLConnection.getJarEntry();
                return jarEntry != null && !jarEntry.isDirectory();
            }
            catch (FileNotFoundException e) {
                return false;
            }
        }
        if (connection instanceof HttpURLConnection) {
            HttpURLConnection httpURLConnection = (HttpURLConnection)connection;
            httpURLConnection.setRequestMethod("HEAD");
            int responseCode = httpURLConnection.getResponseCode();
            if (responseCode > 400) {
                return false;
            }
            if (responseCode == 200) {
                return true;
            }
        }
        if (urlPath.endsWith(".css") || urlPath.endsWith(".scss") || urlPath.endsWith(".sass")) {
            return true;
        }
        throw new IllegalArgumentException("Can't handle url: " + url);
    }
}

