/*
 * Decompiled with CFR 0.152.
 */
package de.larsgrefer.sass.embedded.util;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.concurrent.TimeUnit;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import lombok.Generated;

public final class IOUtils {
    private static final int bufferSize = 4096;

    public static void extract(URL archiveUrl, Path destinationDir) throws IOException {
        String file = archiveUrl.getPath();
        if (file.endsWith(".zip")) {
            try (ZipInputStream in = new ZipInputStream(archiveUrl.openStream());){
                IOUtils.unzip(in, destinationDir);
            }
        } else if (file.endsWith(".tar.gz")) {
            try (InputStream in = archiveUrl.openStream();){
                IOUtils.untar(in, destinationDir.toFile());
            }
        } else {
            throw new IllegalArgumentException("Unknown archive extension: " + archiveUrl);
        }
    }

    public static void unzip(ZipInputStream zipInputStream, Path targetPath) throws IOException {
        ZipEntry entry = zipInputStream.getNextEntry();
        while (entry != null) {
            Path entryPath = targetPath.resolve(entry.getName());
            File entryFile = entryPath.toFile();
            if (entry.isDirectory()) {
                IOUtils.ensureDirectory(entryFile);
            } else {
                IOUtils.ensureDirectory(entryFile.getParentFile());
                Files.copy(zipInputStream, entryPath, new CopyOption[0]);
            }
            zipInputStream.closeEntry();
            entry = zipInputStream.getNextEntry();
        }
    }

    private static void ensureDirectory(File entryFile) throws IOException {
        if (!entryFile.isDirectory() && !entryFile.mkdirs()) {
            throw new IOException("Failed to create dir " + entryFile);
        }
    }

    public static void untar(InputStream inputStream, File targetDir) throws IOException {
        int exitValue;
        IOUtils.ensureDirectory(targetDir);
        Process tar = new ProcessBuilder("tar", "xz").directory(targetDir).redirectError(ProcessBuilder.Redirect.INHERIT).redirectOutput(ProcessBuilder.Redirect.INHERIT).redirectInput(ProcessBuilder.Redirect.PIPE).start();
        try (OutputStream os = tar.getOutputStream();){
            IOUtils.copy(inputStream, os);
        }
        if (!tar.waitFor(5L, TimeUnit.SECONDS)) {
            tar.destroy();
        }
        if (!tar.waitFor(5L, TimeUnit.SECONDS)) {
            tar.destroyForcibly();
        }
        if ((exitValue = tar.exitValue()) != 0) {
            throw new IOException("tar process exited with " + exitValue);
        }
    }

    public static void copy(InputStream inputStream, OutputStream os) throws IOException {
        int read;
        byte[] buffer = new byte[4096];
        while ((read = inputStream.read(buffer, 0, 4096)) >= 0) {
            os.write(buffer, 0, read);
        }
    }

    @Generated
    private IOUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

