/*
 * Decompiled with CFR 0.152.
 */
package de.larsgrefer.sass.embedded.connection;

import de.larsgrefer.sass.embedded.connection.StreamConnection;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.concurrent.TimeUnit;
import lombok.Generated;

public class ProcessConnection
extends StreamConnection {
    private final Process process;

    public ProcessConnection(ProcessBuilder processBuilder) throws IOException {
        this(processBuilder.redirectInput(ProcessBuilder.Redirect.PIPE).redirectOutput(ProcessBuilder.Redirect.PIPE).redirectError(ProcessBuilder.Redirect.INHERIT).start());
    }

    @Override
    public void close() {
        this.process.destroy();
        if (!this.process.waitFor(2L, TimeUnit.SECONDS)) {
            this.process.destroyForcibly();
        }
    }

    @Override
    protected InputStream getInputStream() throws IOException {
        this.assertAlive();
        return this.process.getInputStream();
    }

    @Override
    protected OutputStream getOutputStream() throws IOException {
        this.assertAlive();
        return this.process.getOutputStream();
    }

    private void assertAlive() throws IOException {
        if (!this.process.isAlive()) {
            throw new IOException("Process is dead. Exit code was: " + this.process.exitValue());
        }
    }

    @Generated
    public ProcessConnection(Process process) {
        this.process = process;
    }
}

