/*
 * Decompiled with CFR 0.152.
 */
package de.larsgrefer.sass.embedded.functions;

import de.larsgrefer.sass.embedded.functions.ConversionService;
import de.larsgrefer.sass.embedded.functions.HostFunction;
import java.util.List;
import java.util.function.BiFunction;
import javax.annotation.Nonnull;
import sass.embedded_protocol.EmbeddedSass;

class BiFunctionHostFunction<T, U>
extends HostFunction {
    private static final List<HostFunction.Argument> args = List.of(new HostFunction.Argument("arg0", null), new HostFunction.Argument("arg1", null));
    private final BiFunction<T, U, ?> lambda;
    private final Class<T> arg0Type;
    private final Class<U> arg1Type;

    protected BiFunctionHostFunction(String name, Class<T> arg0Type, Class<U> arg1Type, BiFunction<T, U, ?> lambda) {
        super(name, args);
        this.lambda = lambda;
        this.arg0Type = arg0Type;
        this.arg1Type = arg1Type;
    }

    @Override
    @Nonnull
    public EmbeddedSass.Value invoke(List<EmbeddedSass.Value> arguments) {
        if (arguments.size() != 2) {
            throw new IllegalArgumentException("Invalid argument count: Expected 2 instead of " + arguments.size());
        }
        T arg0 = ConversionService.toJavaValue(arguments.get(0), this.arg0Type, this.arg0Type);
        U arg1 = ConversionService.toJavaValue(arguments.get(1), this.arg1Type, this.arg1Type);
        Object call = this.lambda.apply(arg0, arg1);
        return ConversionService.toSassValue(call);
    }
}

