/*
 * Decompiled with CFR 0.152.
 */
package de.larsgrefer.sass.embedded.connection;

import com.google.protobuf.CodedInputStream;
import com.google.protobuf.CodedOutputStream;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.Message;
import com.google.protobuf.Parser;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import lombok.Generated;

public class Packet<T extends Message> {
    private int compilationId;
    private T message;

    public int getSerializedSize() {
        return CodedOutputStream.computeUInt32SizeNoTag((int)this.compilationId) + this.message.getSerializedSize();
    }

    public void writeDelimitedTo(OutputStream outputStream) throws IOException {
        int fullSize = this.getSerializedSize();
        int bufferSize = CodedOutputStream.computeUInt32SizeNoTag((int)fullSize) + fullSize;
        if (bufferSize > 4096) {
            bufferSize = 4096;
        }
        CodedOutputStream codedOutput = CodedOutputStream.newInstance((OutputStream)outputStream, (int)bufferSize);
        codedOutput.writeUInt32NoTag(fullSize);
        codedOutput.writeUInt32NoTag(this.compilationId);
        this.message.writeTo(codedOutput);
        codedOutput.flush();
    }

    public static <T extends Message> Packet<T> parseDelimitedFrom(InputStream inputStream, Parser<T> parser) throws IOException {
        int firstByte = inputStream.read();
        int fullSize = CodedInputStream.readRawVarint32((int)firstByte, (InputStream)inputStream);
        inputStream = new LimitedInputStream(inputStream, fullSize);
        firstByte = inputStream.read();
        int compilationId = CodedInputStream.readRawVarint32((int)firstByte, (InputStream)inputStream);
        try {
            Message message = (Message)parser.parseFrom(inputStream);
            return new Packet<Message>(compilationId, message);
        }
        catch (InvalidProtocolBufferException e) {
            throw e.unwrapIOException();
        }
    }

    @Generated
    public int getCompilationId() {
        return this.compilationId;
    }

    @Generated
    public T getMessage() {
        return this.message;
    }

    @Generated
    public void setCompilationId(int compilationId) {
        this.compilationId = compilationId;
    }

    @Generated
    public void setMessage(T message) {
        this.message = message;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Packet)) {
            return false;
        }
        Packet other = (Packet)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getCompilationId() != other.getCompilationId()) {
            return false;
        }
        T this$message = this.getMessage();
        T other$message = other.getMessage();
        return !(this$message == null ? other$message != null : !this$message.equals(other$message));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Packet;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getCompilationId();
        T $message = this.getMessage();
        result = result * 59 + ($message == null ? 43 : $message.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "Packet(compilationId=" + this.getCompilationId() + ", message=" + this.getMessage() + ")";
    }

    @Generated
    public Packet(int compilationId, T message) {
        this.compilationId = compilationId;
        this.message = message;
    }

    static final class LimitedInputStream
    extends FilterInputStream {
        private int limit;

        LimitedInputStream(InputStream in, int limit) {
            super(in);
            this.limit = limit;
        }

        @Override
        public int available() throws IOException {
            return Math.min(super.available(), this.limit);
        }

        @Override
        public int read() throws IOException {
            if (this.limit <= 0) {
                return -1;
            }
            int result = super.read();
            if (result >= 0) {
                --this.limit;
            }
            return result;
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            if (this.limit <= 0) {
                return -1;
            }
            int result = super.read(b, off, len = Math.min(len, this.limit));
            if (result >= 0) {
                this.limit -= result;
            }
            return result;
        }

        @Override
        public long skip(long n) throws IOException {
            int result = (int)super.skip(Math.min(n, (long)this.limit));
            if (result >= 0) {
                this.limit -= result;
            }
            return result;
        }
    }
}

