/*
 * Decompiled with CFR 0.152.
 */
package de.larsgrefer.sass.embedded.connection;

import com.google.protobuf.MessageOrBuilder;
import com.google.protobuf.TextFormat;
import com.sass_lang.embedded_protocol.InboundMessage;
import com.sass_lang.embedded_protocol.OutboundMessage;
import de.larsgrefer.sass.embedded.connection.CompilerConnection;
import de.larsgrefer.sass.embedded.connection.Packet;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class StreamConnection
implements CompilerConnection {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(StreamConnection.class);

    protected abstract InputStream getInputStream() throws IOException;

    protected abstract OutputStream getOutputStream() throws IOException;

    @Override
    public synchronized void sendMessage(Packet<InboundMessage> packet) throws IOException {
        if (log.isTraceEnabled()) {
            log.trace("{} --> {}", (Object)packet.getCompilationId(), (Object)TextFormat.printer().shortDebugString((MessageOrBuilder)packet.getMessage()));
        }
        if (packet.getMessage().hasVersionRequest()) {
            packet.setCompilationId(0);
        }
        OutputStream outputStream = this.getOutputStream();
        packet.writeDelimitedTo(outputStream);
        outputStream.flush();
    }

    @Override
    public synchronized Packet<OutboundMessage> readResponse() throws IOException {
        Packet<OutboundMessage> packet = Packet.parseDelimitedFrom(this.getInputStream(), OutboundMessage.parser());
        if (log.isTraceEnabled()) {
            log.trace("{} <-- {}", (Object)packet.getCompilationId(), (Object)TextFormat.printer().shortDebugString((MessageOrBuilder)packet.getMessage()));
        }
        return packet;
    }
}

