/*
 * Decompiled with CFR 0.152.
 */
package de.larsgrefer.sass.embedded.logging;

import com.sass_lang.embedded_protocol.LogEventType;
import com.sass_lang.embedded_protocol.OutboundMessage;
import de.larsgrefer.sass.embedded.logging.LoggingHandler;
import java.util.logging.Level;
import java.util.logging.Logger;
import lombok.Generated;

public class JulLoggingHandler
implements LoggingHandler {
    private final Logger logger;

    @Override
    public void handle(OutboundMessage.LogEventOrBuilder logEvent) {
        Level logLevel = this.getLogLevel(logEvent.getType());
        this.logger.log(logLevel, logEvent.getFormatted());
    }

    protected Level getLogLevel(LogEventType type) {
        switch (type) {
            case WARNING: 
            case DEPRECATION_WARNING: {
                return Level.WARNING;
            }
            case DEBUG: {
                return Level.FINE;
            }
        }
        return Level.INFO;
    }

    @Generated
    public JulLoggingHandler(Logger logger) {
        this.logger = logger;
    }
}

