/*
 * Decompiled with CFR 0.152.
 */
package de.larsgrefer.sass.embedded.spring;

import com.sass_lang.embedded_protocol.OutputStyle;
import de.larsgrefer.sass.embedded.CompileSuccess;
import lombok.Generated;
import org.springframework.core.io.Resource;
import org.springframework.http.HttpHeaders;
import org.springframework.lang.NonNull;
import org.springframework.util.StringUtils;
import org.springframework.web.servlet.resource.HttpResource;
import org.springframework.web.servlet.resource.TransformedResource;

class CompiledResource
extends TransformedResource
implements HttpResource {
    private final String filename;
    private final OutputStyle outputStyle;
    private final boolean hasSourceMap;

    public String getFilename() {
        return this.filename;
    }

    public CompiledResource(Resource original, CompileSuccess compileSuccess, String filename, OutputStyle outputStyle) {
        super(original, compileSuccess.getCssBytes().toByteArray());
        this.filename = filename;
        this.outputStyle = outputStyle;
        this.hasSourceMap = StringUtils.hasText((String)compileSuccess.getSourceMap());
    }

    @NonNull
    public HttpHeaders getResponseHeaders() {
        HttpHeaders httpHeaders = new HttpHeaders();
        if (this.hasSourceMap) {
            httpHeaders.set("SourceMap", this.filename + ".map");
            httpHeaders.set("X-SourceMap", this.filename + ".map");
        }
        return httpHeaders;
    }

    @Generated
    public OutputStyle getOutputStyle() {
        return this.outputStyle;
    }
}

