/*
 * Decompiled with CFR 0.152.
 */
package de.larsgrefer.sass.embedded.connection;

import androidx.annotation.RequiresApi;
import de.larsgrefer.sass.embedded.util.DirCleaner;
import de.larsgrefer.sass.embedded.util.IOUtils;
import de.larsgrefer.sass.embedded.util.PropertyUtils;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import javax.annotation.Nullable;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RequiresApi(value=1000)
public abstract class DartSassPackageProvider {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DartSassPackageProvider.class);
    private File dartSassExecutable;

    @Nullable
    public File getDartSassExecutable() throws IOException {
        if (this.dartSassExecutable == null || !this.dartSassExecutable.exists()) {
            this.dartSassExecutable = this.extractPackage();
        }
        return this.dartSassExecutable;
    }

    synchronized File extractPackage() throws IOException {
        File execDir;
        File[] execFile;
        URL dist = this.getPackageUrl();
        if (dist == null) {
            return null;
        }
        Path targetPath = this.getTargetPath();
        if (IOUtils.isEmpty(targetPath)) {
            try {
                IOUtils.extract(dist, targetPath);
            }
            catch (IOException e) {
                throw new IOException(String.format("Failed to extract %s into %s", dist, targetPath), e);
            }
        }
        if ((execFile = (execDir = targetPath.resolve("dart-sass").toFile()).listFiles(pathname -> pathname.isFile() && pathname.getName().startsWith("sass"))) == null || execFile.length != 1) {
            throw new IllegalStateException("No (unique) executable file found in " + execDir);
        }
        File result = execFile[0];
        result.setExecutable(true, true);
        return result;
    }

    Path getTargetPath() throws IOException {
        String target;
        String dartSassVersion = PropertyUtils.getDartSassVersion();
        String hostVersion = PropertyUtils.getHostVersion();
        if (hostVersion == null || dartSassVersion == null) {
            Path tempDirectory = Files.createTempDirectory("dart-sass", new FileAttribute[0]);
            Runtime.getRuntime().addShutdownHook(new Thread(new DirCleaner(tempDirectory)));
            return tempDirectory;
        }
        File tmpDir = new File(System.getProperty("java.io.tmpdir"));
        File targetDir = new File(tmpDir, target = String.format("%s/%s/dart-sass/%s", this.getClass().getName(), hostVersion, dartSassVersion));
        if (targetDir.isDirectory() || targetDir.mkdirs()) {
            return targetDir.toPath();
        }
        throw new IOException(targetDir + " is not directory or can't be created");
    }

    @Nullable
    protected abstract URL getPackageUrl() throws IOException;
}

