/*
 * Decompiled with CFR 0.152.
 */
package de.larsgrefer.sass.embedded.functions;

import com.sass_lang.embedded_protocol.Value;
import de.larsgrefer.sass.embedded.util.ColorUtil;
import java.util.Locale;
import lombok.Generated;

public final class SassColor {
    public static Value.RgbColor adjustHue(Value.RgbColorOrBuilder color, double hue) {
        Value.HslColor hslColor = ColorUtil.toHslColor(color);
        return ColorUtil.toRgbColor((Value.HslColorOrBuilder)SassColor.adjustHue(hslColor, hue));
    }

    public static Value.HslColor adjustHue(Value.HslColor color, double hue) {
        double newHue = color.getHue() + hue;
        return color.toBuilder().setHue(SassColor.normalizeHue(newHue)).build();
    }

    public static Value.HwbColor adjustHue(Value.HwbColor color, double hue) {
        double newHue = color.getHue() + hue;
        return color.toBuilder().setHue(SassColor.normalizeHue(newHue)).build();
    }

    public static double alpha(Value.RgbColorOrBuilder color) {
        return color.getAlpha();
    }

    public static double alpha(Value.HslColorOrBuilder color) {
        return color.getAlpha();
    }

    public static double alpha(Value.HwbColorOrBuilder color) {
        return color.getAlpha();
    }

    public static double blackness(Value.RgbColorOrBuilder color) {
        return SassColor.blackness((Value.HwbColorOrBuilder)ColorUtil.toHwbColor(color));
    }

    public static double blackness(Value.HslColorOrBuilder color) {
        return SassColor.blackness((Value.HwbColorOrBuilder)ColorUtil.toHwbColor(color));
    }

    public static double blackness(Value.HwbColorOrBuilder color) {
        return color.getBlackness();
    }

    public static int blue(Value.RgbColorOrBuilder color) {
        return color.getBlue();
    }

    public static int blue(Value.HslColorOrBuilder color) {
        return SassColor.blue((Value.RgbColorOrBuilder)ColorUtil.toRgbColor(color));
    }

    public static int blue(Value.HwbColorOrBuilder color) {
        return SassColor.blue((Value.RgbColorOrBuilder)ColorUtil.toRgbColor(color));
    }

    public static Value.RgbColor complement(Value.RgbColorOrBuilder color) {
        return SassColor.adjustHue(color, 180.0);
    }

    public static Value.HslColor complement(Value.HslColor color) {
        return SassColor.adjustHue(color, 180.0);
    }

    public static Value.HwbColor complement(Value.HwbColor color) {
        return SassColor.adjustHue(color, 180.0);
    }

    public static Value.RgbColor darken(Value.RgbColorOrBuilder color, double amount) {
        return ColorUtil.toRgbColor((Value.HslColorOrBuilder)SassColor.darken(ColorUtil.toHslColor(color), amount));
    }

    public static Value.HslColor darken(Value.HslColor color, double amount) {
        double newLightness = color.getLightness() - amount;
        return color.toBuilder().setLightness(SassColor.normalize100(newLightness)).build();
    }

    public static Value.HwbColor darken(Value.HwbColorOrBuilder color, double amount) {
        return ColorUtil.toHwbColor((Value.HslColorOrBuilder)SassColor.darken(ColorUtil.toHslColor(color), amount));
    }

    public static Value.RgbColor desaturate(Value.RgbColorOrBuilder color, double amount) {
        return ColorUtil.toRgbColor((Value.HslColorOrBuilder)SassColor.desaturate(ColorUtil.toHslColor(color), amount));
    }

    public static Value.HslColor desaturate(Value.HslColor color, double amount) {
        double newSaturation = color.getSaturation() - amount;
        return color.toBuilder().setSaturation(SassColor.normalize100(newSaturation)).build();
    }

    public static Value.HwbColor desaturate(Value.HwbColorOrBuilder color, double amount) {
        return ColorUtil.toHwbColor((Value.HslColorOrBuilder)SassColor.desaturate(ColorUtil.toHslColor(color), amount));
    }

    public static Value.RgbColor grayscale(Value.RgbColorOrBuilder color) {
        return ColorUtil.toRgbColor((Value.HslColorOrBuilder)SassColor.grayscale(ColorUtil.toHslColor(color)));
    }

    public static Value.HslColor grayscale(Value.HslColor color) {
        return color.toBuilder().setSaturation(0.0).build();
    }

    public static Value.HwbColor grayscale(Value.HwbColorOrBuilder color) {
        return ColorUtil.toHwbColor((Value.HslColorOrBuilder)SassColor.grayscale(ColorUtil.toHslColor(color)));
    }

    public static int green(Value.RgbColorOrBuilder color) {
        return color.getGreen();
    }

    public static int green(Value.HslColorOrBuilder color) {
        return SassColor.green((Value.RgbColorOrBuilder)ColorUtil.toRgbColor(color));
    }

    public static int green(Value.HwbColorOrBuilder color) {
        return SassColor.green((Value.RgbColorOrBuilder)ColorUtil.toRgbColor(color));
    }

    public static double hue(Value.RgbColorOrBuilder color) {
        return SassColor.hue((Value.HslColorOrBuilder)ColorUtil.toHslColor(color));
    }

    public static double hue(Value.HslColorOrBuilder color) {
        return color.getHue();
    }

    public static double hue(Value.HwbColorOrBuilder color) {
        return color.getHue();
    }

    public static Value.HwbColor hwb(double hue, double whiteness, double blackness) {
        return SassColor.hwb(hue, whiteness, blackness, 1.0);
    }

    public static Value.HwbColor hwb(double hue, double whiteness, double blackness, double alpha) {
        return Value.HwbColor.newBuilder().setHue(hue).setWhiteness(whiteness).setBlackness(blackness).setAlpha(alpha).build();
    }

    public static Value.String ieHexStr(Value.RgbColor rgbColor) {
        int a = (int)Math.round(rgbColor.getAlpha() * 255.0);
        int value = (a & 0xFF) << 24 | (rgbColor.getRed() & 0xFF) << 16 | (rgbColor.getGreen() & 0xFF) << 8 | (rgbColor.getBlue() & 0xFF) << 0;
        return Value.String.newBuilder().setText("#" + Integer.toHexString(value).toUpperCase(Locale.ROOT)).setQuoted(false).build();
    }

    public static Value.String ieHexStr(Value.HslColor color) {
        return SassColor.ieHexStr(ColorUtil.toRgbColor((Value.HslColorOrBuilder)color));
    }

    public static Value.String ieHexStr(Value.HwbColor color) {
        return SassColor.ieHexStr(ColorUtil.toRgbColor((Value.HwbColorOrBuilder)color));
    }

    public static Value.RgbColor invert(Value.RgbColor color) {
        return SassColor.invert(color, 1.0);
    }

    public static Value.HslColor invert(Value.HslColor color) {
        return SassColor.invert(color, 1.0);
    }

    public static Value.HwbColor invert(Value.HwbColor color) {
        return SassColor.invert(color, 1.0);
    }

    public static Value.RgbColor invert(Value.RgbColor color, double weight) {
        if (weight < 0.0 || weight > 1.0) {
            throw new IllegalArgumentException("weight must be between 0 and 1");
        }
        Value.RgbColor inverse = color.toBuilder().setRed(255 - color.getRed()).setGreen(255 - color.getGreen()).setBlue(255 - color.getBlue()).build();
        return SassColor.mix(inverse, color, weight);
    }

    public static Value.HslColor invert(Value.HslColor color, double weight) {
        return ColorUtil.toHslColor((Value.RgbColorOrBuilder)SassColor.invert(ColorUtil.toRgbColor((Value.HslColorOrBuilder)color), weight));
    }

    public static Value.HwbColor invert(Value.HwbColor color, double weight) {
        return ColorUtil.toHwbColor((Value.RgbColorOrBuilder)SassColor.invert(ColorUtil.toRgbColor((Value.HwbColorOrBuilder)color), weight));
    }

    public static Value.RgbColor lighten(Value.RgbColor color, double amount) {
        return ColorUtil.toRgbColor((Value.HslColorOrBuilder)SassColor.lighten(ColorUtil.toHslColor((Value.RgbColorOrBuilder)color), amount));
    }

    public static Value.HslColor lighten(Value.HslColor color, double amount) {
        if (amount < 0.0 || amount > 100.0) {
            throw new IllegalArgumentException("amount");
        }
        return color.toBuilder().setLightness(SassColor.normalize100(color.getLightness() + amount)).build();
    }

    public static Value.HwbColor lighten(Value.HwbColor color, double amount) {
        return ColorUtil.toHwbColor((Value.HslColorOrBuilder)SassColor.lighten(ColorUtil.toHslColor((Value.HwbColorOrBuilder)color), amount));
    }

    public static double lightness(Value.RgbColor color) {
        return SassColor.lightness(ColorUtil.toHslColor((Value.RgbColorOrBuilder)color));
    }

    public static double lightness(Value.HslColor color) {
        return color.getLightness();
    }

    public static double lightness(Value.HwbColor color) {
        return SassColor.lightness(ColorUtil.toHslColor((Value.HwbColorOrBuilder)color));
    }

    public static Value.RgbColor mix(Value.RgbColor color1, Value.RgbColor color2) {
        return SassColor.mix(color1, color2, 0.5);
    }

    public static Value.HslColor mix(Value.HslColor color1, Value.HslColor color2) {
        return SassColor.mix(color1, color2, 0.5);
    }

    public static Value.HwbColor mix(Value.HwbColor color1, Value.HwbColor color2) {
        return SassColor.mix(color1, color2, 0.5);
    }

    public static Value.RgbColor mix(Value.RgbColor color1, Value.RgbColor color2, double weight) {
        if (weight <= 0.0) {
            return color2;
        }
        if (weight > 1.0) {
            return color1;
        }
        double normalizedWeight = weight * 2.0 - 1.0;
        double alphaDistance = color1.getAlpha() - color2.getAlpha();
        double combinedWeight1 = normalizedWeight * alphaDistance == -1.0 ? normalizedWeight : (normalizedWeight + alphaDistance) / (1.0 + normalizedWeight * alphaDistance);
        double weight1 = (combinedWeight1 + 1.0) / 2.0;
        double weight2 = 1.0 - weight1;
        int r = (int)Math.round((double)color1.getRed() * weight1 + (double)color2.getRed() * weight2);
        int g = (int)Math.round((double)color1.getGreen() * weight1 + (double)color2.getGreen() * weight2);
        int b = (int)Math.round((double)color1.getBlue() * weight1 + (double)color2.getBlue() * weight2);
        double a = color1.getAlpha() * weight + color2.getAlpha() * (1.0 - weight);
        return Value.RgbColor.newBuilder().setRed(r).setGreen(g).setBlue(b).setAlpha(a).build();
    }

    public static Value.HslColor mix(Value.HslColor color1, Value.HslColor color2, double weight) {
        Value.RgbColor mix = SassColor.mix(ColorUtil.toRgbColor((Value.HslColorOrBuilder)color1), ColorUtil.toRgbColor((Value.HslColorOrBuilder)color2), weight);
        return ColorUtil.toHslColor((Value.RgbColorOrBuilder)mix);
    }

    public static Value.HwbColor mix(Value.HwbColor color1, Value.HwbColor color2, double weight) {
        Value.RgbColor mix = SassColor.mix(ColorUtil.toRgbColor((Value.HwbColorOrBuilder)color1), ColorUtil.toRgbColor((Value.HwbColorOrBuilder)color2), weight);
        return ColorUtil.toHwbColor((Value.RgbColorOrBuilder)mix);
    }

    public static Value.RgbColor opacify(Value.RgbColor color, double amount) {
        if (amount < 0.0 || amount > 1.0) {
            throw new IllegalArgumentException("amount");
        }
        return color.toBuilder().setAlpha(SassColor.normalize1(color.getAlpha() + amount)).build();
    }

    public static Value.HslColor opacify(Value.HslColor color, double amount) {
        if (amount < 0.0 || amount > 1.0) {
            throw new IllegalArgumentException("amount");
        }
        return color.toBuilder().setAlpha(SassColor.normalize1(color.getAlpha() + amount)).build();
    }

    public static Value.HwbColor opacify(Value.HwbColor color, double amount) {
        if (amount < 0.0 || amount > 1.0) {
            throw new IllegalArgumentException("amount");
        }
        return color.toBuilder().setAlpha(SassColor.normalize1(color.getAlpha() + amount)).build();
    }

    public static int red(Value.RgbColor color) {
        return color.getRed();
    }

    public static int red(Value.HslColor color) {
        return SassColor.red(ColorUtil.toRgbColor((Value.HslColorOrBuilder)color));
    }

    public static int red(Value.HwbColor color) {
        return SassColor.red(ColorUtil.toRgbColor((Value.HwbColorOrBuilder)color));
    }

    public static Value.RgbColor saturate(Value.RgbColor color, double amount) {
        return ColorUtil.toRgbColor((Value.HslColorOrBuilder)SassColor.saturate(ColorUtil.toHslColor((Value.RgbColorOrBuilder)color), amount));
    }

    public static Value.HslColor saturate(Value.HslColor color, double amount) {
        if (amount < 0.0 || amount > 100.0) {
            throw new IllegalArgumentException("amount");
        }
        return color.toBuilder().setSaturation(SassColor.normalize100(color.getSaturation() + amount)).build();
    }

    public static Value.HwbColor saturate(Value.HwbColor color, double amount) {
        return ColorUtil.toHwbColor((Value.HslColorOrBuilder)SassColor.saturate(ColorUtil.toHslColor((Value.HwbColorOrBuilder)color), amount));
    }

    public static double saturation(Value.RgbColor color) {
        return SassColor.saturation(ColorUtil.toHslColor((Value.RgbColorOrBuilder)color));
    }

    public static double saturation(Value.HslColor color) {
        return color.getSaturation();
    }

    public static double saturation(Value.HwbColor color) {
        return SassColor.saturation(ColorUtil.toHslColor((Value.HwbColorOrBuilder)color));
    }

    public static Value.RgbColor transparentize(Value.RgbColor color, double amount) {
        if (amount < 0.0 || amount > 1.0) {
            throw new IllegalArgumentException("amount");
        }
        return color.toBuilder().setAlpha(SassColor.normalize1(color.getAlpha() - amount)).build();
    }

    public static Value.HslColor transparentize(Value.HslColor color, double amount) {
        if (amount < 0.0 || amount > 1.0) {
            throw new IllegalArgumentException("amount");
        }
        return color.toBuilder().setAlpha(SassColor.normalize1(color.getAlpha() - amount)).build();
    }

    public static Value.HwbColor transparentize(Value.HwbColor color, double amount) {
        if (amount < 0.0 || amount > 1.0) {
            throw new IllegalArgumentException("amount");
        }
        return color.toBuilder().setAlpha(SassColor.normalize1(color.getAlpha() - amount)).build();
    }

    public static double whiteness(Value.RgbColor color) {
        return SassColor.whiteness(ColorUtil.toHwbColor((Value.RgbColorOrBuilder)color));
    }

    public static double whiteness(Value.HslColor color) {
        return SassColor.whiteness(ColorUtil.toHwbColor((Value.HslColorOrBuilder)color));
    }

    public static double whiteness(Value.HwbColor color) {
        return color.getWhiteness();
    }

    static double normalizeHue(double hue) {
        if ((hue %= 360.0) < 0.0) {
            hue += 360.0;
        }
        return hue;
    }

    static double normalize1(double number) {
        if (number < 0.0) {
            return 0.0;
        }
        if (number > 1.0) {
            return 1.0;
        }
        return number;
    }

    static double normalize100(double number) {
        if (number < 0.0) {
            return 0.0;
        }
        if (number > 100.0) {
            return 100.0;
        }
        return number;
    }

    @Generated
    private SassColor() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

