/*
 * Decompiled with CFR 0.152.
 */
package de.larsgrefer.sass.embedded.util;

import androidx.annotation.RequiresApi;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RequiresApi(value=10000)
public class DirCleaner
implements Runnable {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DirCleaner.class);
    private final Path path;

    @Override
    public void run() {
        if (!Files.exists(this.path, new LinkOption[0])) {
            return;
        }
        try {
            Files.walkFileTree(this.path, new DeletingFileVisitor());
        }
        catch (IOException e) {
            log.warn("Failed to delete {}", (Object)this.path, (Object)e);
        }
    }

    @Generated
    public DirCleaner(Path path) {
        this.path = path;
    }

    private static class DeletingFileVisitor
    extends SimpleFileVisitor<Path> {
        private DeletingFileVisitor() {
        }

        @Override
        public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
            Files.delete(file);
            return FileVisitResult.CONTINUE;
        }

        @Override
        public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
            if (exc != null) {
                throw exc;
            }
            Files.delete(dir);
            return FileVisitResult.CONTINUE;
        }
    }
}

