/* Copyright (C) 2013-2023 TU Dortmund
 * This file is part of LearnLib, http://www.learnlib.de/.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package de.learnlib.algorithm;

import de.learnlib.oracle.MembershipOracle;
import net.automatalib.alphabet.Alphabet;

/**
 * A simplified view on the constructor of a {@link LearningAlgorithm}, that only requires an {@link Alphabet}
 * definition and a {@link MembershipOracle}.
 *
 * @param <L>
 *         learner type
 * @param <I>
 *         input symbol type
 * @param <D>
 *         output domain type
 */
public interface LearnerConstructor<L extends LearningAlgorithm<?, I, D>, I, D> {

    /**
     * Construct the learner instance.
     *
     * @param alphabet
     *         the (initial) alphabet for the learner
     * @param oracle
     *         the oracle for answering queries
     *
     * @return the learner instance
     */
    L constructLearner(Alphabet<I> alphabet, MembershipOracle<I, D> oracle);

}
