/*
 * Decompiled with CFR 0.152.
 */
package de.learnlib.algorithm;

import de.learnlib.query.DefaultQuery;
import net.automatalib.automaton.fsa.DFA;
import net.automatalib.automaton.fsa.NFA;
import net.automatalib.automaton.transducer.MealyMachine;
import net.automatalib.automaton.transducer.MooreMachine;
import net.automatalib.word.Word;

public interface LearningAlgorithm<M, I, D> {
    public void startLearning();

    public boolean refineHypothesis(DefaultQuery<I, D> var1);

    public M getHypothesisModel();

    public static interface NFALearner<I>
    extends LearningAlgorithm<NFA<?, I>, I, Boolean> {
    }

    public static interface MooreLearner<I, O>
    extends LearningAlgorithm<MooreMachine<?, I, ?, O>, I, Word<O>> {
    }

    public static interface MealyLearner<I, O>
    extends LearningAlgorithm<MealyMachine<?, I, ?, O>, I, Word<O>> {
    }

    public static interface DFALearner<I>
    extends LearningAlgorithm<DFA<?, I>, I, Boolean> {
    }
}

