/*
 * Decompiled with CFR 0.152.
 */
package de.learnlib.oracle;

import de.learnlib.query.DefaultQuery;
import java.util.Collection;
import net.automatalib.automaton.DeterministicAutomaton;
import net.automatalib.automaton.fsa.DFA;
import net.automatalib.automaton.transducer.MealyMachine;
import net.automatalib.word.Word;
import org.checkerframework.checker.nullness.qual.Nullable;

public interface AutomatonOracle<A extends DeterministicAutomaton<?, I, ?>, I, D> {
    public boolean isCounterExample(A var1, Iterable<? extends I> var2, D var3);

    public @Nullable Word<I> nextInput();

    public void addWord(Word<I> var1);

    public void pre();

    public double getMultiplier();

    public void setMultiplier(double var1);

    public DefaultQuery<I, D> processInput(A var1, Word<I> var2);

    default public void addWords(A hypothesis, Collection<? extends I> inputs, Word<I> prefix) {
        for (I i : inputs) {
            Word word = prefix.append(i);
            if (hypothesis.getStates((Iterable)word).isEmpty()) continue;
            this.addWord(word);
        }
    }

    public boolean accepts(A var1, Iterable<? extends I> var2);

    default public @Nullable DefaultQuery<I, D> findCounterExample(A hypothesis, Collection<? extends I> inputs, int maxQueries) {
        this.pre();
        DefaultQuery<I, D> ce = null;
        int queries = 0;
        Word<I> input = this.nextInput();
        while (input != null && ce == null && queries != maxQueries) {
            this.addWords(hypothesis, inputs, input);
            if (this.accepts(hypothesis, (Iterable<? extends I>)input)) {
                DefaultQuery<I, D> query = this.processInput(hypothesis, input);
                ce = this.isCounterExample(hypothesis, (Iterable<? extends I>)query.getInput(), query.getOutput()) ? query : null;
                ++queries;
            }
            input = this.nextInput();
        }
        return ce;
    }

    default public @Nullable DefaultQuery<I, D> findCounterExample(A hypothesis, Collection<? extends I> inputs) {
        return this.findCounterExample(hypothesis, inputs, (int)((double)hypothesis.size() * this.getMultiplier()));
    }

    public static interface MealyOracle<I, O>
    extends AutomatonOracle<MealyMachine<?, I, ?, O>, I, Word<O>> {
        @Override
        default public boolean accepts(MealyMachine<?, I, ?, O> hypothesis, Iterable<? extends I> input) {
            return hypothesis.computeOutput(input) != null;
        }
    }

    public static interface DFAOracle<I>
    extends AutomatonOracle<DFA<?, I>, I, Boolean> {
        @Override
        default public boolean accepts(DFA<?, I> hypothesis, Iterable<? extends I> input) {
            return hypothesis.accepts(input);
        }
    }
}

