/*
 * Decompiled with CFR 0.152.
 */
package de.learnlib.query;

import de.learnlib.query.DefaultQuery;
import java.util.Objects;
import net.automatalib.word.Word;
import net.automatalib.word.WordBuilder;
import org.checkerframework.checker.nullness.qual.Nullable;

public class OmegaQuery<I, D> {
    private final Word<I> prefix;
    private final Word<I> loop;
    private final int repeat;
    private @Nullable D output;
    private int periodicity;

    public OmegaQuery(Word<I> prefix, Word<I> loop, int repeat) {
        this.prefix = prefix;
        this.loop = loop;
        this.repeat = repeat;
    }

    public void answer(@Nullable D output, int periodicity) {
        this.output = output;
        this.periodicity = periodicity;
    }

    public Word<I> getPrefix() {
        return this.prefix;
    }

    public Word<I> getLoop() {
        return this.loop;
    }

    public int getRepeat() {
        return this.repeat;
    }

    public @Nullable D getOutput() {
        return this.output;
    }

    public int getPeriodicity() {
        return this.periodicity;
    }

    public boolean isUltimatelyPeriodic() {
        return this.periodicity > 0;
    }

    public DefaultQuery<I, @Nullable D> asDefaultQuery() {
        WordBuilder wb = new WordBuilder(this.prefix.length() + this.loop.length() * this.periodicity);
        wb.append(this.prefix);
        wb.repeatAppend(this.periodicity, this.loop);
        return new DefaultQuery(wb.toWord(), this.output);
    }

    public String toString() {
        return "OmegaQuery{prefix=" + this.prefix + ", loop=" + this.loop + ", repeat=" + this.repeat + ", output=" + this.output + ", periodicity=" + this.periodicity + '}';
    }

    public final boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof OmegaQuery)) {
            return false;
        }
        OmegaQuery that = (OmegaQuery)o;
        return this.periodicity == that.periodicity && Objects.equals(this.prefix, that.prefix) && Objects.equals(this.loop, that.loop) && Objects.equals(this.output, that.output);
    }

    public final int hashCode() {
        int result = 1;
        result = 31 * result + Objects.hashCode(this.prefix);
        result = 31 * result + Objects.hashCode(this.loop);
        result = 31 * result + Objects.hashCode(this.output);
        result = 31 * result + Integer.hashCode(this.periodicity);
        return result;
    }
}

