/*
 * Decompiled with CFR 0.152.
 */
package de.learnlib.eqtests.basic;

import de.learnlib.api.EquivalenceOracle;
import de.learnlib.api.MembershipOracle;
import de.learnlib.oracles.DefaultQuery;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import net.automatalib.automata.concepts.DetOutputAutomaton;
import net.automatalib.commons.util.collections.CollectionsUtil;
import net.automatalib.words.Word;

public class CompleteExplorationEQOracle<I, O>
implements EquivalenceOracle<DetOutputAutomaton<?, I, ?, O>, I, O> {
    private int minDepth;
    private int maxDepth;
    private final MembershipOracle<I, O> sulOracle;

    public CompleteExplorationEQOracle(MembershipOracle<I, O> sulOracle, int maxDepth) {
        this(sulOracle, 1, maxDepth);
    }

    public CompleteExplorationEQOracle(MembershipOracle<I, O> sulOracle, int minDepth, int maxDepth) {
        if (maxDepth < minDepth) {
            maxDepth = minDepth;
        }
        this.minDepth = minDepth;
        this.maxDepth = maxDepth;
        this.sulOracle = sulOracle;
    }

    public DefaultQuery<I, O> findCounterExample(DetOutputAutomaton<?, I, ?, O> hypothesis, Collection<? extends I> alphabet) {
        for (List symList : CollectionsUtil.allTuples(alphabet, (int)this.minDepth, (int)this.maxDepth)) {
            Word queryWord = Word.fromList((List)symList);
            DefaultQuery query = new DefaultQuery(queryWord);
            Object hypOutput = hypothesis.computeOutput((Iterable)queryWord);
            this.sulOracle.processQueries(Collections.singleton(query));
            if (Objects.equals(hypOutput, query.getOutput())) continue;
            return query;
        }
        return null;
    }
}

