/*
 * Decompiled with CFR 0.152.
 */
package de.learnlib.eqtests.basic;

import de.learnlib.api.EquivalenceOracle;
import de.learnlib.oracles.DefaultQuery;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import net.automatalib.automata.fsa.DFA;
import net.automatalib.automata.transout.MealyMachine;
import net.automatalib.words.Word;

public class EQOracleChain<A, I, O>
implements EquivalenceOracle<A, I, O> {
    private final List<EquivalenceOracle<? super A, I, O>> oracles;

    public EQOracleChain(List<? extends EquivalenceOracle<? super A, I, O>> oracles) {
        this.oracles = new ArrayList<EquivalenceOracle<A, I, O>>(oracles);
    }

    @SafeVarargs
    public EQOracleChain(EquivalenceOracle<? super A, I, O> ... oracles) {
        this(Arrays.asList(oracles));
    }

    public DefaultQuery<I, O> findCounterExample(A hypothesis, Collection<? extends I> inputs) {
        for (EquivalenceOracle<? super A, I, O> equivalenceOracle : this.oracles) {
            DefaultQuery ceQry = equivalenceOracle.findCounterExample(hypothesis, inputs);
            if (ceQry == null) continue;
            return ceQry;
        }
        return null;
    }

    public static class MealyEQOracleChain<I, O>
    extends EQOracleChain<MealyMachine<?, I, ?, O>, I, Word<O>> {
        @SafeVarargs
        public MealyEQOracleChain(EquivalenceOracle<? super MealyMachine<?, I, ?, O>, I, Word<O>> ... oracles) {
            super(oracles);
        }

        public MealyEQOracleChain(List<? extends EquivalenceOracle<? super MealyMachine<?, I, ?, O>, I, Word<O>>> oracles) {
            super(oracles);
        }
    }

    public static class DFAEQOracleChain<I>
    extends EQOracleChain<DFA<?, I>, I, Boolean>
    implements EquivalenceOracle.DFAEquivalenceOracle<I> {
        @SafeVarargs
        public DFAEQOracleChain(EquivalenceOracle<? super DFA<?, I>, I, Boolean> ... oracles) {
            super(oracles);
        }

        public DFAEQOracleChain(List<? extends EquivalenceOracle<? super DFA<?, I>, I, Boolean>> oracles) {
            super(oracles);
        }
    }
}

