/*
 * Decompiled with CFR 0.152.
 */
package de.learnlib.algorithms.lstargeneric;

import de.learnlib.algorithms.lstargeneric.ce.ObservationTableCEXHandlers;
import de.learnlib.algorithms.lstargeneric.table.Inconsistency;
import de.learnlib.algorithms.lstargeneric.table.ObservationTable;
import de.learnlib.algorithms.lstargeneric.table.Row;
import de.learnlib.api.LearningAlgorithm;
import de.learnlib.api.MembershipOracle;
import de.learnlib.oracles.DefaultQuery;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.automatalib.words.Alphabet;
import net.automatalib.words.Word;

public abstract class AbstractLStar<A, I, O>
implements LearningAlgorithm<A, I, O> {
    protected final Alphabet<? extends I> alphabet;
    protected final MembershipOracle<I, O> oracle;
    protected final ObservationTable<I, O> table;

    public AbstractLStar(Alphabet<I> alphabet, MembershipOracle<I, O> oracle) {
        this.alphabet = alphabet;
        this.oracle = oracle;
        this.table = new ObservationTable(alphabet);
    }

    public void startLearning() {
        List<Word<I>> suffixes = this.initialSuffixes();
        List<List<Row<I>>> initialUnclosed = this.table.initialize(suffixes, this.oracle);
        this.completeConsistentTable(initialUnclosed, false);
    }

    public final boolean refineHypothesis(DefaultQuery<I, O> ceQuery) {
        int oldDistinctRows = this.table.numDistinctRows();
        this.doRefineHypothesis(ceQuery);
        return this.table.numDistinctRows() > oldDistinctRows;
    }

    protected void doRefineHypothesis(DefaultQuery<I, O> ceQuery) {
        List<List<Row<I>>> unclosed = this.incorporateCounterExample(ceQuery);
        this.completeConsistentTable(unclosed, true);
    }

    protected void completeConsistentTable(List<List<Row<I>>> unclosed, boolean checkConsistency) {
        while (true) {
            if (!unclosed.isEmpty()) {
                List<Row<I>> closingRows = this.selectClosingRows(unclosed);
                unclosed = this.table.toShortPrefixes(closingRows, this.oracle);
                continue;
            }
            if (checkConsistency) {
                Inconsistency<I, O> incons = null;
                do {
                    if ((incons = this.table.findInconsistency()) == null) continue;
                    Word<I> newSuffix = this.analyzeInconsistency(incons);
                    unclosed = this.table.addSuffix(newSuffix, this.oracle);
                } while (unclosed.isEmpty() && incons != null);
            }
            if (unclosed.isEmpty()) break;
        }
    }

    protected Word<I> analyzeInconsistency(Inconsistency<I, O> incons) {
        int inputIdx = incons.getInputIndex();
        Row<I> succRow1 = incons.getFirstRow().getSuccessor(inputIdx);
        Row<I> succRow2 = incons.getSecondRow().getSuccessor(inputIdx);
        int numSuffixes = this.table.numSuffixes();
        List<O> contents1 = this.table.rowContents(succRow1);
        List<O> contents2 = this.table.rowContents(succRow2);
        for (int i = 0; i < numSuffixes; ++i) {
            O val2;
            O val1 = contents1.get(i);
            if (Objects.equals(val1, val2 = contents2.get(i))) continue;
            Object sym = this.alphabet.getSymbol(inputIdx);
            Word<I> suffix = this.table.getSuffixes().get(i);
            return suffix.prepend(sym);
        }
        throw new IllegalArgumentException("Bogus inconsistency");
    }

    protected List<List<Row<I>>> incorporateCounterExample(DefaultQuery<I, O> ce) {
        return ObservationTableCEXHandlers.handleClassicLStar(ce, this.table, this.oracle);
    }

    protected List<Row<I>> selectClosingRows(List<List<Row<I>>> unclosed) {
        ArrayList<Row<I>> closingRows = new ArrayList<Row<I>>(unclosed.size());
        for (List<Row<I>> rowList : unclosed) {
            closingRows.add(rowList.get(0));
        }
        return closingRows;
    }

    protected abstract List<Word<I>> initialSuffixes();
}

