/*
 * Decompiled with CFR 0.152.
 */
package de.learnlib.algorithms.lstargeneric;

import de.learnlib.algorithms.lstargeneric.AbstractAutomatonLStar;
import de.learnlib.algorithms.lstargeneric.ce.ObservationTableCEXHandler;
import de.learnlib.algorithms.lstargeneric.closing.ClosingStrategy;
import de.learnlib.algorithms.lstargeneric.table.Row;
import de.learnlib.api.MembershipOracle;
import de.learnlib.oracles.DefaultQuery;
import java.util.List;
import net.automatalib.automata.MutableDeterministic;
import net.automatalib.automata.concepts.SuffixOutput;
import net.automatalib.words.Alphabet;
import net.automatalib.words.Word;

public abstract class ExtensibleAutomatonLStar<A, I, O, S, T, SP, TP, AI extends MutableDeterministic<S, I, T, SP, TP>>
extends AbstractAutomatonLStar<A, I, O, S, T, SP, TP, AI> {
    protected final ObservationTableCEXHandler<? super I, ? super O> cexHandler;
    protected final ClosingStrategy<? super I, ? super O> closingStrategy;
    protected final List<Word<I>> initialSuffixes;

    public ExtensibleAutomatonLStar(Alphabet<I> alphabet, MembershipOracle<I, O> oracle, AI internalHyp, List<Word<I>> initialSuffixes, ObservationTableCEXHandler<? super I, ? super O> cexHandler, ClosingStrategy<? super I, ? super O> closingStrategy) {
        super(alphabet, oracle, internalHyp);
        this.initialSuffixes = initialSuffixes;
        this.cexHandler = cexHandler;
        this.closingStrategy = closingStrategy;
    }

    @Override
    protected void doRefineHypothesis(DefaultQuery<I, O> ceQuery) {
        List<List<Row<I>>> unclosed = this.cexHandler.handleCounterexample(ceQuery, this.table, this.hypothesisOutput(), this.oracle);
        this.completeConsistentTable(unclosed, this.cexHandler.needsConsistencyCheck());
    }

    @Override
    protected List<Row<I>> selectClosingRows(List<List<Row<I>>> unclosed) {
        return this.closingStrategy.selectClosingRows(unclosed, this.table, this.oracle);
    }

    @Override
    protected List<Word<I>> initialSuffixes() {
        return this.initialSuffixes;
    }

    protected abstract SuffixOutput<I, O> hypothesisOutput();
}

