/*
 * Decompiled with CFR 0.152.
 */
package de.learnlib.algorithms.lstargeneric.ce;

import de.learnlib.algorithms.lstargeneric.ce.ObservationTableCEXHandler;
import de.learnlib.algorithms.lstargeneric.table.ObservationTable;
import de.learnlib.algorithms.lstargeneric.table.Row;
import de.learnlib.api.MembershipOracle;
import de.learnlib.api.Query;
import de.learnlib.counterexamples.GlobalSuffixFinder;
import de.learnlib.counterexamples.GlobalSuffixFinders;
import de.learnlib.counterexamples.LocalSuffixFinder;
import de.learnlib.counterexamples.LocalSuffixFinders;
import de.learnlib.oracles.DefaultQuery;
import java.util.Collections;
import java.util.List;
import net.automatalib.automata.concepts.SuffixOutput;
import net.automatalib.words.Word;

public class ObservationTableCEXHandlers {
    public static ObservationTableCEXHandler<Object, Object> CLASSIC_LSTAR = new ObservationTableCEXHandler<Object, Object>(){

        @Override
        public <RI, RO> List<List<Row<RI>>> handleCounterexample(DefaultQuery<RI, RO> ceQuery, ObservationTable<RI, RO> table, SuffixOutput<RI, RO> hypOutput, MembershipOracle<RI, RO> oracle) {
            return ObservationTableCEXHandlers.handleClassicLStar(ceQuery, table, oracle);
        }

        @Override
        public boolean needsConsistencyCheck() {
            return true;
        }
    };
    public static ObservationTableCEXHandler<Object, Object> SUFFIX1BY1 = new ObservationTableCEXHandler<Object, Object>(){

        @Override
        public <RI, RO> List<List<Row<RI>>> handleCounterexample(DefaultQuery<RI, RO> ceQuery, ObservationTable<RI, RO> table, SuffixOutput<RI, RO> hypOutput, MembershipOracle<RI, RO> oracle) {
            return ObservationTableCEXHandlers.handleSuffix1by1(ceQuery, table, oracle);
        }

        @Override
        public boolean needsConsistencyCheck() {
            return false;
        }
    };
    public static ObservationTableCEXHandler<Object, Object> MAHLER_PNUELI = ObservationTableCEXHandlers.fromGlobalSuffixFinder(GlobalSuffixFinders.MAHLER_PNUELI);
    public static ObservationTableCEXHandler<Object, Object> SHAHBAZ = ObservationTableCEXHandlers.fromGlobalSuffixFinder(GlobalSuffixFinders.SHAHBAZ);
    public static ObservationTableCEXHandler<Object, Object> FIND_LINEAR = ObservationTableCEXHandlers.fromLocalSuffixFinder(LocalSuffixFinders.FIND_LINEAR, false);
    public static ObservationTableCEXHandler<Object, Object> FIND_LINEAR_ALLSUFFIXES = ObservationTableCEXHandlers.fromLocalSuffixFinder(LocalSuffixFinders.FIND_LINEAR, true);
    public static ObservationTableCEXHandler<Object, Object> FIND_LINEAR_REVERSE = ObservationTableCEXHandlers.fromLocalSuffixFinder(LocalSuffixFinders.FIND_LINEAR_REVERSE, false);
    public static ObservationTableCEXHandler<Object, Object> FIND_LINEAR_REVERSE_ALLSUFFIXES = ObservationTableCEXHandlers.fromLocalSuffixFinder(LocalSuffixFinders.FIND_LINEAR_REVERSE, true);
    public static ObservationTableCEXHandler<Object, Object> RIVEST_SCHAPIRE = ObservationTableCEXHandlers.fromLocalSuffixFinder(LocalSuffixFinders.RIVEST_SCHAPIRE, false);
    public static ObservationTableCEXHandler<Object, Object> RIVEST_SCHAPIRE_ALLSUFFIXES = ObservationTableCEXHandlers.fromLocalSuffixFinder(LocalSuffixFinders.RIVEST_SCHAPIRE, true);

    public static <I, O> ObservationTableCEXHandler<I, O> fromGlobalSuffixFinder(final GlobalSuffixFinder<I, O> globalFinder) {
        return new ObservationTableCEXHandler<I, O>(){

            @Override
            public <RI extends I, RO extends O> List<List<Row<RI>>> handleCounterexample(DefaultQuery<RI, RO> ceQuery, ObservationTable<RI, RO> table, SuffixOutput<RI, RO> hypOutput, MembershipOracle<RI, RO> oracle) {
                List suffixes = globalFinder.findSuffixes(ceQuery, table, hypOutput, oracle);
                return ObservationTableCEXHandlers.handleGlobalSuffixes(table, suffixes, oracle);
            }

            @Override
            public boolean needsConsistencyCheck() {
                return false;
            }
        };
    }

    public static <I, O> ObservationTableCEXHandler<I, O> fromLocalSuffixFinder(final LocalSuffixFinder<I, O> localFinder, final boolean allSuffixes) {
        return new ObservationTableCEXHandler<I, O>(){

            @Override
            public <RI extends I, RO extends O> List<List<Row<RI>>> handleCounterexample(DefaultQuery<RI, RO> ceQuery, ObservationTable<RI, RO> table, SuffixOutput<RI, RO> hypOutput, MembershipOracle<RI, RO> oracle) {
                int suffixIdx = localFinder.findSuffixIndex(ceQuery, table, hypOutput, oracle);
                return ObservationTableCEXHandlers.handleLocalSuffix(ceQuery, table, suffixIdx, allSuffixes, oracle);
            }

            @Override
            public boolean needsConsistencyCheck() {
                return false;
            }
        };
    }

    public static <I, O> ObservationTableCEXHandler<I, O> fromLocalSuffixFinder(LocalSuffixFinder<I, O> localFinder) {
        return ObservationTableCEXHandlers.fromLocalSuffixFinder(localFinder, false);
    }

    public static <I, O> List<List<Row<I>>> handleClassicLStar(DefaultQuery<I, O> ceQuery, ObservationTable<I, O> table, MembershipOracle<I, O> oracle) {
        List prefixes = ceQuery.getInput().prefixes(false);
        return table.addShortPrefixes(prefixes, oracle);
    }

    public static <I, O> List<List<Row<I>>> handleSuffix1by1(DefaultQuery<I, O> ceQuery, ObservationTable<I, O> table, MembershipOracle<I, O> oracle) {
        List<List<Row<I>>> unclosed = Collections.emptyList();
        List<Word<I>> suffixes = table.getSuffixes();
        Word ceWord = ceQuery.getInput();
        int ceLen = ceWord.length();
        for (int i = 1; i <= ceLen; ++i) {
            Word suffix = ceWord.suffix(i);
            if (suffixes != null) {
                if (suffixes.contains(suffix)) continue;
                suffixes = null;
            }
            if (!(unclosed = table.addSuffix(suffix, oracle)).isEmpty()) break;
        }
        return unclosed;
    }

    public static <I, O> List<List<Row<I>>> handleGlobalSuffixes(ObservationTable<I, O> table, List<Word<I>> suffixes, MembershipOracle<I, O> oracle) {
        return table.addSuffixes(suffixes, oracle);
    }

    public static <I, O> List<List<Row<I>>> handleLocalSuffix(Query<I, O> ceQuery, ObservationTable<I, O> table, int suffixIndex, boolean allSuffixes, MembershipOracle<I, O> oracle) {
        List suffixes = GlobalSuffixFinders.suffixesForLocalOutput(ceQuery, (int)suffixIndex, (boolean)allSuffixes);
        return ObservationTableCEXHandlers.handleGlobalSuffixes(table, suffixes, oracle);
    }

    public static <I, O> List<List<Row<I>>> handleLocalSuffix(Query<I, O> ceQuery, ObservationTable<I, O> table, int suffixIndex, MembershipOracle<I, O> oracle) {
        return ObservationTableCEXHandlers.handleLocalSuffix(ceQuery, table, suffixIndex, false, oracle);
    }
}

