/*
 * Decompiled with CFR 0.152.
 */
package de.learnlib.algorithms.lstargeneric.closing;

import de.learnlib.algorithms.lstargeneric.closing.CloseRandomStrategy;
import de.learnlib.algorithms.lstargeneric.closing.ClosingStrategy;
import de.learnlib.algorithms.lstargeneric.table.ObservationTable;
import de.learnlib.algorithms.lstargeneric.table.Row;
import de.learnlib.api.MembershipOracle;
import java.util.ArrayList;
import java.util.List;
import net.automatalib.commons.util.comparison.CmpUtil;
import net.automatalib.words.Alphabet;

public class ClosingStrategies {
    public static final ClosingStrategy<Object, Object> CLOSE_RANDOM = new CloseRandomStrategy();
    public static final ClosingStrategy<Object, Object> CLOSE_FIRST = new ClosingStrategy<Object, Object>(){

        @Override
        public <RI, RO> List<Row<RI>> selectClosingRows(List<List<Row<RI>>> unclosedClasses, ObservationTable<RI, RO> table, MembershipOracle<RI, RO> oracle) {
            ArrayList<Row<RI>> result = new ArrayList<Row<RI>>(unclosedClasses.size());
            for (List<Row<RI>> clazz : unclosedClasses) {
                result.add(clazz.get(0));
            }
            return result;
        }
    };
    public static final ClosingStrategy<Object, Object> CLOSE_SHORTEST = new ClosingStrategy<Object, Object>(){

        @Override
        public <RI, RO> List<Row<RI>> selectClosingRows(List<List<Row<RI>>> unclosedClasses, ObservationTable<RI, RO> table, MembershipOracle<RI, RO> oracle) {
            ArrayList<Row<RI>> result = new ArrayList<Row<RI>>();
            for (List<Row<RI>> clazz : unclosedClasses) {
                Row<RI> shortest = null;
                int shortestLen = Integer.MAX_VALUE;
                for (Row<RI> row : clazz) {
                    int prefixLen = row.getPrefix().length();
                    if (shortest != null && prefixLen >= shortestLen) continue;
                    shortest = row;
                    shortestLen = prefixLen;
                }
                result.add(shortest);
            }
            return result;
        }
    };
    public static final ClosingStrategy<Object, Object> CLOSE_LEX_MIN = new ClosingStrategy<Object, Object>(){

        @Override
        public <RI, RO> List<Row<RI>> selectClosingRows(List<List<Row<RI>>> unclosedClasses, ObservationTable<RI, RO> table, MembershipOracle<RI, RO> oracle) {
            ArrayList<Row<RI>> result = new ArrayList<Row<RI>>(unclosedClasses.size());
            Alphabet<RI> alphabet = table.getInputAlphabet();
            for (List<Row<RI>> clazz : unclosedClasses) {
                Row<RI> lexMin = null;
                for (Row<RI> row : clazz) {
                    if (lexMin == null) {
                        lexMin = row;
                        continue;
                    }
                    if (CmpUtil.lexCompare(row.getPrefix(), lexMin.getPrefix(), alphabet) >= 0) continue;
                    lexMin = row;
                }
                result.add(lexMin);
            }
            return result;
        }
    };
}

